/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report.data.hibernate;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.report.data.hibernate.HibernateReportDataDAO;
import gov.va.med.fw.util.ReflectionException;
import gov.va.med.fw.util.Reflector;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;

public abstract class ConfigurableReportDataDAO
extends HibernateReportDataDAO {
    private static final long serialVersionUID = -8745384804766807093L;
    private String methodName = null;
    private String subReportMethodName = null;
    private String postDataRetrievalMethodName = null;
    private String subReportPostDataRetrievalMethodName = null;
    private String preDataRetrievalMethodName = null;

    protected ConfigurableReportDataDAO() {
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setPostDataRetrievalMethodName(String postDataRetrievalMethodName) {
        this.postDataRetrievalMethodName = postDataRetrievalMethodName;
    }

    public void setPreDataRetrievalMethodName(String preDataRetrievalMethodName) {
        this.preDataRetrievalMethodName = preDataRetrievalMethodName;
    }

    public void setSubReportMethodName(String subReportMethodName) {
        this.subReportMethodName = subReportMethodName;
    }

    public void setSubReportPostDataRetrievalMethodName(String subReportPostDataRetrievalMethodName) {
        this.subReportPostDataRetrievalMethodName = subReportPostDataRetrievalMethodName;
    }

    @Override
    public List postDataRetrieval(List results, ReportConfiguration config) throws ReportDataException {
        String methodName;
        String string = methodName = this.isSubReportPresent(config) ? this.subReportPostDataRetrievalMethodName : this.postDataRetrievalMethodName;
        if (methodName != null) {
            Object result = this.invokeMethod(methodName, new Object[]{results, config});
            return result instanceof List ? (List)result : null;
        }
        return super.postDataRetrieval(results, config);
    }

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        if (this.preDataRetrievalMethodName != null) {
            this.invokeMethod(this.preDataRetrievalMethodName, new Object[]{config});
        }
    }

    @Override
    protected void initDao() throws Exception {
        super.initDao();
        Validate.notNull((Object)this.methodName, (String)"A name of a method to be invoked must be configured");
    }

    protected boolean isSubReportPresent(ReportConfiguration config) {
        boolean exist = false;
        QueryCriteria criteria = config.getQueryCriteria();
        QueryCriteria subCriteria = criteria != null ? criteria.getSubReportCriteria() : null;
        exist = subCriteria != null && (this.subReportMethodName != null || this.subReportPostDataRetrievalMethodName != null);
        return exist;
    }

    protected Query buildQuery(ReportConfiguration config) throws ReportDataException {
        String derivedMethodName = this.isSubReportPresent(config) ? this.subReportMethodName : this.methodName;
        Object result = this.invokeMethod(derivedMethodName, new Object[]{config});
        return result instanceof Query ? (Query)result : null;
    }

    protected Object invokeMethod(String name, Object[] params) throws ReportDataException {
        Object result = null;
        try {
            result = Reflector.invoke(this, name, params);
        }
        catch (InvocationTargetException e) {
            throw new ReportDataException("Failed to invoke method: " + this.methodName + " to build a query criteria");
        }
        catch (NoSuchMethodException e) {
            throw new ReportDataException("Failed to find method: " + this.methodName + " to build a query criteria");
        }
        catch (ReflectionException e) {
            throw new ReportDataException("Exception thrown in method: " + this.methodName + " to build a query criteria");
        }
        return result;
    }
}

