/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report.data;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportNameResolver;
import gov.va.med.fw.report.SimpleReportNameResolver;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.data.ReportDataDAO;
import gov.va.med.fw.report.data.ReportDataService;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Map;
import org.apache.commons.lang.Validate;

public abstract class AbstractReportDataService
extends AbstractComponent
implements ReportDataService {
    private static final long serialVersionUID = -2827771775513302070L;
    private Map reportDataDAOs = null;
    private ReportNameResolver nameResolver = null;

    public ReportNameResolver getNameResolver() {
        return this.nameResolver;
    }

    public void setNameResolver(ReportNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public void setReportDataDAOs(Map reportDataDAOs) {
        this.reportDataDAOs = reportDataDAOs;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Validate.notEmpty((Map)this.reportDataDAOs, (String)"A report DAO map must be configured");
        if (this.nameResolver == null) {
            this.nameResolver = new SimpleReportNameResolver();
        }
    }

    @Override
    public ReportData requestReportData(ReportConfiguration config) throws ReportException {
        Validate.notNull((Object)config, (String)"A report configuration must not be NULL");
        Validate.notNull((Object)config.getQueryCriteria(), (String)"A report query criteria must not be NULL");
        ReportDataDAO dao = this.getReportDataDAO(config);
        dao.preDataRetrieval(config);
        return this.doRequestData(config);
    }

    protected ReportDataDAO getReportDataDAO(ReportConfiguration config) throws ReportException {
        String name = this.nameResolver.getReportName(config);
        if (!this.reportDataDAOs.containsKey(name)) {
            throw new ReportException("A report data DAO is missing for report: " + name);
        }
        Object componentName = this.reportDataDAOs.get(name);
        try {
            Object dao = this.getComponent((String)componentName);
            return (ReportDataDAO)dao;
        }
        catch (Exception e) {
            throw new ReportException("A report data dao " + componentName + " is not defined", e);
        }
    }

    protected abstract ReportData doRequestData(ReportConfiguration var1) throws ReportException;
}

