/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report;

import gov.va.med.fw.report.ConfigurableReportBuilder;
import gov.va.med.fw.report.ReportBuilder;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportService;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import org.apache.commons.lang.Validate;

public class SynchronousReportService
extends AbstractComponent
implements ReportService {
    private static final long serialVersionUID = -3557958044224151158L;

    @Override
    public void generateReport(ReportConfiguration configuration) throws ServiceException {
        this.getReportBuilder(configuration).buildReport(configuration);
    }

    @Override
    public void generateReport(ReportConfiguration configuration, ReportData data) throws ServiceException {
        this.getReportBuilder(configuration).buildReport(configuration, data);
    }

    protected ReportBuilder getReportBuilder(ReportConfiguration configuration) throws ReportException {
        Validate.notNull((Object)configuration, (String)"A report configuration must not be NULL");
        Validate.notNull((Object)configuration.getReportName(), (String)"A report name must not be NULL");
        ReportBuilder builder = null;
        try {
            builder = (ReportBuilder)this.getComponent(configuration.getReportName(), ReportBuilder.class);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("A builder is not configured for report [" + configuration.getReportName() + "]"));
                this.logger.debug((Object)("Use a default builder: " + ConfigurableReportBuilder.class.getName()));
            }
            throw new ReportException("Failed to get a report builder", e);
        }
        return builder;
    }
}

