/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportService;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceDescriptor;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerableService;
import java.io.Serializable;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;

public class AsynchronousReportService
extends AbstractComponent
implements ReportService {
    private static final long serialVersionUID = 1L;
    private TriggerableService triggerService = null;
    private String triggerEventName = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.triggerService, (String)"A trigger service is required");
        if (this.triggerEventName == null) {
            StringBuffer tmp = new StringBuffer(ClassUtils.getShortClassName((String)this.getClass().getName()));
            tmp.append(".").append(ClassUtils.getShortClassName((String)ServiceDescriptor.class.getName()));
            this.triggerEventName = tmp.toString();
        }
    }

    @Override
    public void generateReport(ReportConfiguration configuration) throws ServiceException {
        this.triggerService.trigger(new TriggerEvent(this.triggerEventName, (Serializable)new Object[]{configuration}, TriggerEvent.createTriggerIdentity(TriggerIdentity.DestinationType.REPORT)));
    }

    @Override
    public void generateReport(ReportConfiguration configuration, ReportData data) throws ServiceException {
        this.triggerService.trigger(new TriggerEvent(this.triggerEventName, (Serializable)new Object[]{configuration, data}, TriggerEvent.createTriggerIdentity(TriggerIdentity.DestinationType.REPORT)));
    }

    public void setTriggerEventName(String triggerEventName) {
        this.triggerEventName = triggerEventName;
    }

    public void setTriggerService(TriggerableService triggerService) {
        this.triggerService = triggerService;
    }
}

