/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report;

import gov.va.med.fw.report.FileSystemReportPersister;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportExporter;
import gov.va.med.fw.report.ReportPersister;
import gov.va.med.fw.report.ReportTemplate;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.service.AbstractComponent;
import java.io.ByteArrayOutputStream;
import org.apache.commons.lang.Validate;

public abstract class AbstractReportExporter
extends AbstractComponent
implements ReportExporter {
    private static final long serialVersionUID = 1467885659349836403L;
    private ReportPersister reportPersister = null;

    protected AbstractReportExporter() {
        this.setReportPersister(new FileSystemReportPersister());
    }

    public ReportPersister getReportPersister() {
        return this.reportPersister;
    }

    public void setReportPersister(ReportPersister reportPersister) {
        this.reportPersister = reportPersister;
    }

    @Override
    public void exportReport(ReportConfiguration configuration, ReportData data, ReportTemplate template) throws ReportException {
        Validate.notNull((Object)configuration, (String)"A report configuration must not be NULL");
        Validate.notNull((Object)data, (String)"A report data must not be NULL ");
        this.persist(configuration, this.export(this.fill(configuration, data, template)));
    }

    protected void persist(ReportConfiguration config, ByteArrayOutputStream stream) throws ReportException {
        if (this.reportPersister != null) {
            this.reportPersister.persist(config, stream);
        }
    }

    protected abstract ByteArrayOutputStream export(Object var1) throws ReportException;

    protected abstract Object fill(ReportConfiguration var1, ReportData var2, ReportTemplate var3) throws ReportException;
}

