/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.persistent.ScrollableCallback;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import gov.va.med.fw.persistent.hibernate.ScrollableDAOAction;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateCallback;

public class GenericDAOImpl
extends AbstractDAOImpl
implements DAOOperations {
    private static final long serialVersionUID = 2927972729631888104L;

    @Override
    public Object execute(AbstractDAOAction action) throws DAOException {
        try {
            return this.getHibernateTemplate().execute((HibernateCallback)action);
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to execute an action", e);
        }
    }

    @Override
    public void clear() throws DAOException {
        try {
            this.getHibernateTemplate().clear();
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to clear a session", e);
        }
    }

    @Override
    public void closeIterator(Iterator it) throws DAOException {
        try {
            Validate.notNull((Object)it, (String)"An iterator must not be null");
            this.getHibernateTemplate().closeIterator(it);
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to close an iterator", e);
        }
    }

    @Override
    public boolean contains(Object entity) throws DAOException {
        try {
            return this.getHibernateTemplate().contains(entity);
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to check if an entity is in a sesion", e);
        }
    }

    @Override
    public void deleteAll(Collection entities) throws DAOException {
        try {
            Validate.notEmpty((Collection)entities);
            this.getHibernateTemplate().deleteAll(entities);
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to delete all entities", e);
        }
    }

    @Override
    public void evict(Object entity) throws DAOException {
        try {
            if (this.contains(entity)) {
                this.getHibernateTemplate().evict(entity);
            }
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to detach an entity from a session", e);
        }
    }

    @Override
    public Object execute(AbstractDAOAction action, boolean exposeNativeSession) throws DAOException {
        try {
            Validate.notNull((Object)action);
            return this.getHibernateTemplate().execute((HibernateCallback)action, exposeNativeSession);
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to execute an action", e);
        }
    }

    @Override
    public List executeFind(AbstractDAOAction action) throws DAOException {
        return (List)this.execute(action, this.isExposeNativeSession());
    }

    @Override
    public List find(String queryString, Object value) throws DAOException {
        try {
            Validate.notNull((Object)queryString);
            return this.getHibernateTemplate().find(queryString, value);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query: ").append(queryString).append(" value: ").append(value);
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List find(String queryString, Object[] values) throws DAOException {
        try {
            Validate.notNull((Object)queryString);
            return this.getHibernateTemplate().find(queryString, values);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query: ").append(queryString).append(" values: ").append(ToStringBuilder.reflectionToString((Object)values));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByNamedParam(String queryName, String paramName, Object value) throws DAOException {
        try {
            Validate.notNull((Object)queryName);
            Validate.notNull((Object)paramName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("GenericDAOImpl findByNamedParam:" + queryName + " param: " + paramName + " " + value));
            }
            return this.getHibernateTemplate().findByNamedParam(queryName, paramName, value);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by named query: ").append(queryName).append(" param Name: ").append(paramName).append(" value: ").append(ToStringBuilder.reflectionToString((Object)value));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByNamedParam(String queryString, String[] paramNames, Object[] values) throws DAOException {
        try {
            Validate.notNull((Object)queryString, (String)"A qyery string must not be null");
            return this.getHibernateTemplate().findByNamedParam(queryString, paramNames, values);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by named param: ").append(queryString).append(" param Names: ").append(ToStringBuilder.reflectionToString((Object)paramNames)).append(" values: ").append(ToStringBuilder.reflectionToString((Object)values));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByNamedQuery(String queryName, Object value) throws DAOException {
        try {
            Validate.notNull((Object)queryName, (String)"A qyery string's name must not be null");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("GenericDAOImpl findByNamedQuery:" + queryName));
            }
            return this.getHibernateTemplate().findByNamedQuery(queryName, value);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by named param: ").append(queryName).append(" values: ").append(ToStringBuilder.reflectionToString((Object)value));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByNamedQuery(String queryName, Object[] values) throws DAOException {
        try {
            Validate.notNull((Object)queryName, (String)"A qyery string's name must not be null");
            return this.getHibernateTemplate().findByNamedQuery(queryName, values);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by named param: ").append(queryName).append(" valuess: ").append(ToStringBuilder.reflectionToString((Object)values));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByNamedQueryAndNamedParam(String queryName, String paramName, Object value) throws DAOException {
        try {
            Validate.notNull((Object)queryName, (String)"A qyery string's name must not be null");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("GenericDAOImpl findByNamedQueryandNamedParam:" + queryName + " param: " + paramName + " " + value));
            }
            return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, paramName, value);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by named query: ").append(queryName).append(" named param: ").append(paramName).append(" value: ").append(ToStringBuilder.reflectionToString((Object)value));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByNamedQueryAndNamedParam(String queryName, String[] paramNames, Object[] values) throws DAOException {
        try {
            Validate.notNull((Object)queryName, (String)"A qyery string's name must not be null");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("GenericDAOImpl findByNamedParam[]:" + queryName + " param: " + paramNames + " " + values));
            }
            return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, paramNames, values);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by named query: ").append(queryName).append(" named params: ").append(ToStringBuilder.reflectionToString((Object)paramNames)).append(" value: ").append(ToStringBuilder.reflectionToString((Object)values));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByNamedQueryAndValueBean(String queryName, Object valueBean) throws DAOException {
        try {
            Validate.notNull((Object)queryName, (String)"A query string's name must not be null");
            Validate.notNull((Object)valueBean, (String)"A value bean must not be null");
            return this.getHibernateTemplate().findByNamedQueryAndValueBean(queryName, valueBean);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by named query: ").append(queryName).append(" value bean: ").append(ToStringBuilder.reflectionToString((Object)valueBean));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List findByValueBean(String queryString, Object valueBean) throws DAOException {
        try {
            Validate.notNull((Object)queryString, (String)"A query string must not be null");
            Validate.notNull((Object)valueBean, (String)"A value bean must not be null");
            return this.getHibernateTemplate().findByValueBean(queryString, valueBean);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query by query string: ").append(queryString).append(" value: ").append(ToStringBuilder.reflectionToString((Object)valueBean));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public String getQueryString(String queryName) throws DAOException {
        Validate.notNull((Object)queryName);
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("queryName", queryName);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            @Override
            public Object execute(Session session) {
                return session.getNamedQuery((String)this.getContextData().get("queryName")).getQueryString();
            }
        };
        try {
            return (String)this.getHibernateTemplate().execute((HibernateCallback)callback);
        }
        catch (Exception e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to get a query string by a given query name: ").append(queryName);
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public Integer scroll(ScrollableCallback callback, QueryInfo query, QueryIncrementTracker tracker) {
        Validate.notNull((Object)callback);
        Validate.notNull((Object)query);
        ScrollableDAOAction action = new ScrollableDAOAction(callback, query, tracker);
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)action);
    }

    @Override
    public void flush() throws DAOException {
        try {
            this.getHibernateTemplate().flush();
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to flush a session ");
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public String[] getFilterNames() {
        return this.getHibernateTemplate().getFilterNames();
    }

    @Override
    public int getFlushMode() {
        return this.getHibernateTemplate().getFlushMode();
    }

    @Override
    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.getHibernateTemplate().getJdbcExceptionTranslator();
    }

    @Override
    public String getQueryCacheRegion() {
        return this.getHibernateTemplate().getQueryCacheRegion();
    }

    @Override
    public void initialize(Object proxy) throws DAOException {
        try {
            this.getHibernateTemplate().initialize(proxy);
        }
        catch (RuntimeException e) {
            throw new DAOException("Failed to initialize object", e);
        }
    }

    @Override
    public boolean isAllowCreate() {
        return this.getHibernateTemplate().isAllowCreate();
    }

    @Override
    public boolean isAlwaysUseNewSession() {
        return this.getHibernateTemplate().isAlwaysUseNewSession();
    }

    @Override
    public boolean isCacheQueries() {
        return this.getHibernateTemplate().isCacheQueries();
    }

    @Override
    public boolean isCheckWriteOperations() {
        return this.getHibernateTemplate().isCheckWriteOperations();
    }

    @Override
    public boolean isExposeNativeSession() {
        return this.getHibernateTemplate().isExposeNativeSession();
    }

    @Override
    public Iterator iterate(String queryString) throws DAOException {
        try {
            Validate.notNull((Object)queryString, (String)" A query string must not be null");
            return this.getHibernateTemplate().iterate(queryString);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query to return an iterator");
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public Iterator iterate(String queryString, Object value) throws DAOException {
        try {
            Validate.notNull((Object)queryString, (String)" A query string must not be null");
            return this.getHibernateTemplate().iterate(queryString, value);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query with value ").append(ToStringBuilder.reflectionToString((Object)value)).append(" to return an iterator");
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public Iterator iterate(String queryString, Object[] values) throws DAOException {
        try {
            Validate.notNull((Object)queryString, (String)" A query string must not be null");
            return this.getHibernateTemplate().iterate(queryString, values);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to execute a query with value ").append(ToStringBuilder.reflectionToString((Object)values)).append(" to return an iterator");
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public Object load(Class entityClass, Serializable id) throws DAOException {
        try {
            Validate.notNull((Object)entityClass, (String)"An entity class must not be null");
            Validate.notNull((Object)id, (String)"An entity ID must not be null");
            return this.getHibernateTemplate().load(entityClass, id);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to load an entity from a session: ").append(entityClass).append(" with id: ").append(ToStringBuilder.reflectionToString((Object)id));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public void load(Object entity, Serializable id) throws DAOException {
        try {
            Validate.notNull((Object)entity, (String)"An entity must not be null");
            Validate.notNull((Object)id, (String)"An entity ID must not be null");
            this.getHibernateTemplate().load(entity, id);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to load an entity from a session: ").append(entity).append(" with id: ").append(ToStringBuilder.reflectionToString((Object)id));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public Object load(String entityName, Serializable id) throws DAOException {
        try {
            Validate.notNull((Object)entityName, (String)"An entity's name must not be null");
            Validate.notNull((Object)id, (String)"An entity ID must not be null");
            return this.getHibernateTemplate().load(entityName, id);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to load from a session an entity named: ").append(entityName).append(" with id: ").append(ToStringBuilder.reflectionToString((Object)id));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public List loadAll(Class entityClass) throws DAOException {
        try {
            Validate.notNull((Object)entityClass, (String)"An entity's class must not be null");
            return this.getHibernateTemplate().loadAll(entityClass);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to load all instances of this class: ").append(ToStringBuilder.reflectionToString((Object)entityClass));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public Object merge(Object entity) throws DAOException {
        Object updated = entity;
        try {
            if (this.contains(entity)) {
                updated = this.getHibernateTemplate().merge(entity);
            }
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to merge an entity in memory to the persistent one: ").append(ToStringBuilder.reflectionToString((Object)entity));
            throw new DAOException(info.toString(), e);
        }
        return updated;
    }

    @Override
    public Object merge(String entityName, Object entity) throws DAOException {
        try {
            Validate.notNull((Object)entityName, (String)"An entity's name must not be null");
            Validate.notNull((Object)entity, (String)"An entity must not be null");
            return this.getHibernateTemplate().merge(entityName, entity);
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Failed to merge an entity named: ").append(entityName).append(" to the persistent one: ").append(ToStringBuilder.reflectionToString((Object)entity));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public void refresh(Object entity) throws DAOException {
        try {
            if (this.getHibernateTemplate().contains(entity)) {
                this.getHibernateTemplate().refresh(entity);
            }
        }
        catch (RuntimeException e) {
            StringBuffer info = new StringBuffer();
            info.append("Refresh this entity with data from a database ").append(ToStringBuilder.reflectionToString((Object)entity));
            throw new DAOException(info.toString(), e);
        }
    }

    @Override
    public void setAllowCreate(boolean allowCreate) {
        this.getHibernateTemplate().setAllowCreate(allowCreate);
    }

    @Override
    public void setAlwaysUseNewSession(boolean alwaysUseNewSession) {
        this.getHibernateTemplate().setAlwaysUseNewSession(alwaysUseNewSession);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.getHibernateTemplate().setBeanFactory(beanFactory);
    }

    @Override
    public void setCacheQueries(boolean cacheQueries) {
        this.getHibernateTemplate().setCacheQueries(cacheQueries);
    }

    @Override
    public void setCheckWriteOperations(boolean checkWriteOperations) {
        this.getHibernateTemplate().setCheckWriteOperations(checkWriteOperations);
    }

    @Override
    public void setEntityInterceptorBeanName(String entityInterceptorBeanName) {
        this.getHibernateTemplate().setEntityInterceptorBeanName(entityInterceptorBeanName);
    }

    @Override
    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.getHibernateTemplate().setExposeNativeSession(exposeNativeSession);
    }

    @Override
    public void setFilterName(String filter) {
        this.getHibernateTemplate().setFilterName(filter);
    }

    @Override
    public void setFilterNames(String[] filterNames) {
        this.getHibernateTemplate().setFilterNames(filterNames);
    }

    @Override
    public void setFlushMode(int flushMode) {
        this.getHibernateTemplate().setFlushMode(flushMode);
    }

    @Override
    public void setFlushModeName(String constantName) {
        this.getHibernateTemplate().setFlushModeName(constantName);
    }

    @Override
    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.getHibernateTemplate().setJdbcExceptionTranslator(jdbcExceptionTranslator);
    }

    @Override
    public void setQueryCacheRegion(String queryCacheRegion) {
        this.getHibernateTemplate().setQueryCacheRegion(queryCacheRegion);
    }

    @Override
    public void update(Object entity) throws DAOException {
        this.saveObject(entity);
    }

    @Override
    public List find(String query, int firstRecord, int maxRecord, int fetchSize) throws DAOException {
        Validate.notNull((Object)query);
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("query", query);
        contextData.put("firstRecord", new Integer(firstRecord));
        contextData.put("maxRecord", new Integer(maxRecord));
        contextData.put("fetchSize", new Integer(fetchSize));
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            @Override
            public Object execute(Session session) {
                return session.getNamedQuery((String)this.getContextData().get("query")).setFirstResult(((Integer)this.getContextData().get("firstRecord")).intValue()).setMaxResults(((Integer)this.getContextData().get("maxRecord")).intValue()).setFetchSize(((Integer)this.getContextData().get("fetchSize")).intValue()).list();
            }
        };
        return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
    }

    @Override
    public List find(String query, Object[] params, int firstRecord, int maxRecord, int fetchSize) throws DAOException {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("query", query);
        contextData.put("params", params);
        contextData.put("firstRecord", new Integer(firstRecord));
        contextData.put("maxRecord", new Integer(maxRecord));
        contextData.put("fetchSize", new Integer(fetchSize));
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            @Override
            public Object execute(Session session) {
                Query queryImpl = session.getNamedQuery((String)this.getContextData().get("query")).setFirstResult(((Integer)this.getContextData().get("firstRecord")).intValue()).setMaxResults(((Integer)this.getContextData().get("maxRecord")).intValue()).setFetchSize(((Integer)this.getContextData().get("fetchSize")).intValue());
                String[] paramNames = queryImpl.getNamedParameters();
                Object[] targetParams = (Object[])this.getContextData().get("params");
                if (targetParams != null && targetParams.length > 0) {
                    for (int i = 0; paramNames != null && i < paramNames.length; ++i) {
                        queryImpl.setParameter(paramNames[i], targetParams[i]);
                    }
                }
                return queryImpl.list();
            }
        };
        return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
    }

    @Override
    public List find(String query, String[] paramNames, Object[] params, int firstRecord, int maxRecord, int fetchSize) throws DAOException {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("query", query);
        contextData.put("paramNames", paramNames);
        contextData.put("params", params);
        contextData.put("firstRecord", new Integer(firstRecord));
        contextData.put("maxRecord", new Integer(maxRecord));
        contextData.put("fetchSize", new Integer(fetchSize));
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            @Override
            public Object execute(Session session) {
                Query queryImpl = session.getNamedQuery((String)this.getContextData().get("query")).setFirstResult(((Integer)this.getContextData().get("firstRecord")).intValue()).setMaxResults(((Integer)this.getContextData().get("maxRecord")).intValue()).setFetchSize(((Integer)this.getContextData().get("fetchSize")).intValue());
                String[] targetParamNames = (String[])this.getContextData().get("paramNames");
                Object[] targetParams = (Object[])this.getContextData().get("params");
                if (targetParamNames != null) {
                    for (int i = 0; i < targetParamNames.length; ++i) {
                        queryImpl.setParameter(targetParamNames[i], targetParams[i]);
                    }
                }
                return queryImpl.list();
            }
        };
        return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
    }

    @Override
    public int bulkUpdate(String query) throws DAOException {
        try {
            return this.getHibernateTemplate().bulkUpdate(query);
        }
        catch (Exception e) {
            throw new DAOException("Unable to perform bulk update", e);
        }
    }

    @Override
    public int bulkUpdate(String query, Object[] parameters) throws DAOException {
        try {
            return this.getHibernateTemplate().bulkUpdate(query, parameters);
        }
        catch (Exception e) {
            throw new DAOException("Unable to perform bulk update", e);
        }
    }

    protected Throwable getRootExceptionOfType(Throwable e, Class targetRootExceptionType) {
        Throwable rootCause;
        if (e != null && targetRootExceptionType != null && (rootCause = ExceptionUtils.getRootCause((Throwable)e)) != null && targetRootExceptionType.isAssignableFrom(rootCause.getClass())) {
            return rootCause;
        }
        return null;
    }

    @Override
    public List executeSQLQuery(final String sqlQuery) throws DAOException {
        List results = null;
        try {
            AbstractDAOAction callback = new AbstractDAOAction(){

                @Override
                public Object execute(Session session) {
                    SQLQuery hibSqlQuery = session.createSQLQuery(sqlQuery);
                    return hibSqlQuery.list();
                }
            };
            results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (DataAccessException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Failed to execute an sql query due to error " + (Object)((Object)e)));
            }
            throw new DAOException("Failed to execute an sql query:", e);
        }
        return results;
    }

    @Override
    public List executeSQLQuery(final String sqlQuery, final String prepareStmt) throws DAOException {
        List results = new ArrayList();
        try {
            AbstractDAOAction callback = new AbstractDAOAction(){

                @Override
                public Object execute(Session session) throws DAOException {
                    if (prepareStmt != null && prepareStmt.length() > 0) {
                        try {
                            PreparedStatement ps = session.connection().prepareStatement(prepareStmt);
                            ps.execute();
                        }
                        catch (SQLException ex) {
                            throw new DAOException("Failed to execute prepare statement: " + prepareStmt, ex);
                        }
                    }
                    SQLQuery hibSqlQuery = session.createSQLQuery(sqlQuery);
                    return hibSqlQuery.list();
                }
            };
            results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to execute an sql query:" + sqlQuery, e);
        }
        return results;
    }
}

