/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.persistent.hibernate.PersistentInterceptorAdapter;
import gov.va.med.fw.security.Principal;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.hibernate.CallbackException;
import org.hibernate.type.Type;

public class EntityInterceptor
extends PersistentInterceptorAdapter
implements Serializable {
    private static final long serialVersionUID = 8642808474447403684L;
    private static final Map PROPERTY_NAMES_CREATED_BY = new HashMap();
    private static final Map PROPERTY_NAMES_MODIFIED_BY = new HashMap();
    private static final Map PROPERTY_NAMES_CREATED_ON = new HashMap();
    private static final Map PROPERTY_NAMES_MODIFIED_ON = new HashMap();
    private String defaultAuditName;
    private TransactionTimestampManager timestampManager;

    public String getDefaultAuditName() {
        return this.defaultAuditName;
    }

    public void setDefaultAuditName(String defaultAuditName) {
        this.defaultAuditName = defaultAuditName;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)((Object)this.timestampManager));
    }

    @Override
    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        boolean wasStateModified = false;
        if (entity instanceof AbstractVersionedEntity) {
            for (int index = 0; index < propertyNames.length; ++index) {
                if (PROPERTY_NAMES_MODIFIED_BY.containsKey(propertyNames[index])) {
                    currentState[index] = this.getCurrentPrincipal();
                    wasStateModified = true;
                    continue;
                }
                if (!PROPERTY_NAMES_MODIFIED_ON.containsKey(propertyNames[index])) continue;
                currentState[index] = this.getCurrentTimestamp();
                wasStateModified = true;
            }
        }
        return wasStateModified;
    }

    @Override
    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        boolean wasStateModified = false;
        if (entity instanceof AbstractVersionedEntity) {
            Timestamp ts = this.getCurrentTimestamp();
            for (int index = 0; index < propertyNames.length; ++index) {
                if (PROPERTY_NAMES_CREATED_BY.containsKey(propertyNames[index]) || PROPERTY_NAMES_MODIFIED_BY.containsKey(propertyNames[index])) {
                    state[index] = this.getCurrentPrincipal();
                    wasStateModified = true;
                    continue;
                }
                if (!PROPERTY_NAMES_CREATED_ON.containsKey(propertyNames[index]) && !PROPERTY_NAMES_MODIFIED_ON.containsKey(propertyNames[index])) continue;
                state[index] = ts;
                wasStateModified = true;
            }
        }
        return wasStateModified;
    }

    @Override
    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (entity instanceof AbstractVersionedEntity) {
            for (int index = 0; index < propertyNames.length; ++index) {
                if (PROPERTY_NAMES_MODIFIED_BY.containsKey(propertyNames[index])) {
                    state[index] = this.getCurrentPrincipal();
                    continue;
                }
                if (!PROPERTY_NAMES_MODIFIED_ON.containsKey(propertyNames[index])) continue;
                state[index] = this.getCurrentTimestamp();
            }
        }
    }

    @Override
    public String onPrepareStatement(String arg0) {
        return arg0;
    }

    private Timestamp getCurrentTimestamp() {
        return this.timestampManager.getTransactionTimestamp();
    }

    private Principal getCurrentPrincipal() {
        try {
            return SecurityContextHelper.getCurrentUser();
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Exception while trying to get the principal from the context.", (Throwable)e);
            }
            return new UserPrincipalImpl(this.getDefaultAuditName());
        }
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }

    static {
        PROPERTY_NAMES_CREATED_BY.put("createdBy", null);
        PROPERTY_NAMES_MODIFIED_BY.put("modifiedBy", null);
        PROPERTY_NAMES_CREATED_ON.put("created", null);
        PROPERTY_NAMES_CREATED_ON.put("createdOn", null);
        PROPERTY_NAMES_MODIFIED_ON.put("modified", null);
        PROPERTY_NAMES_MODIFIED_ON.put("modifiedOn", null);
    }
}

