/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.BaseEntityKey;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AbstractDAOImpl
extends HibernateDaoSupport
implements DAO,
BeanNameAware,
ApplicationContextAware {
    private static final long serialVersionUID = -126845924476530922L;
    private String name = null;
    private ApplicationContext context = null;

    @Override
    public EntityKey insertObject(Object obj) throws DAOException {
        EntityKey key = null;
        try {
            Serializable id = this.getHibernateTemplate().save(obj);
            key = obj instanceof AbstractKeyedEntity ? ((AbstractKeyedEntity)obj).getEntityKey() : new BaseEntityKey(id, obj.getClass());
        }
        catch (DataAccessException e) {
            throw new DAOException("exception loading '" + obj.getClass().getName(), e);
        }
        return key;
    }

    @Override
    public Object getObject(Object obj, String id) throws DAOException {
        Object value = null;
        try {
            value = this.getHibernateTemplate().get(obj.getClass(), (Serializable)((Object)id));
        }
        catch (DataAccessException e) {
            throw new DAOException("exception loading '" + id.getClass().getName() + "' with id '" + id + "'", e);
        }
        return value;
    }

    @Override
    public Object getByKey(EntityKey key) throws DAOException {
        if (key.getEntityClass() == null) {
            throw new IllegalArgumentException("Must specify a non-null entity class in the EntityKey");
        }
        Object value = null;
        try {
            value = this.getHibernateTemplate().get(key.getEntityClass(), key.getKeyValue());
        }
        catch (DataAccessException e) {
            throw new DAOException("exception loading '" + key.getEntityClass().getName() + "' with key '" + key + "'", e);
        }
        return value;
    }

    @Override
    public void saveObject(Object obj) throws DAOException {
        try {
            if (obj instanceof AbstractKeyedEntity) {
                AbstractKeyedEntity keyedObject = (AbstractKeyedEntity)obj;
                if (keyedObject.getEntityKey() != null) {
                    this.getHibernateTemplate().saveOrUpdate(obj);
                } else {
                    this.getHibernateTemplate().save((Object)keyedObject);
                }
            } else {
                this.getHibernateTemplate().saveOrUpdate(obj);
            }
        }
        catch (DataAccessException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Error during save: " + e.getMessage()));
                this.logger.error((Object)"Failed to persist an entity");
            }
            Throwable rootCause = e.getCause();
            while (rootCause.getCause() != null) {
                rootCause = e.getCause();
                rootCause.printStackTrace();
            }
            rootCause.printStackTrace();
            throw new DAOException("Failed to persist an entity ", e);
        }
    }

    @Override
    public void removeObject(EntityKey id) throws DAOException {
        Object value = this.getByKey(id);
        if (value != null) {
            try {
                this.getHibernateTemplate().delete(value);
            }
            catch (DataAccessException e) {
                throw new DAOException("Failed to remove an entity with id: " + id, e);
            }
        }
    }

    @Override
    public List find(String query) throws DAOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("AbstractDAOImpl running query:" + query));
        }
        List list = null;
        if (query != null) {
            try {
                list = this.getHibernateTemplate().findByNamedQuery(query);
            }
            catch (DataAccessException e) {
                throw new DAOException("Failed to get an entity by HSQL:" + query, e);
            }
        }
        return list;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getBeanName() {
        return this.name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    protected Object getComponent(String name) throws ServiceException {
        try {
            return this.context != null ? this.context.getBean(name) : null;
        }
        catch (BeansException e) {
            throw new ServiceException("Failed to obtain a service " + name, e);
        }
    }

    protected Object getComponent(String name, Class type) throws ServiceException {
        try {
            return this.context != null ? this.context.getBean(name, type) : null;
        }
        catch (BeansException e) {
            throw new ServiceException("Failed to obtain a service " + name + " type " + type, e);
        }
    }

    protected void initDao() throws Exception {
        super.initDao();
        Validate.notNull((Object)this.context, (String)"An application context must not be null");
    }
}

