/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.model;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.security.UserPrincipal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.acegisecurity.GrantedAuthorityImpl;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class UserPrincipalImpl
extends AbstractKeyedEntity
implements UserPrincipal {
    private static final long serialVersionUID = -7044136313562745972L;
    private UserCredentials userCredentials = new UserCredentials();
    private String givenName = null;
    private String middleName = null;
    private String familyName = null;
    private Set internalRoles = null;

    public UserPrincipalImpl() {
    }

    public UserPrincipalImpl(String name) {
        this.userCredentials.setUserID(name);
    }

    public UserPrincipalImpl(String name, String password) {
        this(name);
        this.userCredentials.setPassword(password);
    }

    @Override
    public UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    @Override
    public String getName() {
        return this.userCredentials.getUserID();
    }

    public void setName(String name) {
        this.userCredentials.setUserID(name);
    }

    @Override
    public String getPassword() {
        return this.userCredentials.getPassword();
    }

    public void setPassword(String password) {
        this.userCredentials.setPassword(password);
    }

    @Override
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Override
    public boolean isAnonymous() {
        return this.userCredentials.isAnonymous();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.setInternalRoles(null);
    }

    public void setAnonymous(boolean anonymous) {
        this.userCredentials.setAnonymous(anonymous);
    }

    private Set getInternalRoles() {
        if (this.internalRoles == null) {
            this.internalRoles = new HashSet();
        }
        return this.internalRoles;
    }

    private void setInternalRoles(Set internalRoles) {
        this.internalRoles = internalRoles;
    }

    @Override
    public Set getUserRoles() {
        return Collections.unmodifiableSet(this.getInternalRoles());
    }

    public void addUserRole(RolePrincipal rolePrincipal) {
        Validate.notNull((Object)rolePrincipal, (String)"Can not add null RolePrincipal");
        this.getInternalRoles().add(rolePrincipal);
    }

    public void removeUserRole(RolePrincipal rolePrincipal) {
        Validate.notNull((Object)rolePrincipal, (String)"Can not remove null RolePrincipal");
        this.getInternalRoles().remove(rolePrincipal);
    }

    @Override
    public Set getAuthorities() {
        HashSet<GrantedAuthorityImpl> authorities = new HashSet<GrantedAuthorityImpl>();
        Iterator i = this.getInternalRoles().iterator();
        while (i.hasNext()) {
            String roleName = ((RolePrincipal)i.next()).getName();
            authorities.add(new GrantedAuthorityImpl(roleName));
        }
        return authorities;
    }

    @Override
    public boolean isPermissionGranted(String permission) {
        Set authorities = this.getAuthorities();
        GrantedAuthorityImpl target = new GrantedAuthorityImpl(permission);
        return authorities.contains(target);
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("name", (Object)this.getName());
        builder.append("anonymous", this.isAnonymous());
        builder.append("givenName", (Object)this.givenName);
        builder.append("middleName", (Object)this.middleName);
        builder.append("familyName", (Object)this.familyName);
    }

    public String getLogicalName() {
        return this.userCredentials.getLogicalID();
    }

    public void setLogicalName(String logicalName) {
        this.userCredentials.setLogicalID(logicalName);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof UserPrincipal && this.equals((UserPrincipal)o);
    }

    protected boolean equals(UserPrincipal userPrincipal) {
        return userPrincipal != null && this.getName() != null && userPrincipal.getName() != null && this.getName().equals(userPrincipal.getName());
    }
}

