/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.mail;

import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.StringUtils;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class SynchronousMailService
extends AbstractComponent
implements MailService {
    private static final long serialVersionUID = -2613270897112223669L;
    private JavaMailSender mailSender = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.mailSender, (String)"A mail sender is required.");
    }

    public MimeMessage createMimeMessage() {
        return this.mailSender.createMimeMessage();
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        return this.mailSender.createMimeMessage(contentStream);
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.mailSender.send(mimeMessage);
    }

    public void send(MimeMessage[] mimeMessages) throws MailException {
        this.mailSender.send(mimeMessages);
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.mailSender.send(mimeMessagePreparator);
    }

    public void send(MimeMessagePreparator[] mimeMessagePreparators) throws MailException {
        this.mailSender.send(mimeMessagePreparators);
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.mailSender.send(simpleMessage);
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        this.mailSender.send(simpleMessages);
    }

    @Override
    public void send(String text, final SimpleMailMessage template) throws MailException {
        Validate.notNull((Object)template, (String)"A message template must not be null");
        final String formattedText = SynchronousMailService.preserveCarriageReturns(text);
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
                MimeMailMessage message = new MimeMailMessage(helper);
                template.copyTo((MailMessage)message);
                message.setText(formattedText);
            }
        };
        this.mailSender.send(preparator);
    }

    @Override
    public void send(String text, String attachment, SimpleMailMessage template) throws MailException {
        Validate.notNull((Object)attachment, (String)"A message attachment must not be null");
        Resource resource = this.getApplicationContext().getResource(attachment);
        this.send(SynchronousMailService.preserveCarriageReturns(text), resource, template);
    }

    @Override
    public void send(String text, final Resource resource, final SimpleMailMessage template) throws MailException {
        Validate.notNull((Object)resource, (String)"A message attachment must not be null");
        Validate.notNull((Object)template, (String)"A message template must not be null");
        final String formattedText = SynchronousMailService.preserveCarriageReturns(text);
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
                MimeMailMessage message = new MimeMailMessage(helper);
                template.copyTo((MailMessage)message);
                if (resource.exists()) {
                    helper.addAttachment(resource.getFilename(), (InputStreamSource)resource);
                }
                message.setText(formattedText);
            }
        };
        this.mailSender.send(preparator);
    }

    @Override
    public void send(String text, final Resource resource, final SimpleMailMessage template, final String name) throws MailException {
        Validate.notNull((Object)resource, (String)"A message attachment must not be null");
        Validate.notNull((Object)template, (String)"A message template must not be null");
        final String formattedText = SynchronousMailService.preserveCarriageReturns(text);
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
                MimeMailMessage message = new MimeMailMessage(helper);
                template.copyTo((MailMessage)message);
                if (resource.exists()) {
                    helper.addAttachment(name, (InputStreamSource)resource);
                }
                message.setText(formattedText);
            }
        };
        this.mailSender.send(preparator);
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public static String preserveCarriageReturns(String text) {
        if (StringUtils.isNotEmpty((String)text)) {
            text = text.replaceAll("\r\n", "\n");
            return text.replaceAll("\n", "\t\n");
        }
        return text;
    }
}

