/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.mail;

import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.service.AbstractComponent;
import java.io.InputStream;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class ConfigurableMailService
extends AbstractComponent
implements MailService {
    private static final long serialVersionUID = 8735063972257421990L;
    private MailService mailService = null;

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.mailService, (String)"A mail service must be configured");
    }

    public MimeMessage createMimeMessage() {
        return this.mailService.createMimeMessage();
    }

    public MimeMessage createMimeMessage(InputStream arg0) throws MailException {
        return this.mailService.createMimeMessage(arg0);
    }

    public void send(MimeMessage arg0) throws MailException {
        this.mailService.send(arg0);
    }

    public void send(MimeMessage[] arg0) throws MailException {
        this.mailService.send(arg0);
    }

    public void send(MimeMessagePreparator arg0) throws MailException {
        this.mailService.send(arg0);
    }

    public void send(MimeMessagePreparator[] arg0) throws MailException {
        this.mailService.send(arg0);
    }

    public void send(SimpleMailMessage arg0) throws MailException {
        this.mailService.send(arg0);
    }

    public void send(SimpleMailMessage[] arg0) throws MailException {
        this.mailService.send(arg0);
    }

    @Override
    public void send(String text, Resource resource, SimpleMailMessage template) throws MailException {
        this.mailService.send(text, resource, template);
    }

    @Override
    public void send(String text, SimpleMailMessage template) throws MailException {
        this.mailService.send(text, template);
    }

    @Override
    public void send(String text, String attachment, SimpleMailMessage template) throws MailException {
        this.mailService.send(text, attachment, template);
    }

    @Override
    public void send(String text, Resource resource, SimpleMailMessage template, String contentType) throws MailException {
        this.mailService.send(text, resource, template, contentType);
    }
}

