/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io.writer;

import gov.va.med.fw.io.FileFieldMetaData;
import gov.va.med.fw.util.InvalidConfigurationException;
import org.apache.commons.lang.StringUtils;

public class OutputFileFieldMetaData
extends FileFieldMetaData {
    private static char DEFAULT_FILLER_VALUE = (char)32;
    private boolean beginNewLine;
    private String sectionHeader;
    private int fillerCount;
    private String fillerValue;

    @Override
    public Object transform(Object rawValue) {
        String value;
        Object transformedValue = super.transform(rawValue);
        if (this.getMaxLength() > 0 && transformedValue != null && StringUtils.isNotBlank((String)(value = transformedValue.toString()))) {
            transformedValue = this.getMaxLength() < 4 ? value.substring(0, this.getMaxLength()) : StringUtils.abbreviate((String)value, (int)this.getMaxLength());
        }
        return transformedValue;
    }

    public String getSectionHeader() {
        return this.sectionHeader;
    }

    public void setSectionHeader(String sectionHeader) {
        this.sectionHeader = sectionHeader;
    }

    public boolean isSectionHeaderField() {
        return this.sectionHeader != null;
    }

    public boolean isBeginNewLine() {
        return this.beginNewLine;
    }

    public void setBeginNewLine(boolean beginNewLine) {
        this.beginNewLine = beginNewLine;
    }

    public int getFillerCount() {
        return this.fillerCount;
    }

    public void setFillerCount(int fillerCount) {
        this.fillerCount = fillerCount;
    }

    public boolean isFillerField() {
        return this.fillerCount != 0;
    }

    public String getFillerValue() {
        return this.fillerValue;
    }

    @Override
    public void afterPropertiesSet() {
        this.verifySettings();
        if (this.fillerCount < 0) {
            throw new InvalidConfigurationException("fillerCount must be positive number");
        }
        if (!this.isFixedWidthFormat() && this.getName() == null && !this.isSectionHeaderField() && this.fillerCount == 0) {
            throw new InvalidConfigurationException("Name is required");
        }
        if (this.isFixedWidthFormat() && this.getName() == null && this.fillerCount == 0) {
            this.fillerCount = this.getEndPosition() - this.getStartPosition() + 1;
        }
        if (this.fillerCount != 0 && this.getName() != null) {
            throw new InvalidConfigurationException("Can not have filler count when there is a property name");
        }
        if (this.fillerCount > 0) {
            StringBuffer buf = new StringBuffer(this.fillerCount);
            for (int i = 0; i < this.fillerCount; ++i) {
                buf.append(DEFAULT_FILLER_VALUE);
            }
            this.fillerValue = buf.toString();
        }
    }
}

