/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io.parser;

import gov.va.med.fw.util.InvalidConfigurationException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.StringTokenizer;

public class WildcardFileFilter
implements FilenameFilter {
    String wildcard = null;
    private boolean caseInsensitive;

    public WildcardFileFilter(String wildcard) {
        this.wildcard = wildcard;
    }

    public WildcardFileFilter(String wildcard, boolean caseInsensitive) {
        this.wildcard = wildcard;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public boolean accept(File dir, String name) {
        int firstIndex = this.wildcard.indexOf(42);
        int lastIndex = this.wildcard.lastIndexOf(42);
        boolean accept = false;
        String wildcardToUse = this.wildcard;
        if (this.caseInsensitive) {
            name = name.toUpperCase(Locale.ENGLISH);
            wildcardToUse = this.wildcard.toUpperCase();
        }
        StringTokenizer st = new StringTokenizer(wildcardToUse, "*");
        if (firstIndex == 0 && lastIndex == 0) {
            accept = name.endsWith(st.nextToken());
        } else if (firstIndex > 0 && firstIndex == lastIndex && st.countTokens() == 1) {
            accept = name.startsWith(st.nextToken());
        } else if (firstIndex > 0 && firstIndex == lastIndex && st.countTokens() == 2) {
            accept = name.startsWith(st.nextToken()) && name.endsWith(st.nextToken());
        } else if (firstIndex == 0 && lastIndex > 0 && st.countTokens() == 1) {
            accept = name.indexOf(st.nextToken()) != 1;
        } else {
            throw new InvalidConfigurationException("Wild card specified for inputFileLocation is not supported: " + this.wildcard);
        }
        return accept;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }
}

