/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io;

import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.InvalidConfigurationException;
import gov.va.med.fw.util.StringUtils;
import org.apache.commons.lang.Validate;

public class FileFieldMetaData
extends AbstractComponent {
    private String name;
    private int length;
    private int maxLength;
    private int minLength;
    private int startPosition;
    private int endPosition;
    private boolean required;
    private FieldTransformer transformer;

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int getFixedFieldWidth() {
        return this.getEndPosition() != 0 ? this.getEndPosition() - this.getStartPosition() + 1 : 0;
    }

    public String validate(String rawValue) {
        String strValue = rawValue.trim();
        if (this.isRequired() && StringUtils.isEmpty((String)strValue)) {
            throw new IllegalStateException(this.getName() + " is required");
        }
        if (this.getLength() > 0 && !StringUtils.isEmpty((String)strValue) && strValue.length() != this.getLength()) {
            throw new IllegalStateException(this.getName() + " does not equal size " + this.getLength());
        }
        if (!StringUtils.isEmpty((String)strValue) && this.getMaxLength() > 0 && strValue.length() > this.getMaxLength()) {
            throw new IllegalStateException(this.getName() + " must have max size " + this.getMaxLength());
        }
        if (!StringUtils.isEmpty((String)strValue) && this.getMinLength() > 0 && strValue.length() < this.getMinLength()) {
            throw new IllegalStateException(this.getName() + " must have min size " + this.getMinLength());
        }
        return strValue;
    }

    public Object transform(Object rawValue) {
        Object transformedValue = rawValue;
        if (this.transformer != null) {
            try {
                transformedValue = this.transformer.transformData(this.name, rawValue);
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Unable to transform data: " + rawValue));
                }
                IllegalArgumentException e1 = new IllegalArgumentException("Unable to transform data: ");
                e1.initCause(e);
                throw e1;
            }
        }
        return transformedValue;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.name, (String)"A FileFieldMetaData needs a name");
        this.verifySettings();
    }

    protected void verifySettings() {
        if (this.getLength() < 0 || this.getMinLength() < 0 || this.getMaxLength() < 0 || this.getStartPosition() < 0 || this.getEndPosition() < 0) {
            throw new InvalidConfigurationException("Can not negative values for properties of FileFieldMetaData");
        }
        if (this.getLength() > 0 && this.getMaxLength() > 0) {
            throw new InvalidConfigurationException("Can not have a fixed length and max length at the same time");
        }
        if (this.getLength() > 0 && this.getMinLength() > 0) {
            throw new InvalidConfigurationException("Can not have a fixed length and min length at the same time");
        }
        if (this.getStartPosition() > 0 && this.getEndPosition() == 0 || this.getStartPosition() == 0 && this.getEndPosition() > 0) {
            throw new InvalidConfigurationException("Must have positive values for start and end position");
        }
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    protected boolean isFixedWidthFormat() {
        return this.getStartPosition() > 0 || this.getEndPosition() > 0;
    }

    public FieldTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(FieldTransformer transformer) {
        this.transformer = transformer;
    }
}

