/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.util.Reflector;
import java.util.ResourceBundle;

public class SegmentFactory {
    private static final String SEGMENT_CLASS_PROPERTIES = "segments";
    private static SegmentFactory instance = null;
    private static ThreadLocal sem = new ThreadLocal();

    protected SegmentFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SegmentFactory getInstance() {
        if (sem.get() != null) return instance;
        Class<SegmentFactory> clazz = SegmentFactory.class;
        synchronized (SegmentFactory.class) {
            if (instance != null) return instance;
            instance = new SegmentFactory();
            sem.set(Boolean.TRUE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Segment createSegment(String[] encoders, String delimiter, String data) throws InvalidSegmentException {
        Segment s = null;
        try {
            s = (Segment)Reflector.instantiate(this.getSegmentClassName(this.getSegmentName(data, delimiter)), new Object[]{encoders, delimiter, data});
        }
        catch (Exception e) {
            throw new InvalidSegmentException("Failed to create a segment", e);
        }
        return s;
    }

    protected String getSegmentName(String data, String delimiter) throws InvalidSegmentException {
        if (data == null || delimiter == null) {
            throw new IllegalArgumentException("Missing a segment data & delimiter");
        }
        int pos = data.indexOf(delimiter);
        if (pos == -1) {
            throw new InvalidSegmentException("Invalid segment delimiter in segment: " + data);
        }
        return data.substring(0, pos);
    }

    protected String getSegmentClassName(String segmentName) {
        String value = Segment.class.getName();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(SEGMENT_CLASS_PROPERTIES);
            value = bundle.getString(segmentName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

