/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.MessageParser;
import gov.va.med.fw.hl7.Segment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Message
implements Serializable {
    private static final long serialVersionUID = -5390733270095095036L;
    protected Log logger = LogFactory.getLog(this.getClass());
    private String data = null;
    private String type = null;
    private List segments = null;
    private boolean wrapSegmentData;

    public Message() {
    }

    public Message(String data) throws InvalidMessageException {
        this(data, null);
    }

    public Message(String data, String type) throws InvalidMessageException {
        this.data = data;
        this.type = type;
    }

    public Message(List segments) throws InvalidMessageException {
        this(segments, null);
    }

    public Message(List segments, String type) throws InvalidMessageException {
        this(MessageParser.parseSegments(segments), type);
        this.segments = segments;
    }

    public Message(List segments, String type, boolean wrapSegmentData) throws InvalidMessageException {
        this(MessageParser.parseSegments(segments, wrapSegmentData), type);
        this.segments = segments;
        this.wrapSegmentData = wrapSegmentData;
    }

    public String getMessageID() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getSegment("MSH");
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 10) {
            value = (String)elements.get(9);
        }
        return value;
    }

    public String getMessageType() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getSegment("MSH");
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 9) {
            value = (String)elements.get(8);
        }
        return value;
    }

    public String getSendingApplication() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getSegment("MSH");
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 3) {
            value = (String)elements.get(2);
        }
        return value;
    }

    public String getSendingFacility() throws InvalidMessageException {
        return this.getSendingFacility("MSH");
    }

    public String getSendingFacility(String segment) throws InvalidMessageException {
        List elements;
        if (segment == null || !"MSH".equals(segment) && !"BHS".equals(segment)) {
            throw new IllegalArgumentException("Can only get sending facility from MSH or BHS segments - not passed in segment: " + segment);
        }
        String value = null;
        Segment header = this.getSegment(segment);
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 4) {
            value = (String)elements.get(3);
        }
        return value;
    }

    public String getReceivingApplication() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getSegment("MSH");
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 5) {
            value = (String)elements.get(4);
        }
        return value;
    }

    public String getReceivingFacility() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getSegment("MSH");
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 6) {
            value = (String)elements.get(5);
        }
        return value;
    }

    public String getDelimiterCharacter() throws InvalidMessageException {
        return MessageParser.getDelimiterCharacter(this.getMessageData());
    }

    public String[] getEncodingCharacters() throws InvalidMessageException {
        return MessageParser.getEncodingCharacters(this.getMessageData());
    }

    public String getMessageData() {
        if (this.segments != null && !this.segments.isEmpty()) {
            this.data = MessageParser.parseSegments(this.segments, this.wrapSegmentData);
        }
        return this.data;
    }

    public void setMessageData(String data) {
        this.data = data;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setSegments(List segments) throws InvalidMessageException {
        this.segments = segments;
        this.data = MessageParser.parseSegments(segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSegments() throws InvalidMessageException {
        if (this.segments == null) {
            Message message = this;
            synchronized (message) {
                this.segments = MessageParser.parseSegments(this.getDelimiterCharacter(), this.getEncodingCharacters(), this.getMessageData());
            }
        }
        return this.segments;
    }

    public Segment getSegment(String name) throws InvalidMessageException {
        return this.getSegment(this.getSegments(), name);
    }

    public List getSegments(String name) throws InvalidMessageException {
        return this.getSegments(this.getSegments(), name);
    }

    public String getElement(String segmentName, int elementPosition) {
        String value;
        block2: {
            value = null;
            try {
                value = this.getElement(this.getSegment(segmentName), elementPosition);
            }
            catch (InvalidMessageException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error((Object)("Failed to get " + segmentName + " element position " + elementPosition));
            }
        }
        return value;
    }

    public String getElement(Segment segment, int elementPosition) {
        String value;
        block3: {
            value = null;
            try {
                List elements = segment.getElements();
                if (elements != null && elements.size() >= elementPosition) {
                    value = (String)elements.get(elementPosition - 1);
                }
            }
            catch (InvalidMessageException e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error((Object)("Failed to get " + segment.getName() + " element position " + elementPosition));
            }
        }
        return value;
    }

    protected Segment getSegment(List segments, String name) {
        Segment segment = null;
        if (segments != null && !segments.isEmpty() && name != null) {
            for (Segment aSegment : segments) {
                if (!aSegment.getName().equals(name)) continue;
                segment = aSegment;
                break;
            }
        }
        return segment;
    }

    protected List getSegments(List segments, String name) {
        ArrayList<Segment> found = null;
        if (segments != null && !segments.isEmpty() && name != null) {
            found = new ArrayList<Segment>();
            for (Segment segment : segments) {
                if (!segment.getName().equals(name)) continue;
                found.add(segment);
            }
        }
        return found;
    }
}

