/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.Segment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BatchMessage
extends Message {
    private static final long serialVersionUID = -2971553257449340578L;
    private List messages = null;
    private HashMap mappings = null;

    public BatchMessage() {
    }

    public BatchMessage(List segments) throws InvalidMessageException {
        super(segments, null);
    }

    public BatchMessage(List segments, String type) throws InvalidMessageException {
        super(segments, type);
    }

    public BatchMessage(List segments, String type, boolean wrapSegmentData) throws InvalidMessageException {
        super(segments, type, wrapSegmentData);
    }

    public BatchMessage(String data) throws InvalidMessageException {
        this(data, null);
    }

    public BatchMessage(String data, String type) throws InvalidMessageException {
        super(data, type);
    }

    public HashMap getMappings() {
        return this.mappings;
    }

    public void setMappings(HashMap mappings) {
        this.mappings = mappings;
    }

    public Segment getHeader() throws InvalidMessageException {
        return this.getSegment("BHS");
    }

    public Segment getTrailer() throws InvalidMessageException {
        return this.getSegment("BTS");
    }

    @Override
    public String getMessageID() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getHeader();
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 11) {
            value = (String)elements.get(10);
        }
        return value;
    }

    @Override
    public String getMessageType() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getHeader();
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 9) {
            value = (String)elements.get(8);
        }
        return value;
    }

    @Override
    public String getSendingApplication() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getHeader();
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 3) {
            value = (String)elements.get(2);
        }
        return value;
    }

    @Override
    public String getSendingFacility() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getHeader();
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 4) {
            value = (String)elements.get(3);
        }
        return value;
    }

    @Override
    public String getReceivingApplication() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getHeader();
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 5) {
            value = (String)elements.get(4);
        }
        return value;
    }

    @Override
    public String getReceivingFacility() throws InvalidMessageException {
        List elements;
        String value = null;
        Segment header = this.getHeader();
        if (header != null && (elements = header.getElements()) != null && elements.size() >= 6) {
            value = (String)elements.get(5);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() throws InvalidMessageException {
        if (this.messages == null) {
            BatchMessage batchMessage = this;
            synchronized (batchMessage) {
                List segments = super.getSegments();
                Segment s = this.getSegment(segments, "BHS");
                if (s == null) {
                    throw new InvalidMessageException("Missing batch header segment");
                }
                s = this.getSegment(segments, "BTS");
                if (s == null) {
                    throw new InvalidMessageException("Missing batch trailer segment");
                }
                this.messages = new ArrayList();
                int count = segments.size();
                ArrayList<Segment> msgSegments = new ArrayList<Segment>();
                for (int i = 1; i < count - 1; ++i) {
                    s = (Segment)segments.get(i);
                    if (s.getName().equals("MSH") && !msgSegments.isEmpty()) {
                        this.messages.add(this.createMessage(msgSegments));
                        msgSegments = new ArrayList();
                    }
                    msgSegments.add(s);
                }
                if (!msgSegments.isEmpty()) {
                    this.messages.add(this.createMessage(msgSegments));
                }
            }
        }
        return this.messages;
    }

    protected Message createMessage(ArrayList data) throws InvalidMessageException {
        return new Message(data, this.getType());
    }
}

