/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.cache;

import gov.va.med.fw.cache.AbstractCacheManager;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.trigger.TriggerEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TriggerEventCacheManager
extends AbstractCacheManager {
    private static final long serialVersionUID = -4370803641246991293L;
    public static final String TRIGGER_EVENTS_KEY = TriggerEventCacheManager.class.getName() + ".TRIGGER_EVENTS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTriggerEvents(Set triggerEvents) {
        Iterator itr = triggerEvents != null ? triggerEvents.iterator() : null;
        HashSet<TriggerEvent> cachedEvents = null;
        TriggerEvent event = null;
        while (itr != null && itr.hasNext()) {
            try {
                event = (TriggerEvent)itr.next();
                TriggerEventCacheManager triggerEventCacheManager = this;
                synchronized (triggerEventCacheManager) {
                    cachedEvents = (HashSet<TriggerEvent>)this.getItem(TRIGGER_EVENTS_KEY);
                    if (cachedEvents == null) {
                        cachedEvents = new HashSet<TriggerEvent>();
                        this.cacheItem(TRIGGER_EVENTS_KEY, cachedEvents);
                    }
                }
                event.setInitiater(SecurityContextHelper.getSecurityContext().getUserPrincipal().getUserCredentials());
                cachedEvents.add(event);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Expected object of type TriggerEvent");
            }
        }
    }

    public Set removeTriggerEvents() {
        return (Set)this.removeItem(TRIGGER_EVENTS_KEY);
    }

    public boolean hasTriggerEvents() {
        return this.containsItem(TRIGGER_EVENTS_KEY);
    }

    public Set getTriggerEvents() {
        return (Set)this.getItem(TRIGGER_EVENTS_KEY);
    }
}

