/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.cache;

import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.service.AbstractComponent;
import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CacheResourceAdvice
extends AbstractComponent
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 7086772476623070151L;
    private EntityCacheManager cacheManager = null;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = null;
        try {
            result = invocation.proceed();
        }
        catch (Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exception thrown in " + invocation.getMethod().getName()));
                Throwable root = ExceptionUtils.getRootCause((Throwable)t);
                this.logger.debug((Object)("Exception root cause message: " + (root != null ? root.getMessage() : null)));
            }
            throw t;
        }
        finally {
            this.doAfterInvocation(invocation);
        }
        return result;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.cacheManager, (String)"An entityCacheManager is required");
    }

    protected void doAfterInvocation(MethodInvocation invocation) {
        String txName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Post processing of method: " + invocation.getMethod().getName()));
        }
        if ((txName = TransactionSynchronizationManager.getCurrentTransactionName()) != null) {
            this.getCacheManager().removeItem(txName);
        }
    }

    public EntityCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(EntityCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

