/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.conversion.DateConverter;
import gov.va.med.fw.mail.FormattedObjectMailStyle;
import gov.va.med.fw.model.AbstractEntity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ProcessStatistics
extends AbstractEntity {
    private static final long serialVersionUID = -8068962742827780928L;
    private String processName;
    private Date processingStartDate;
    private Date processingEndDate;
    private int numberOfTotalRecords;
    private int numberOfSuccessfulRecords;
    private int numberOfErrorRecords;
    private boolean wasInterrupted;
    private String executedOnServer;

    public int getNumberOfErrorRecords() {
        return this.numberOfErrorRecords;
    }

    public void incrementNumberOfSuccessfulRecords() {
        this.incrementNumberOfSuccessfulRecords(1);
    }

    public synchronized void incrementNumberOfSuccessfulRecords(int recordsCount) {
        this.numberOfSuccessfulRecords += recordsCount;
        this.numberOfTotalRecords += recordsCount;
    }

    public void incrementNumberOfTotalRecords() {
        this.incrementNumberOfTotalRecords(1);
    }

    public synchronized void incrementNumberOfTotalRecords(int count) {
        this.numberOfTotalRecords += count;
    }

    public void incrementNumberOfErrorRecords() {
        this.incrementNumberOfErrorRecords(1);
    }

    public synchronized void incrementNumberOfErrorRecords(int recordsCount) {
        this.numberOfErrorRecords += recordsCount;
        this.numberOfTotalRecords += recordsCount;
    }

    public synchronized void decrementNumberOfSuccessfulRecords() {
        if (this.numberOfSuccessfulRecords > 0) {
            --this.numberOfSuccessfulRecords;
        }
        ++this.numberOfErrorRecords;
    }

    public synchronized void setNumberOfErrorRecords(int numberOfErrorRecords) {
        this.numberOfErrorRecords = numberOfErrorRecords;
    }

    public int getNumberOfSuccessfulRecords() {
        return this.numberOfSuccessfulRecords;
    }

    public synchronized void setNumberOfSuccessfulRecords(int numberOfSuccessfulRecords) {
        this.numberOfSuccessfulRecords = numberOfSuccessfulRecords;
    }

    public Date getProcessingStartDate() {
        return this.processingStartDate;
    }

    public void setProcessingStartDate(Date processingStartDate) {
        this.processingStartDate = processingStartDate;
    }

    public void setWasInterrupted(boolean flag) {
        this.wasInterrupted = flag;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("processName", (Object)this.processName);
        builder.append("processingStartDate", (Object)this.processingStartDate);
        builder.append("processingEndDate", (Object)this.processingEndDate);
        builder.append("calculated duration", (Object)this.getProcessingDuration());
        builder.append("numberOfTotalRecords", this.numberOfTotalRecords);
        builder.append("numberOfSuccessfulRecords", this.numberOfSuccessfulRecords);
        builder.append("numberOfErrorRecords", this.numberOfErrorRecords);
        builder.append("executedOnServer", (Object)this.executedOnServer);
        if (this.wasInterrupted) {
            builder.append("IMPORTANT INFO", (Object)"** THIS PROCESS WAS MANUALLY INTERRUPTED AND MAY NOT HAVE COMPLETED **");
        }
    }

    public final String toFormattedMailString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, (ToStringStyle)new FormattedObjectMailStyle());
        this.buildToString(builder);
        return builder.toString();
    }

    public Date getProcessingEndDate() {
        return this.processingEndDate;
    }

    public void setProcessingEndDate(Date processingEndDate) {
        this.processingEndDate = processingEndDate;
    }

    public String getProcessingDuration() {
        String duration = "";
        if (this.processingStartDate != null && this.processingEndDate != null) {
            if (this.processingStartDate.equals(this.processingEndDate)) {
                duration = "0 secs";
            }
            long durationMillis = this.processingEndDate.getTime() - this.processingStartDate.getTime();
            duration = (double)durationMillis / 1000.0 + " secs";
        }
        return duration;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public int getNumberOfTotalRecords() {
        return this.numberOfTotalRecords;
    }

    public synchronized void setNumberOfTotalRecords(int numberOfTotalRecords) {
        this.numberOfTotalRecords = numberOfTotalRecords;
    }

    public boolean getWasInterrupted() {
        return this.wasInterrupted;
    }

    public final String exportAsCSV() throws Exception {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)this.statsMap().toString(), (String)"{"), (String)"}");
    }

    protected Map statsMap() throws Exception {
        Map data = BeanUtils.describe((Object)this);
        this.formatDateField(data, "processingStartDate", this.getProcessingStartDate());
        this.formatDateField(data, "processingEndDate", this.getProcessingEndDate());
        data.remove("class");
        return data;
    }

    protected static final String listAsString(List list) {
        Iterator itr;
        StringBuffer buf = new StringBuffer();
        Iterator iterator = itr = list != null ? list.iterator() : null;
        while (itr != null && itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    protected static final List listFromString(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        ArrayList list = new ArrayList();
        CollectionUtils.addAll(list, (Object[])str.split(":"));
        return list;
    }

    protected final void formatDateField(Map data, String fieldName, Date fieldValue) {
        if (fieldValue != null) {
            data.put(fieldName, new SimpleDateFormat("yyyyMMddHHmmss").format(fieldValue));
        } else {
            data.remove(fieldName);
        }
    }

    public final void importFromCSV(String csv) throws Exception {
        if (StringUtils.isBlank((String)csv)) {
            return;
        }
        if (ConvertUtils.lookup(Date.class) == null) {
            ConvertUtils.register((Converter)new DateConverter(null), Date.class);
        }
        BeanUtils.copyProperties((Object)this, (Object)this.mapFromCSV(csv));
    }

    protected Map mapFromCSV(String csv) {
        HashMap<String, String> data = new HashMap<String, String>();
        String[] vals = csv.split(",");
        String[] val = null;
        for (int i = 0; i < vals.length; ++i) {
            val = vals[i].split("=");
            if (val.length != 2) continue;
            data.put(val[0].trim(), val[1]);
        }
        return data;
    }

    public boolean containsErrors() {
        return this.numberOfErrorRecords != 0;
    }

    public final synchronized void overlayStats(ProcessStatistics stats) {
        this.setProcessName(stats.getProcessName());
        this.setNumberOfTotalRecords(this.getNumberOfTotalRecords() + stats.getNumberOfTotalRecords());
        this.setNumberOfSuccessfulRecords(this.getNumberOfSuccessfulRecords() + stats.getNumberOfSuccessfulRecords());
        this.setNumberOfErrorRecords(this.getNumberOfErrorRecords() + stats.getNumberOfErrorRecords());
        this.appendStats(stats);
    }

    protected void appendStats(ProcessStatistics stats) {
    }

    public boolean isTotalNumberMod(int factor) {
        return this.getNumberOfTotalRecords() != 0 ? this.getNumberOfTotalRecords() % factor == 0 : false;
    }

    public String getExecutedOnServer() {
        return this.executedOnServer;
    }

    public void setExecutedOnServer(String executedOnServer) {
        this.executedOnServer = executedOnServer;
    }
}

