/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessCompletedHandler;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.AbstractComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ExceptionWriterProcessCompletedHandler
extends AbstractComponent
implements DataProcessCompletedHandler {
    private FormattedFileWriter fileWriter;
    private boolean deleteInputFile = true;
    private static final String EXCEPTIONFILENAMESUFFIXDATA = "exceptionfilenamesuffixdata";

    @Override
    public void dataProcessingComplete(DataProcessExecutionContext context) {
        this.writeExceptionData(context);
        if (!context.isInterrupted() && context instanceof DataFileProcessExecutionContext) {
            File inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile();
            if (this.deleteInputFile && !inputFile.delete()) {
                throw new IllegalStateException("Unable to delete input file: " + inputFile.getName());
            }
        }
    }

    protected final void writeExceptionData(DataProcessExecutionContext context) {
        List exceptionData = this.getInterestedExceptionData(context);
        if (exceptionData != null && !exceptionData.isEmpty()) {
            this.fileWriter.writeData(exceptionData, this.getExceptionFileNameSuffixData(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendExceptionData(DataProcessExecutionContext context) {
        List exceptionData = this.getInterestedExceptionData(context);
        if (exceptionData != null && !exceptionData.isEmpty()) {
            ArrayList currentExceptionData = new ArrayList(exceptionData);
            List list = exceptionData;
            synchronized (list) {
                exceptionData.clear();
            }
            Object exceptionFileNameSuffixData = context.getContextData().get(EXCEPTIONFILENAMESUFFIXDATA);
            if (exceptionFileNameSuffixData == null) {
                exceptionFileNameSuffixData = this.getExceptionFileNameSuffixData(context);
                context.getContextData().put(EXCEPTIONFILENAMESUFFIXDATA, exceptionFileNameSuffixData);
            }
            this.fileWriter.appendData(currentExceptionData, exceptionFileNameSuffixData);
        }
    }

    protected List getInterestedExceptionData(DataProcessExecutionContext context) {
        return context.getExceptionData();
    }

    protected Object getExceptionFileNameSuffixData(DataProcessExecutionContext context) {
        Date executionStartDate = context.getProcessStatistics().getProcessingStartDate();
        return executionStartDate;
    }

    public FormattedFileWriter getFileWriter() {
        return this.fileWriter;
    }

    public void setFileWriter(FormattedFileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)((Object)this.fileWriter));
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public void setDeleteInputFile(boolean deleteInputFile) {
        this.deleteInputFile = deleteInputFile;
    }
}

