/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.ProcessStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class DataFileProcessStatistics
extends ProcessStatistics {
    private static final long serialVersionUID = 8435464655303251784L;
    private String processedFilePath;
    private List processedFiles = new ArrayList();

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("processedFilePath", (Object)this.processedFilePath);
        builder.append("processedFiles", (Object)this.processedFiles);
    }

    public String getProcessedFilePath() {
        return this.processedFilePath;
    }

    public void setProcessedFilePath(String processedFilePath) {
        this.processedFilePath = processedFilePath;
    }

    public List getProcessedFiles() {
        return this.processedFiles;
    }

    public void setProcessedFiles(List processedFiles) {
        this.processedFiles = processedFiles;
    }

    public void addProcessedFile(String processedFiles) {
        this.processedFiles.add(processedFiles);
    }

    @Override
    public Map statsMap() throws Exception {
        Map data = super.statsMap();
        if (!this.processedFiles.isEmpty()) {
            data.put("processedFiles", ProcessStatistics.listAsString(this.getProcessedFiles()));
        } else {
            data.remove("processedFiles");
        }
        return data;
    }

    @Override
    protected Map mapFromCSV(String csv) {
        Map data = super.mapFromCSV(csv);
        String processFilesStr = (String)data.get("processedFiles");
        if (StringUtils.isNotBlank((String)processFilesStr)) {
            data.put("processedFiles", ProcessStatistics.listFromString(processFilesStr));
        }
        return data;
    }

    @Override
    protected void appendStats(ProcessStatistics stats) {
        this.setProcessedFilePath(((DataFileProcessStatistics)stats).getProcessedFilePath());
        this.getProcessedFiles().addAll(((DataFileProcessStatistics)stats).getProcessedFiles());
    }
}

