/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.persistent.DAOOperations;
import java.util.List;
import org.apache.commons.lang.Validate;

public class BulkUpdateQueryProcess
extends AbstractDataProcess {
    private String queryString;
    private DAOOperations dao;

    @Override
    protected final void executeProcess(DataProcessExecutionContext context) throws Exception {
        Object[] queryParams = this.getQueryParameters(context);
        int updateCount = 0;
        updateCount = queryParams == null ? this.getDao().bulkUpdate(this.getQueryString()) : this.getDao().bulkUpdate(this.getQueryString(), queryParams);
        context.getProcessStatistics().setNumberOfSuccessfulRecords(updateCount);
        context.getProcessStatistics().setNumberOfTotalRecords(updateCount);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("BulkUpdateQueryProcess updated " + updateCount + " data records"));
        }
    }

    protected Object[] getQueryParameters(DataProcessExecutionContext context) {
        Object executionArgs = context.getExecutionArguments();
        Object[] parameters = null;
        if (executionArgs != null) {
            parameters = executionArgs instanceof Object[] ? (Object[])executionArgs : new Object[]{executionArgs};
        }
        return parameters;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.dao, (String)"A DAO is needed");
        Validate.notNull((Object)this.queryString, (String)"A query string (sql) is needed");
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public DAOOperations getDao() {
        return this.dao;
    }

    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    @Override
    protected final void processData(DataProcessExecutionContext context, List acquiredData) {
    }

    @Override
    protected final List acquireData(DataProcessExecutionContext context) throws Exception {
        return null;
    }
}

