/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataProcessWorker;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessWorkerInput;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;

public abstract class AbstractPublishQueryResultsToWorkers
extends AbstractDataQueryIncrementalProcess {
    protected static final String CURRENT_RECORDS_PROCESSED = "totalRecordsProcessed";
    protected static final String MAX_RECORDS_QUERIED = "maxRecordsQueries";
    protected static final String TOTAL_QUERY_COUNT = "totalQueryCount";
    private String totalCountQueryName;
    private TriggerRouter triggerRouter;
    private int messageSize;
    private AbstractDataProcessWorker worker;

    @Override
    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return this.worker != null;
    }

    @Override
    protected boolean ownsJobCompletion(DataProcessExecutionContext context) {
        boolean val = true;
        try {
            val = this.worker != null || this.getTotalCount((DataQueryProcessExecutionContext)context) == 0;
        }
        catch (Exception e) {
            this.throwIllegalStateException("Unable to determine if ownsJobCompletion", e);
        }
        return val;
    }

    private List checkAgainstMax(DataQueryProcessExecutionContext context, List acquiredData) throws Exception {
        int maxTotalCount;
        int realizedTotalCount = this.getTotalCount(context);
        if (context.getContextData().containsKey(MAX_RECORDS_QUERIED) && (maxTotalCount = ((Integer)context.getContextData().get(MAX_RECORDS_QUERIED)).intValue()) < realizedTotalCount) {
            realizedTotalCount = maxTotalCount;
            context.getContextData().put(TOTAL_QUERY_COUNT, new Integer(maxTotalCount));
        }
        int currentRecordsQueried = 0;
        if (context.getContextData().containsKey(CURRENT_RECORDS_PROCESSED)) {
            currentRecordsQueried = (Integer)context.getContextData().get(CURRENT_RECORDS_PROCESSED);
        }
        if (currentRecordsQueried >= realizedTotalCount) {
            return null;
        }
        if (currentRecordsQueried + acquiredData.size() > realizedTotalCount) {
            int lastIndex;
            int totalToRemove = currentRecordsQueried + acquiredData.size() - realizedTotalCount;
            for (int i = lastIndex = acquiredData.size() - 1; i > lastIndex - totalToRemove; --i) {
                acquiredData.remove(i);
            }
        }
        return acquiredData;
    }

    @Override
    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        try {
            acquiredData = this.checkAgainstMax(context, acquiredData);
            if (acquiredData == null) {
                return;
            }
            Integer currentRecordsProcessed = (Integer)context.getContextData().get(CURRENT_RECORDS_PROCESSED);
            currentRecordsProcessed = currentRecordsProcessed == null ? new Integer(acquiredData.size()) : new Integer(currentRecordsProcessed + acquiredData.size());
            context.getContextData().put(CURRENT_RECORDS_PROCESSED, currentRecordsProcessed);
            if (this.worker == null) {
                JobResult jobResult = this.getJobResult(context);
                DataProcessWorkerInput wrappedPayload = new DataProcessWorkerInput();
                wrappedPayload.setProcessName(this.getProcessName());
                EntityKey key = jobResult.getEntityKey();
                if (key != null) {
                    wrappedPayload.setId((Serializable)((Object)key.getKeyValueAsString()));
                }
                wrappedPayload.setContext(jobResult.getContext());
                wrappedPayload.setTotalCount(this.getTotalCount(context));
                if (this.messageSize == this.getFetchSize()) {
                    wrappedPayload.setPayloadCount(acquiredData.size());
                    TriggerEvent event = this.getTriggerEvent(context, acquiredData);
                    wrappedPayload.setPayload(event.getPayload());
                    event.setPayload(wrappedPayload);
                    this.triggerRouter.processTriggerEvent(event);
                } else {
                    TriggerEvent event;
                    Iterator itr = acquiredData.iterator();
                    ArrayList messageData = new ArrayList();
                    while (itr.hasNext()) {
                        messageData.add(itr.next());
                        if (messageData.size() != this.messageSize) continue;
                        wrappedPayload.setPayloadCount(messageData.size());
                        event = this.getTriggerEvent(context, messageData);
                        wrappedPayload.setPayload(event.getPayload());
                        event.setPayload(wrappedPayload);
                        this.triggerRouter.processTriggerEvent(event);
                        messageData.clear();
                    }
                    if (!messageData.isEmpty()) {
                        wrappedPayload.setPayloadCount(messageData.size());
                        event = this.getTriggerEvent(context, messageData);
                        wrappedPayload.setPayload(event.getPayload());
                        event.setPayload(wrappedPayload);
                        this.triggerRouter.processTriggerEvent(event);
                    }
                }
            } else {
                TriggerEvent event = this.getTriggerEvent(context, acquiredData);
                ProcessStatistics workerStats = this.worker.processData(event.getPayload());
                workerStats.setProcessName(this.getProcessName());
                context.getProcessStatistics().overlayStats(workerStats);
            }
        }
        catch (Exception e) {
            super.throwIllegalStateException("Failed to process", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getTotalCount(DataQueryProcessExecutionContext context) throws Exception {
        Number count = null;
        DataQueryProcessExecutionContext dataQueryProcessExecutionContext = context;
        synchronized (dataQueryProcessExecutionContext) {
            count = (Number)context.getContextData().get(TOTAL_QUERY_COUNT);
            if (count == null) {
                count = this.getTotalCount();
                context.getContextData().put(TOTAL_QUERY_COUNT, count);
            }
        }
        return count.intValue();
    }

    private Number getTotalCount() throws Exception {
        return (Number)this.getDao().find(this.totalCountQueryName).get(0);
    }

    protected abstract TriggerEvent getTriggerEvent(DataQueryProcessExecutionContext var1, List var2);

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.triggerRouter, (String)"triggerRouter is required");
        Validate.notNull((Object)this.totalCountQueryName, (String)"totalCountQueryName is required");
        if (this.messageSize <= 0) {
            this.messageSize = this.getFetchSize();
        }
        if (this.messageSize > this.getFetchSize()) {
            throw new InvalidConfigurationException("JMS Message size can not be larger than query fetch size");
        }
        if (this.getFetchSize() % this.messageSize != 0) {
            throw new InvalidConfigurationException("JMS Message must be fetchSize mod 0");
        }
    }

    public AbstractDataProcessWorker getWorker() {
        return this.worker;
    }

    public void setWorker(AbstractDataProcessWorker worker) {
        this.worker = worker;
    }

    public String getTotalCountQueryName() {
        return this.totalCountQueryName;
    }

    public void setTotalCountQueryName(String totalCountQueryName) {
        this.totalCountQueryName = totalCountQueryName;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }
}

