/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.persistent.ScrollableCallback;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.List;

public abstract class AbstractDataQueryIncrementalProcess
extends AbstractDataQueryProcess
implements ScrollableCallback {
    protected static int JDBC_FETCH_SIZE = 100;
    private int fetchSize = 100;
    private boolean handleEachFetchSeparately = false;
    private boolean isIdempotent = true;

    @Override
    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        List acquiredData = null;
        DataQueryProcessExecutionContext queryContext = (DataQueryProcessExecutionContext)context;
        queryContext.setCurrentDataQuery(this.getQueryDetail());
        this.getQueryDetail().setIncremental(true);
        while (!this.isInterrupted(context) && (acquiredData = this.acquireData(queryContext)) != null && !acquiredData.isEmpty()) {
            this.processData(context, acquiredData);
            if (!this.handleEachFetchSeparately) continue;
            this.handleDataProcessCompleted(context);
        }
        if (this.isAllProcessingComplete() && !this.handleEachFetchSeparately) {
            this.handleDataProcessCompleted(context);
        }
    }

    @Override
    protected final void processData(DataProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null || acquiredData.isEmpty()) {
            return;
        }
        this.doProcessData(context, acquiredData);
    }

    protected final void doProcessData(DataProcessExecutionContext context, List acquiredData) {
        DataQueryProcessExecutionContext queryContext = (DataQueryProcessExecutionContext)context;
        this.processData(queryContext, acquiredData);
        if (this.shouldUpdateJobResult(queryContext)) {
            this.updateJobResult(queryContext);
        }
    }

    protected boolean isAllProcessingComplete() {
        return true;
    }

    protected abstract void processData(DataQueryProcessExecutionContext var1, List var2);

    @Override
    public void handleScrolledData(QueryIncrementTracker tracker) {
        this.doProcessData((DataQueryProcessExecutionContext)tracker, tracker.getIncrementalData());
    }

    @Override
    public boolean continueScrolling(QueryIncrementTracker tracker) {
        return !this.isInterrupted((DataProcessExecutionContext)((Object)tracker));
    }

    protected final List acquireData(DataQueryProcessExecutionContext context) throws Exception {
        int currentRecord = context.getCurrentRecord();
        List acquiredData = this.doAcquireData(context);
        if (acquiredData != null) {
            context.setCurrentRecord(currentRecord + acquiredData.size());
            if (this.logger.isInfoEnabled() && acquiredData != null) {
                this.logger.info((Object)("AbstractDataQueryIncrementalProcess acquired " + acquiredData.size() + " data records"));
            }
        }
        return acquiredData;
    }

    @Override
    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        List acquiredData = null;
        if (this.isIdempotent) {
            acquiredData = this.executeQuery(context);
        } else {
            QueryInfo query = context.getCurrentDataQuery().getQuery();
            query.setFetchSize(this.fetchSize);
            this.getDao().scroll(this, query, context);
        }
        return acquiredData;
    }

    @Override
    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {
        DataQueryDetail currentQuery = context.getCurrentDataQuery();
        return this.getDao().find(currentQuery.getQuery().getQuery(), currentQuery.getQuery().getParamNames(), currentQuery.getQuery().getParamValues(), context.getCurrentRecord(), this.fetchSize, this.calculateJDBCFetchSize());
    }

    protected int calculateJDBCFetchSize() {
        return this.fetchSize > JDBC_FETCH_SIZE ? this.fetchSize : JDBC_FETCH_SIZE;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.fetchSize <= 0) {
            throw new InvalidConfigurationException("fetchSize must be positive");
        }
    }

    public boolean isHandleEachFetchSeparately() {
        return this.handleEachFetchSeparately;
    }

    public void setHandleEachFetchSeparately(boolean handleEachFetchSeparately) {
        this.handleEachFetchSeparately = handleEachFetchSeparately;
    }

    public boolean isIdempotent() {
        return this.isIdempotent;
    }

    public void setIdempotent(boolean isIdempotent) {
        this.isIdempotent = isIdempotent;
    }

    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return true;
    }
}

