/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.BatchProcessService;
import gov.va.med.fw.batchprocess.DataProcessCompletedHandler;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatisticsHandler;
import gov.va.med.fw.batchprocess.model.JobConfig;
import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.batchprocess.model.JobStatus;
import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.service.ServiceException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDataProcess
extends AbstractScheduledProcess {
    public static final int DEFAULT_JOB_RESULT_UPDATE_INTERVAL = 5;
    private static final String JOB_RESULT_ENTITY = "jobResultEntity";
    private static final String JOB_NAME = "jobName";
    private static final String JOB_GROUP_NAME = "jobGroupName";
    private BatchProcessService batchProcessService;
    private String processName;
    private DataProcessCompletedHandler dataProcessCompletedHandler;
    private ProcessStatisticsHandler processStatisticsHandler;
    private boolean allowConcurrentProcessExecution = false;

    @Override
    protected final void executeProcess(ScheduledProcessInvocationContext invocationContext) throws Exception {
        DataProcessExecutionContext context = this.createDataProcessExecutionContext();
        String jobName = this.getProcessName();
        String jobGroup = "DEFAULT";
        if (invocationContext != null) {
            if (invocationContext.getJobGroup() != null) {
                jobGroup = invocationContext.getJobGroup();
            }
            if (invocationContext.getJobName() != null) {
                jobName = invocationContext.getJobName();
            }
            context.setExecutionArguments(invocationContext.getInvocationArguments());
            context.setInitiater(invocationContext.getExecutionContext());
        }
        context.getContextData().put(JOB_NAME, jobName);
        context.getContextData().put(JOB_GROUP_NAME, jobGroup);
        ProcessStatistics stats = context.getProcessStatistics();
        stats.setProcessingStartDate(new Date());
        stats.setProcessName(this.getProcessName());
        try {
            stats.setExecutedOnServer(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            stats.setExecutedOnServer("Unknown");
        }
        boolean proceed = true;
        JobStatus jobStatus = JobStatus.IN_PROCESS;
        if (!this.allowConcurrentProcessExecution && this.containsInProcessStatistics(context)) {
            jobStatus = JobStatus.NOT_EXECUTED_SINCE_INFLIGHT_PROCESS;
            proceed = false;
        }
        JobResult jobResult = this.createJobResult(context, jobStatus);
        if (!proceed) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Not executing process [" + jobName + "] since there is already one with IN_PROCESS statistics"));
            }
            return;
        }
        boolean error = false;
        try {
            this.executeProcess(context);
        }
        catch (Exception e) {
            error = true;
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("AbstractDataProcess.executeProcess threw exception with message: " + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
        finally {
            if (this.ownsJobCompletion(context) || error) {
                stats.setProcessingEndDate(new Date());
                if (this.isInterrupted(context)) {
                    jobResult = this.batchProcessService.getJobResult(jobResult.getEntityKey());
                }
                jobResult.setEndDate(stats.getProcessingEndDate());
                if (error) {
                    jobResult.setStatus(JobStatus.ERROR);
                } else if (this.isInterrupted(context)) {
                    jobResult.setStatus(JobStatus.CANCELLED);
                } else if (stats.containsErrors()) {
                    jobResult.setStatus(JobStatus.COMPLETE_WITH_ERROR);
                } else {
                    jobResult.setStatus(JobStatus.COMPLETE);
                }
                jobResult.setStatistics(stats.exportAsCSV());
                this.batchProcessService.saveJobResult(jobResult);
                this.processStatistics(context);
            }
        }
    }

    private final boolean containsInProcessStatistics(DataProcessExecutionContext context) throws ServiceException {
        boolean foundInProcess = false;
        List activeJobs = this.batchProcessService.getJobResults(JobStatus.IN_PROCESS);
        Iterator itr = activeJobs != null ? activeJobs.iterator() : null;
        JobResult inProcessResult = null;
        while (itr != null && itr.hasNext()) {
            inProcessResult = (JobResult)itr.next();
            if (!inProcessResult.getJobName().equals(this.getJobName(context))) continue;
            foundInProcess = true;
            break;
        }
        return foundInProcess;
    }

    protected boolean ownsJobCompletion(DataProcessExecutionContext context) {
        return true;
    }

    protected final void updateJobResult(DataProcessExecutionContext context, JobResult jobResult) throws Exception {
        if (this.isInterrupted(context)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Prior to updating the JobResult, it was discovered that [" + jobResult.getJobName() + "] has been canceled...deferring current JobResult update until the job winds itself out of interrupted status"));
            }
        } else {
            this.batchProcessService.saveJobResult(jobResult);
        }
    }

    protected final void updateJobResult(DataProcessExecutionContext context) {
        JobResult jobResult = this.getJobResult(context);
        try {
            jobResult.setStatistics(context.getProcessStatistics().exportAsCSV());
            this.updateJobResult(context, jobResult);
        }
        catch (Exception e) {
            this.throwIllegalStateException("Unable to update JobResult", e);
        }
    }

    private JobResult createJobResult(DataProcessExecutionContext context, JobStatus jobStatus) throws Exception {
        JobResult jobResult = new JobResult();
        jobResult.setStartDate(context.getProcessStatistics().getProcessingStartDate());
        jobResult.setJobName(this.getJobName(context));
        jobResult.setJobGroup(this.getJobGroupName(context));
        jobResult.setStatistics(context.getProcessStatistics().exportAsCSV());
        jobResult.setStatus(jobStatus);
        jobResult.setContext(context.getInitiater());
        this.batchProcessService.saveJobResult(jobResult);
        context.getContextData().put(JOB_RESULT_ENTITY, jobResult);
        return jobResult;
    }

    protected JobResult getJobResult(DataProcessExecutionContext context) {
        return (JobResult)context.getContextData().get(JOB_RESULT_ENTITY);
    }

    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        List data = this.acquireData(context);
        if (data != null && !data.isEmpty()) {
            this.processData(context, data);
        }
        this.handleDataProcessCompleted(context);
    }

    public boolean isInterrupted(DataProcessExecutionContext context) {
        if (context.isInterrupted()) {
            return true;
        }
        if (super.isInterrupted()) {
            context.setInterrupted(true);
            return true;
        }
        try {
            JobResult jobResult = this.getBatchProcessService().getJobResult(this.getJobResult(context).getEntityKey());
            if (jobResult != null) {
                boolean interrupted = jobResult.getStatus().getCode().equals(JobStatus.CANCELLED.getCode());
                if (interrupted) {
                    context.setInterrupted(true);
                }
                return interrupted;
            }
            return false;
        }
        catch (ServiceException e) {
            IllegalStateException e2 = new IllegalStateException("Unable to retrieve the JobResult");
            e2.initCause(e);
            throw e2;
        }
    }

    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        if (this.logger.isErrorEnabled() && !context.getExceptionData().isEmpty()) {
            this.logger.error((Object)("Data Processing resulted in exceptions for data: " + context.getExceptionData()));
        }
        this.isInterrupted(context);
        if (this.dataProcessCompletedHandler != null) {
            this.dataProcessCompletedHandler.dataProcessingComplete(context);
        }
        context.getExceptionData().clear();
        context.getProcessedData().clear();
    }

    protected abstract void processData(DataProcessExecutionContext var1, List var2);

    protected abstract List acquireData(DataProcessExecutionContext var1) throws Exception;

    protected final void throwIllegalStateException(String message, Throwable t) {
        IllegalStateException e = new IllegalStateException(message);
        e.initCause(t);
        throw e;
    }

    protected DataProcessExecutionContext createDataProcessExecutionContext() {
        DataProcessExecutionContext context = new DataProcessExecutionContext();
        context.setProcessStatistics(this.createProcessStatistics());
        return context;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new ProcessStatistics();
    }

    protected String getJobName(DataProcessExecutionContext context) {
        return (String)context.getContextData().get(JOB_NAME);
    }

    protected String getJobGroupName(DataProcessExecutionContext context) {
        return (String)context.getContextData().get(JOB_GROUP_NAME);
    }

    protected final void processStatistics(DataProcessExecutionContext context) throws Exception {
        ProcessStatistics stats = context.getProcessStatistics();
        if (this.isInterrupted(context)) {
            stats.setWasInterrupted(true);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ProcessStatistics [" + stats + "]"));
        }
        if (this.processStatisticsHandler != null) {
            JobConfig config = this.batchProcessService.getJobConfig(this.getJobName(context), this.getJobGroupName(context));
            if (config != null && StringUtils.isNotBlank((String)config.getEmailDistributionList())) {
                this.processStatisticsHandler.processStatisticsWithDynamicRecipients(stats, config.getEmailsAsList());
            } else {
                this.processStatisticsHandler.processStatistics(stats);
            }
        }
    }

    public ProcessStatisticsHandler getProcessStatisticsHandler() {
        return this.processStatisticsHandler;
    }

    public void setProcessStatisticsHandler(ProcessStatisticsHandler processStatisticsHandler) {
        this.processStatisticsHandler = processStatisticsHandler;
    }

    public String getProcessName() {
        return this.processName != null ? this.processName : this.getAuditId();
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public DataProcessCompletedHandler getDataProcessCompletedHandler() {
        return this.dataProcessCompletedHandler;
    }

    public void setDataProcessCompletedHandler(DataProcessCompletedHandler dataProcessCompletedHandler) {
        this.dataProcessCompletedHandler = dataProcessCompletedHandler;
    }

    public BatchProcessService getBatchProcessService() {
        return this.batchProcessService;
    }

    public void setBatchProcessService(BatchProcessService batchProcessService) {
        this.batchProcessService = batchProcessService;
    }

    public boolean isAllowConcurrentProcessExecution() {
        return this.allowConcurrentProcessExecution;
    }

    public void setAllowConcurrentProcessExecution(boolean allowConcurrentProcessExecution) {
        this.allowConcurrentProcessExecution = allowConcurrentProcessExecution;
    }
}

