/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.DeliveryPreferenceEmail;
import gov.va.med.esr.common.model.comms.Document;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.model.comms.HealthBenefitPlan;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceSourceOfChange;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.external.ExternalHandBookFactory;
import gov.va.med.esr.service.external.HandBookInfo;
import gov.va.med.esr.service.external.HandBookRequestInfo;
import gov.va.med.esr.service.external.person.DeliveryPreferenceInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.Principal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ExternalHandBookFactoryImpl
extends AbstractComponent
implements ExternalHandBookFactory {
    private static Principal USER_SERVICE_DP = new UserPrincipalImpl("Veteran Self Service");
    private PersonHelperService personHelperService = null;
    private HandBookService handBookService = null;
    private LookupService lookupService = null;

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    @Override
    public List buildHandBookInfo(Person person, HandBookRequestInfo hbReqInfo) throws ServiceException, DAOException {
        if (person == null || hbReqInfo == null) {
            return null;
        }
        ArrayList handBookList = new ArrayList();
        String vpid = person.getIdentityTraits().getVpid().getVPID();
        List results = this.getHandBookService().getHandbookInformation(vpid);
        if (results != null && !results.isEmpty()) {
            if (hbReqInfo.getVersion().equalsIgnoreCase("ALL")) {
                this.buildAllHBVersion(results, hbReqInfo, handBookList);
            } else {
                this.buildCurrentHBVersion(results, hbReqInfo, handBookList);
            }
        }
        return handBookList;
    }

    private List buildAllHBVersion(List results, HandBookRequestInfo hbReqInfo, List handBookList) {
        for (DocumentReceipt docReceipt : results) {
            this.buildDocument(docReceipt, hbReqInfo, handBookList);
        }
        return handBookList;
    }

    private List buildCurrentHBVersion(List results, HandBookRequestInfo hbReqInfo, List handBookList) {
        DocumentReceipt docReceipt = (DocumentReceipt)results.get(0);
        this.buildDocument(docReceipt, hbReqInfo, handBookList);
        return handBookList;
    }

    private List buildDocument(DocumentReceipt docReceipt, HandBookRequestInfo hbReqInfo, List handBookList) {
        if (hbReqInfo.getDocType().equalsIgnoreCase("ALL")) {
            Set Documents = docReceipt.getDocuments();
            for (Document doc : Documents) {
                HandBookInfo hbi = new HandBookInfo();
                hbi.setDocType(doc.getDocumentType().getName());
                hbi.setGeneratedDate(doc.getCreationDate());
                hbi.setName(doc.getFileInfo().getName());
                hbi.setPhysicalLocation(doc.getFileInfo().getDirectory().getMountPoint().getName() + doc.getFileInfo().getDirectory().getName());
                hbi.setReleaseControlNumber(docReceipt.getReleaseControlNumber());
                hbi.setVersion(docReceipt.getVersionNumber());
                handBookList.add(hbi);
            }
        } else if (hbReqInfo.getDocType().equalsIgnoreCase("HANDBOOK")) {
            Set Documents = docReceipt.getDocuments();
            for (Document doc : Documents) {
                if (!doc.getDocumentType().getName().equalsIgnoreCase("Handbook")) continue;
                HandBookInfo hbi = new HandBookInfo();
                hbi.setDocType(doc.getDocumentType().getName());
                hbi.setGeneratedDate(doc.getCreationDate());
                hbi.setName(doc.getFileInfo().getName());
                hbi.setPhysicalLocation(doc.getFileInfo().getDirectory().getMountPoint().getName() + doc.getFileInfo().getDirectory().getName());
                hbi.setReleaseControlNumber(docReceipt.getReleaseControlNumber());
                hbi.setVersion(docReceipt.getVersionNumber());
                handBookList.add(hbi);
            }
        } else {
            Set Documents = docReceipt.getDocuments();
            for (Document doc : Documents) {
                if (doc.getDocumentType().getName().equalsIgnoreCase("Handbook")) continue;
                HandBookInfo hbi = new HandBookInfo();
                hbi.setDocType(doc.getDocumentType().getName());
                hbi.setGeneratedDate(doc.getCreationDate());
                hbi.setName(doc.getFileInfo().getName());
                hbi.setPhysicalLocation(doc.getFileInfo().getDirectory().getMountPoint().getName() + doc.getFileInfo().getDirectory().getName());
                hbi.setReleaseControlNumber(docReceipt.getReleaseControlNumber());
                hbi.setVersion(docReceipt.getVersionNumber());
                handBookList.add(hbi);
            }
        }
        return handBookList;
    }

    @Override
    public List buildHBDataString(Person person, HandBookRequestInfo hbReqInfo) throws ServiceException, DAOException {
        if (person == null || hbReqInfo == null) {
            return null;
        }
        ArrayList handBookList = new ArrayList();
        String vpid = person.getIdentityTraits().getVpid().getVPID();
        List results = this.getHandBookService().getHandbookInformation(vpid);
        if (results != null && !results.isEmpty()) {
            if (hbReqInfo.getVersion().equalsIgnoreCase("ALL")) {
                this.buildAllDataStringVersion(results, hbReqInfo, handBookList);
            } else {
                this.buildCurrentDataStringVersion(results, hbReqInfo, handBookList);
            }
        }
        return handBookList;
    }

    private List buildAllDataStringVersion(List results, HandBookRequestInfo hbReqInfo, List handBookList) {
        for (DocumentReceipt docReceipt : results) {
            this.buildDataString(docReceipt, hbReqInfo, handBookList);
        }
        return handBookList;
    }

    private List buildCurrentDataStringVersion(List results, HandBookRequestInfo hbReqInfo, List handBookList) {
        DocumentReceipt docReceipt = (DocumentReceipt)results.get(0);
        this.buildDataString(docReceipt, hbReqInfo, handBookList);
        return handBookList;
    }

    private List buildDataString(DocumentReceipt docReceipt, HandBookRequestInfo hbReqInfo, List handBookList) {
        Set Plans = docReceipt.getPlans();
        HandBookInfo hbi = new HandBookInfo();
        hbi.setDocType("Data String");
        hbi.setName("Data String");
        hbi.setReleaseControlNumber(docReceipt.getReleaseControlNumber());
        hbi.setVersion(docReceipt.getVersionNumber());
        this.populateDataStringAndDate(Plans, docReceipt, hbi);
        handBookList.add(hbi);
        return handBookList;
    }

    private void populateDataStringAndDate(Set Plans, DocumentReceipt docReceipt, HandBookInfo hbi) {
        StringBuffer formMessageBody = new StringBuffer();
        String a = "F400H^" + docReceipt.getReceiptString() + "^" + docReceipt.getVPIDValue();
        for (HealthBenefitPlan benefitPlan : Plans) {
            String b = "^" + benefitPlan.getHealthBenefitCategory() + "^" + benefitPlan.getHealthBenefitCode() + "^" + benefitPlan.getCoveragePlanCode() + '\n';
            formMessageBody.append(a);
            formMessageBody.append(b);
            hbi.setGeneratedDate(benefitPlan.getCreatedOn());
        }
        hbi.setConcatenatedString(formMessageBody);
    }

    @Override
    public EESummary buildDeliveryPreferenceInfo(DeliveryPreference deliveryPreference) {
        EESummary summary = new EESummary();
        if (deliveryPreference != null) {
            DeliveryPreferenceInfo info = new DeliveryPreferenceInfo();
            if (deliveryPreference.getDeliveryPreferenceType() != null) {
                info.setDeliveryPreference(deliveryPreference.getDeliveryPreferenceType().getName());
            }
            if (deliveryPreference.getDeliveryPreferenceEmail() != null) {
                Set emailSet = deliveryPreference.getDeliveryPreferenceEmail();
                for (DeliveryPreferenceEmail deliveryPreferenceEmail : emailSet) {
                    EmailType emailType = deliveryPreferenceEmail.getType();
                    if (emailType == null) continue;
                    if (emailType.getCode().equals("2")) {
                        info.setEmailAddress(deliveryPreferenceEmail.getAddress());
                        info.setEmailType("Business");
                        continue;
                    }
                    if (!emailType.getCode().equals("1")) continue;
                    info.setEmailAddress(deliveryPreferenceEmail.getAddress());
                    info.setEmailType("Private");
                }
            }
            summary.setDeliveryPreferenceInfo(info);
        }
        return summary;
    }

    @Override
    public void buildDeliveryPreference(DeliveryPreferenceInfo info, DeliveryPreference dp) throws ServiceException, DAOException {
        if (info != null) {
            dp.getDeliveryPreferenceType().setCode(info.getDeliveryPreference());
            dp.getSourceOfChange().setCode(DeliveryPreferenceSourceOfChange.CODE_VSS.getCode());
            dp.setModifiedBy(USER_SERVICE_DP);
            dp.setChangeDate(new Date());
            Set email = null;
            if (info.getEmailAddress() != null) {
                DeliveryPreferenceEmail dpe = new DeliveryPreferenceEmail();
                if (info.getEmailType().equalsIgnoreCase("BUSINESS")) {
                    dpe.setType(this.getLookupService().getEmailTypeByCode("2"));
                }
                if (info.getEmailType().equalsIgnoreCase("PRIVATE")) {
                    dpe.setType(this.getLookupService().getEmailTypeByCode("1"));
                }
                dpe.setAddress(info.getEmailAddress());
                email.add(dpe);
            }
            dp.setDeliveryPreferenceEmail(email);
        }
    }
}

