/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.workflow.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.service.WorkItemsSummary;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.workflow.action.WorkflowAction;
import gov.va.med.esr.ui.workflow.action.WorklistForm;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class WorklistAction
extends WorkflowAction {
    public static final String FWD_TO = "forwardTo";
    public static final String MY_CASES_TAB = "returnToMyCases";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        ((WorklistForm)form).resetFilter();
        String forwardTo = request.getParameter(FWD_TO);
        if (StringUtils.isNotEmpty((String)forwardTo)) {
            return mapping.findForward(forwardTo);
        }
        return mapping.findForward(MY_CASES_TAB);
    }

    public ActionForward displaySummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserPrincipal userPrincipal = this.getLoggedInUser();
        WorkItemsSummary workItemsSummary = this.getWorkflowService().getWorkItemsSummaryForUser(userPrincipal);
        request.setAttribute("workItemsSummary", (Object)workItemsSummary);
        this.setCurrentTab(request, "overview");
        return mapping.findForward("overview");
    }

    public ActionForward displayMyCases(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getMyCases(request, (WorklistForm)form);
        this.setCurrentTab(request, FWD_MY_CASES);
        this.updateAssignedToUserList(request);
        return mapping.findForward(FWD_MY_CASES);
    }

    public ActionForward displayAssigned(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getAssignedCases(request, (WorklistForm)form);
        this.setCurrentTab(request, FWD_ASSIGNED_CASES);
        this.updateAssignedToUserList(request);
        return mapping.findForward(FWD_ASSIGNED_CASES);
    }

    public ActionForward displayUnassigned(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getUnassignedCases(request, (WorklistForm)form);
        this.setCurrentTab(request, FWD_UNASSIGNED_CASES);
        this.updateAssignedToUserList(request);
        return mapping.findForward(FWD_UNASSIGNED_CASES);
    }

    public ActionForward displayOpenCases(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getOpenCases(request, (WorklistForm)form);
        this.setCurrentTab(request, FWD_OPEN_CASES);
        this.updateAssignedToUserList(request);
        return mapping.findForward(FWD_OPEN_CASES);
    }

    public ActionForward assignCases(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List selectedCases = this.getSelectedCases(mapping, form, request, response);
        if (StringUtils.isNotEmpty((String)((WorklistForm)form).getAssignTo()) && selectedCases.size() > 0) {
            String assignToName = ((WorklistForm)form).getAssignTo();
            ESRUserPrincipalImpl assignTo = null;
            FunctionalGroup assignToGroup = null;
            if (Capability.DQ_UNASSIGNED_POOL.getName().equals(assignToName)) {
                assignToGroup = (FunctionalGroup)this.getLookupCacheService().getByCodeFromCache(FunctionalGroup.class.getName(), FunctionalGroup.DQ.getName());
            } else {
                assignTo = this.getUserAdminService().getUserByName(assignToName);
                assignToGroup = assignTo.getFunctionalGroup();
            }
            this.getWorkflowService().assign(selectedCases, this.getLoggedInUser(), (UserPrincipal)assignTo, assignToGroup);
            this.clearCachedResults(request);
        }
        return mapping.findForward(((WorklistForm)form).getReturnLink());
    }

    public ActionForward updateCases(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List selectedCases = this.getSelectedCases(mapping, form, request, response);
        if (StringUtils.isNotEmpty((String)((WorklistForm)form).getUpdateAction()) && selectedCases.size() > 0) {
            this.getWorkflowService().close(selectedCases);
            this.clearCachedResults(request);
            this.updateHeader(request);
        }
        return mapping.findForward(((WorklistForm)form).getReturnLink());
    }

    public ActionForward applyFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        if (!this.validateFilter(request, (WorklistForm)form)) {
            // empty if block
        }
        return mapping.findForward(((WorklistForm)form).getReturnLink());
    }

    public ActionForward resetFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        WorklistForm worklistForm = (WorklistForm)form;
        worklistForm.resetFilter();
        return mapping.findForward(((WorklistForm)form).getReturnLink());
    }

    private boolean validateFilter(HttpServletRequest request, WorklistForm form) {
        Date date;
        String itemNumber;
        String ssn;
        boolean valid = true;
        if (StringUtils.isNotEmpty((String)form.getSsn()) && !(ssn = form.getSsn()).matches("([0-9]{9})") && !ssn.matches("([0-9]{3})-([0-9]{2})-([0-9]{4})")) {
            this.addActionMessage(request, "errors.ssn", ssn);
            valid = false;
            form.setSsn(null);
        }
        if (StringUtils.isNotEmpty((String)form.getVpid())) {
            try {
                String longVpid = VPIDEntityKeyImpl.getLongVPID((String)form.getVpid());
                form.setVpid(longVpid);
            }
            catch (Exception e) {
                this.addActionMessage(request, "errors.vpid", form.getVpid());
                valid = false;
                form.setVpid(null);
            }
        }
        if (StringUtils.isNotEmpty((String)form.getItemNumber()) && !(itemNumber = form.getItemNumber()).matches("[^-][0-9]+")) {
            this.addActionMessage(request, "errors.numeric", itemNumber);
            valid = false;
            form.setItemNumber(null);
        }
        if (StringUtils.isNotEmpty((String)form.getCreateDateFrom())) {
            String createDateFrom = form.getCreateDateFrom();
            date = null;
            try {
                date = DateUtils.getDate((String)createDateFrom);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.addActionMessage(request, "errors.date", createDateFrom);
                valid = false;
                form.setCreateDateFrom(null);
            }
        }
        if (StringUtils.isNotEmpty((String)form.getCreateDateTo())) {
            String createDateTo = form.getCreateDateTo();
            date = null;
            try {
                date = DateUtils.getDate((String)createDateTo);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.addActionMessage(request, "errors.date", createDateTo);
                valid = false;
                form.setCreateDateTo(null);
            }
        }
        if (StringUtils.isNotEmpty((String)form.getAssignedDateFrom())) {
            String assignedDateFrom = form.getAssignedDateFrom();
            date = null;
            try {
                date = DateUtils.getDate((String)assignedDateFrom);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.addActionMessage(request, "errors.date", assignedDateFrom);
                valid = false;
                form.setAssignedDateFrom(null);
            }
        }
        if (StringUtils.isNotEmpty((String)form.getAssignedDateTo())) {
            String assignedDateTo = form.getAssignedDateTo();
            date = null;
            try {
                date = DateUtils.getDate((String)assignedDateTo);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.addActionMessage(request, "errors.date", assignedDateTo);
                valid = false;
                form.setAssignedDateTo(null);
            }
        }
        return valid;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> keyMethodMap = new HashMap<String, String>();
        keyMethodMap.put("button.display", "display");
        keyMethodMap.put("link.name.myCases", "displayMyCases");
        keyMethodMap.put("link.name.assignedCases", "displayAssigned");
        keyMethodMap.put("link.name.unassignedCases", "displayUnassigned");
        keyMethodMap.put("link.name.openCases", "displayOpenCases");
        keyMethodMap.put("link.name.summary", "displaySummary");
        keyMethodMap.put("button.assign", "assignCases");
        keyMethodMap.put("button.update", "updateCases");
        keyMethodMap.put("button.applyFilter", "applyFilter");
        keyMethodMap.put("button.resetFilter", "resetFilter");
        return keyMethodMap;
    }
}

