/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.workflow.action;

import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.WorkflowSearchCriteria;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.workflow.action.WorkflowSearchForm;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SelectableSearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import org.apache.struts.action.ActionForm;

public class WorkflowSearchValueListAdapter
extends SelectableSearchValueListAdapter {
    private static final long serialVersionUID = 5159351847729993680L;
    private LookupService lookupService = null;

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected void populateFormAttributes(ActionForm form, SearchQueryInfo searchQueryInfo) throws ValueListException {
        WorkflowSearchForm searchForm = (WorkflowSearchForm)form;
        WorkflowSearchCriteria searchCriteria = (WorkflowSearchCriteria)searchQueryInfo;
        searchCriteria.setAssignedDateFrom(DateUtils.getDate((String)searchForm.getAssignedDateFrom()));
        searchCriteria.setAssignedDateTo(DateUtils.getDate((String)searchForm.getAssignedDateTo()));
        searchCriteria.setAssignedTo(searchForm.getAssignedTo());
        searchCriteria.setCreateDateFrom(DateUtils.getDate((String)searchForm.getCreateDateFrom()));
        searchCriteria.setCreateDateTo(DateUtils.getDate((String)searchForm.getCreateDateTo()));
        searchCriteria.setFamilyName(searchForm.getFamilyName());
        searchCriteria.setGivenName(searchForm.getGivenName());
        searchCriteria.setSsn(searchForm.getSsn());
        searchCriteria.setAssignedItems(searchForm.isAssignedItems());
        searchCriteria.setUnassignedItems(searchForm.isUnassignedItems());
        searchCriteria.setPersonId(searchForm.getPersonId());
        searchCriteria.setOpenItems(searchForm.isOpenItems());
        searchCriteria.setItemNumber(searchForm.getItemNumber());
        if (StringUtils.isNotEmpty((String)searchForm.getVpid())) {
            try {
                String longVpid = VPIDEntityKeyImpl.getLongVPID((String)searchForm.getVpid());
                ArrayList<String> vpids = new ArrayList<String>();
                vpids.add(longVpid);
                searchCriteria.setVpids(vpids);
            }
            catch (Exception e) {
                throw new ValueListException("Invalid VPID", (Throwable)e);
            }
        }
        try {
            if (StringUtils.isNotEmpty((String)searchForm.getFunctionalGroup())) {
                searchCriteria.setFunctionalGroup(this.getLookupService().getFunctionalGroupByCode(searchForm.getFunctionalGroup()));
            }
            if (StringUtils.isNotEmpty((String)searchForm.getItemStatus())) {
                searchCriteria.setItemStatus(this.getLookupService().getWkfCaseStatusTypeByCode(searchForm.getItemStatus()));
            }
            if (StringUtils.isNotEmpty((String)searchForm.getItemType())) {
                searchCriteria.setItemType(this.getLookupService().getWkfCaseTypeByCode(searchForm.getItemType()));
            }
        }
        catch (Exception e) {
            throw new ValueListException("Invalid Lookup Code", (Throwable)e);
        }
    }
}

