/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.workflow.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.WorkflowSearchType;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.workflow.action.WorkflowAction;
import gov.va.med.esr.ui.workflow.action.WorkflowSearchForm;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class WorkflowSearchAction
extends WorkflowAction {
    public static final String MSG_SEARCH_CRITERIA_EMPTY = "error.searchCriteriaEmpty";
    public static final String MSG_SEARCH_TYPE_AND_VALUE_REQUIRED = "error.searchTypeAndValueRequired";
    public static final String MSG_INVALID_FG = "error.invalidFunctionalGroup";
    public static final String MSG_INAVLID_CASE_TYPE = "error.invalidCaseType";
    public static final String MSG_INVALID_CASE_STATUS = "error.invalidCaseStatus";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        this.setCurrentTab(request, FWD_SEARCH_RESULTS);
        return mapping.findForward("display");
    }

    public ActionForward simpleSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkflowSearchForm searchForm = (WorkflowSearchForm)form;
        this.clearCachedResults(request);
        if (this.updateSearchFieldsForSimpleSearch(request, searchForm)) {
            return this.advancedSearch(mapping, (ActionForm)searchForm, request, response);
        }
        return mapping.getInputForward();
    }

    public ActionForward advancedSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkflowSearchForm searchForm = (WorkflowSearchForm)form;
        this.clearCachedResults(request);
        if (!searchForm.isSelectAll() && searchForm.isEmpty()) {
            this.addActionMessage(request, MSG_SEARCH_CRITERIA_EMPTY);
            return mapping.getInputForward();
        }
        ActionForward forward = null;
        try {
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)searchForm, (HttpServletRequest)request, (String)"workflowSearchTableId", (String)"workflowSearchAdapter");
            ValueListInfo info = valueList.getValueListInfo();
            if (info.getTotalNumberOfEntries() == 0) {
                this.addActionMessage(request, new ActionMessage("errors.search.noresult"));
                forward = mapping.findForward("display");
            } else {
                ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
                forward = mapping.findForward("results");
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            if (ex.getTotalRecords() > 0 && ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
            } else if (ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("error.personSearchExccededLimit", (Object)new Integer(ex.getRecordLimit())));
            } else {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded.noParams"));
            }
            forward = mapping.findForward("display");
        }
        this.setCurrentTab(request, FWD_SEARCH_RESULTS);
        return forward;
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return mapping.findForward("display");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean updateSearchFieldsForSimpleSearch(HttpServletRequest request, WorkflowSearchForm searchForm) throws Exception {
        String code;
        String searchField = searchForm.getSearchField();
        String searchValue = searchForm.getSearchValue();
        if (StringUtils.isEmpty((String)searchField)) {
            this.addActionMessage(request, MSG_SEARCH_CRITERIA_EMPTY);
            return false;
        }
        if (!WorkflowSearchType.CODE_ALL_ITEMS.getName().equals(searchField) && StringUtils.isEmpty((String)searchValue)) {
            this.addActionMessage(request, MSG_SEARCH_TYPE_AND_VALUE_REQUIRED);
            return false;
        }
        if (WorkflowSearchType.CODE_ASSIGNED_DATE.getName().equals(searchField) || WorkflowSearchType.CODE_CREATE_DATE.getName().equals(searchField)) {
            Date date = null;
            try {
                date = DateUtils.getDate((String)searchValue);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.addActionMessage(request, "errors.date", searchValue);
                return false;
            }
        }
        if (WorkflowSearchType.CODE_ALL_ITEMS.getName().equals(searchField)) {
            searchForm.setSelectAll(true);
            return true;
        }
        if (WorkflowSearchType.CODE_FUNCTIONAL_GROUP.getName().equals(searchField)) {
            code = this.getCode(FunctionalGroup.class, searchValue);
            if (code == null) {
                this.addActionMessage(request, MSG_INVALID_FG, searchValue);
                return false;
            }
            searchForm.setFunctionalGroup(code);
            return true;
        }
        if (WorkflowSearchType.CODE_ITEM_STATUS.getName().equals(searchField)) {
            code = this.getCode(WkfCaseStatusType.class, searchValue);
            if (code == null) {
                this.addActionMessage(request, MSG_INVALID_CASE_STATUS, searchValue);
                return false;
            }
            searchForm.setItemStatus(code);
            return true;
        }
        if (WorkflowSearchType.CODE_ITEM_TYPE.getName().equals(searchField)) {
            code = this.getCode(WkfCaseType.class, searchValue);
            if (code == null) {
                this.addActionMessage(request, MSG_INAVLID_CASE_TYPE, searchValue);
                return false;
            }
            searchForm.setItemType(code);
            return true;
        }
        if (WorkflowSearchType.CODE_ASSIGNED_TO.getName().equals(searchField)) {
            searchForm.setAssignedTo(this.getUserName(searchValue));
            return true;
        }
        if (WorkflowSearchType.CODE_ASSIGNED_DATE.getName().equals(searchField)) {
            searchForm.setAssignedDateFrom(searchValue);
            searchForm.setAssignedDateTo(searchValue);
            searchForm.setAssignedItems(true);
            return true;
        }
        if (WorkflowSearchType.CODE_CREATE_DATE.getName().equals(searchField)) {
            searchForm.setCreateDateTo(searchValue);
            searchForm.setCreateDateFrom(searchValue);
            return true;
        }
        if (WorkflowSearchType.CODE_SSN.getName().equals(searchField)) {
            if (searchValue.matches("([0-9]{9})") || searchValue.matches("([0-9]{3})-([0-9]{2})-([0-9]{4})")) {
                if (this.isPermissionGranted(Capability.SEARCH_SSN_ONLY.getCode())) {
                    searchForm.setSsn(searchValue);
                    return true;
                }
                this.addActionMessage(request, "errors.capabilityRequired", "Search By SSN");
                return false;
            }
            this.addActionMessage(request, "errors.ssn", searchValue);
            return false;
        }
        if (!WorkflowSearchType.CODE_VPID.getName().equals(searchField)) return true;
        try {
            String longVPID = VPIDEntityKeyImpl.getLongVPID((String)searchValue);
            searchForm.setVpid(longVPID);
            return true;
        }
        catch (Exception e) {
            this.addActionMessage(request, "errors.vpid", searchValue);
            return false;
        }
    }

    protected String getCode(Class clazz, String description) throws Exception {
        AbstractLookup lookup = null;
        try {
            lookup = this.getLookupService().getByDescription(clazz, description);
            if (lookup != null) {
                return lookup.getCode();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            lookup = this.getLookupCacheService().getByCodeFromCache(clazz, description);
            if (lookup != null) {
                return lookup.getCode();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    protected String getUserName(String userName) throws Exception {
        Lookup lookup = null;
        try {
            lookup = this.getUserAdminService().getByFullname(userName);
            if (lookup != null) {
                return lookup.getCode();
            }
        }
        catch (UnknownLookupTypeException e) {
        }
        catch (UnknownLookupCodeException e) {
            // empty catch block
        }
        try {
            lookup = this.getUserAdminService().getByCode(userName);
            if (lookup != null) {
                return lookup.getCode();
            }
        }
        catch (UnknownLookupTypeException e) {
        }
        catch (UnknownLookupCodeException unknownLookupCodeException) {
            // empty catch block
        }
        return userName;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.search", "advancedSearch");
        map.put("button.find", "simpleSearch");
        map.put("button.clear", "clear");
        return map;
    }
}

