/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.workflow.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.service.WorkflowSearchResultBean;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.workflow.action.WorkflowSearchForm;
import gov.va.med.esr.ui.workflow.action.WorklistForm;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.EntityNotChangedException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.SelectableResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class WorkflowAction
extends PersonAbstractAction {
    public static final String WORKFLOW_SEARCH_TABLE_ID = "workflowSearchTableId";
    public static final String WORKFLOW_SEARCH_ADAPTER = "workflowSearchAdapter";
    public static final String WORKFLOW_VALUELIST_REQUEST_KEY = "vlhlist";
    public static final String WORKFLOW_ASSIGNED_TO_LIST = "workflowAssignedToList";
    public static final String WORKFLOW_CURRENT_TAB = "workflowCurrentTab";
    public static String FWD_MY_CASES = "myCases";
    public static String FWD_ASSIGNED_CASES = "assignedCases";
    public static String FWD_UNASSIGNED_CASES = "unassignedCases";
    public static String FWD_OPEN_CASES = "openCases";
    public static String FWD_SEARCH_RESULTS = "searchResults";
    public static final String FWD_DISPLAY = "display";
    public static final String FWD_CLEAR = "clear";
    public static final String FWD_RESULTS = "results";
    public static final String FWD_OVERVIEW = "overview";
    public static String[] WORKLIST_SUPERVISOR_CAPABILITIES = new String[]{Capability.TRANSFER_WORK_ITEMS.getName(), Capability.ASSIGN_WORK_ITEMS_TO_OTHERS.getName()};
    public static String[] WORKLIST_ASSIGN_CAPABILITIES = new String[]{Capability.ASSIGN_WORK_ITEMS_TO_SELF.getName(), Capability.TRANSFER_WORK_ITEMS.getName(), Capability.ASSIGN_WORK_ITEMS_TO_OTHERS.getName()};

    protected void getMyCases(HttpServletRequest request, WorklistForm form) throws Exception {
        UserPrincipal user = this.getLoggedInUser();
        WorkflowSearchForm searchForm = new WorkflowSearchForm(form);
        searchForm.setAssignedTo(user.getName());
        searchForm.setOpenItems(true);
        this.getCases(request, searchForm);
    }

    protected void getAssignedCases(HttpServletRequest request, WorklistForm form) throws Exception {
        WorkflowSearchForm searchForm = new WorkflowSearchForm(form);
        searchForm.setAssignedItems(true);
        searchForm.setOpenItems(true);
        FunctionalGroup fg = this.getFunctionalGroup();
        searchForm.setFunctionalGroup(fg == null ? FunctionalGroup.EE.getName() : fg.getCode());
        this.getCases(request, searchForm);
    }

    protected void getUnassignedCases(HttpServletRequest request, WorklistForm form) throws Exception {
        WorkflowSearchForm searchForm = new WorkflowSearchForm(form);
        searchForm.setUnassignedItems(true);
        searchForm.setOpenItems(true);
        FunctionalGroup fg = this.getFunctionalGroup();
        searchForm.setFunctionalGroup(fg == null ? FunctionalGroup.EE.getName() : fg.getCode());
        this.getCases(request, searchForm);
    }

    protected void getOpenCases(HttpServletRequest request, WorklistForm form) throws Exception {
        Person selectedPerson = (Person)this.getSandboxEntry(request, "SelectedPerson");
        if (selectedPerson != null) {
            WorkflowSearchForm searchForm = new WorkflowSearchForm(form);
            searchForm.setOpenItems(true);
            searchForm.setPersonId(selectedPerson.getEntityKey().getKeyValueAsString());
            this.getCases(request, searchForm);
        }
    }

    protected List getSelectedCases(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ValueList valueList = ValueListActionUtils.getSelectableResultValuleList((ActionForm)form, (HttpServletRequest)request, (String)WORKFLOW_SEARCH_TABLE_ID, (String)WORKFLOW_SEARCH_ADAPTER, null);
        List selectedResults = ValueListActionUtils.getSelectedResultsFromPreviousPage((HttpServletRequest)request, (String)WORKFLOW_SEARCH_TABLE_ID, (Boolean)new Boolean(true));
        ArrayList<BigDecimal> selectedCases = new ArrayList<BigDecimal>();
        if (selectedResults != null && selectedResults.size() > 0) {
            for (SelectableResult selectableResult : selectedResults) {
                WorkflowSearchResultBean workflowSearchResultBean = (WorkflowSearchResultBean)selectableResult.getResult();
                selectedCases.add(workflowSearchResultBean.getWorkflowCaseID());
            }
        }
        return selectedCases;
    }

    protected void getCases(HttpServletRequest request, WorkflowSearchForm searchForm) {
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)searchForm, (HttpServletRequest)request, (String)WORKFLOW_SEARCH_TABLE_ID, (String)WORKFLOW_SEARCH_ADAPTER);
        ValueListInfo info = valueList.getValueListInfo();
        if (info.getTotalNumberOfEntries() > 0) {
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)WORKFLOW_VALUELIST_REQUEST_KEY);
        }
    }

    protected String getCurrentTab(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(WORKFLOW_CURRENT_TAB);
    }

    protected void setCurrentTab(HttpServletRequest request, String tabName) {
        request.getSession().setAttribute(WORKFLOW_CURRENT_TAB, (Object)tabName);
    }

    protected void clearCachedResults(HttpServletRequest request) {
        ValueListActionUtils.clearCachedResults((HttpSession)request.getSession(), (String)WORKFLOW_SEARCH_TABLE_ID);
    }

    protected FunctionalGroup getFunctionalGroup() {
        ESRUserPrincipalImpl currentUser = (ESRUserPrincipalImpl)this.getLoggedInUser();
        return currentUser.getFunctionalGroup();
    }

    protected void updateAssignedToUserList(HttpServletRequest request) throws Exception {
        if (request.getSession().getAttribute(WORKFLOW_ASSIGNED_TO_LIST) != null) {
            return;
        }
        if (this.isAnyPermissionGranted(WORKLIST_ASSIGN_CAPABILITIES)) {
            ArrayList<Lookup> users = new ArrayList<Lookup>();
            ESRUserPrincipalImpl currentUser = (ESRUserPrincipalImpl)this.getLoggedInUser();
            FunctionalGroup functionalGroup = currentUser.getFunctionalGroup();
            if (functionalGroup != null) {
                if (functionalGroup.getCode().equals(FunctionalGroup.EE.getName())) {
                    if (this.isPermissionGranted(Capability.ASSIGN_WORK_ITEMS_TO_OTHERS.getCode())) {
                        users.addAll(this.getEEUsers(functionalGroup));
                    }
                    if (this.isPermissionGranted(Capability.TRANSFER_WORK_ITEMS.getCode())) {
                        users.addAll(this.getDQManagers());
                    }
                } else if (functionalGroup.getCode().equals(FunctionalGroup.DQ.getName())) {
                    if (this.isPermissionGranted(Capability.ASSIGN_WORK_ITEMS_TO_OTHERS.getCode())) {
                        users.addAll(this.getDQUsers(functionalGroup));
                    }
                    if (this.isPermissionGranted(Capability.TRANSFER_WORK_ITEMS.getCode())) {
                        users.addAll(this.getEEManagers());
                    }
                }
                if (this.isPermissionGranted(Capability.ASSIGN_WORK_ITEMS_TO_SELF.getCode())) {
                    Lookup curUser = this.getUserAdminService().getByCode(currentUser.getName());
                    users.add(curUser);
                }
            }
            HashMap map = new HashMap();
            ArrayList<Lookup> uniqueList = new ArrayList<Lookup>();
            for (Lookup user : users) {
                if (map.containsKey(user.getCode())) continue;
                map.put(user.getCode(), null);
                uniqueList.add(user);
            }
            Collections.sort(uniqueList);
            request.getSession().setAttribute(WORKFLOW_ASSIGNED_TO_LIST, uniqueList);
        } else {
            request.getSession().setAttribute(WORKFLOW_ASSIGNED_TO_LIST, new ArrayList());
        }
    }

    protected List getDQManagers() throws Exception {
        ArrayList<ESRUserPrincipalImpl> users = new ArrayList<ESRUserPrincipalImpl>();
        List otherGroupSuprvisors = this.getUserAdminService().findUsersByRoleName(Capability.DQ_MANAGER.getCode());
        users.addAll(otherGroupSuprvisors);
        ESRUserPrincipalImpl user = new ESRUserPrincipalImpl(Capability.DQ_UNASSIGNED_POOL.getName());
        user.setFullName(Capability.DQ_UNASSIGNED_POOL.getName());
        users.add(user);
        return users;
    }

    protected List getEEManagers() throws Exception {
        List otherGroupSuprvisors = this.getUserAdminService().findUsersByRoleName(Capability.EE_SUPERVISOR.getCode());
        List otherGroupManagers = this.getUserAdminService().findUsersByRoleName(Capability.EE_MANAGER.getCode());
        otherGroupSuprvisors.addAll(otherGroupManagers);
        return otherGroupSuprvisors;
    }

    protected List getEEUsers(FunctionalGroup functionalGroup) throws Exception {
        ArrayList users = new ArrayList();
        List groupUsers = this.getUserAdminService().findUsersByRoleAndFunctionalGroup(functionalGroup, Capability.EE_LAS.getCode());
        users.addAll(groupUsers);
        List groupManagers = this.getUserAdminService().findUsersByRoleAndFunctionalGroup(functionalGroup, Capability.EE_MANAGER.getCode());
        users.addAll(groupManagers);
        return users;
    }

    protected List getDQUsers(FunctionalGroup functionalGroup) throws Exception {
        ArrayList users = new ArrayList();
        List groupUsers = this.getUserAdminService().findUsersByRoleAndFunctionalGroup(functionalGroup, Capability.DQ_ANALYST.getCode());
        users.addAll(groupUsers);
        List groupManagers = this.getUserAdminService().findUsersByRoleAndFunctionalGroup(functionalGroup, Capability.DQ_MANAGER.getCode());
        users.addAll(groupManagers);
        List groupSpecialists = this.getUserAdminService().findUsersByRoleAndFunctionalGroup(functionalGroup, Capability.DQ_SPECIALIST.getCode());
        users.addAll(groupSpecialists);
        return users;
    }

    @Override
    protected boolean requiresSelectedPerson() {
        return false;
    }

    @Override
    protected void updateHeader(HttpServletRequest request) {
        Person person = this.getSelectedPerson(request);
        if (person != null) {
            try {
                int caseCount = this.getWorkflowService().getOpenCasesCount(person.getPersonEntityKey());
                person.setOpenCasesCount(caseCount);
                super.updateHeader(request);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void processOptimisticLockException(HttpServletRequest request, ServiceOptimisticLockException ex) throws Exception {
        this.addActionMessage(request, "error.optimisticLock");
    }

    @Override
    protected void processEntityNotChangedException(HttpServletRequest request, EntityNotChangedException ex) throws Exception {
        this.addInformationMessage(request, "message.dataNotChanged");
    }

    public void afterPropertiesSet() {
    }
}

