/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.workflow.action;

import gov.va.med.esr.common.model.cases.Assignment;
import gov.va.med.esr.common.model.cases.Comment;
import gov.va.med.esr.common.model.cases.Status;
import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.workflow.action.WorkItemForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class WorkItemConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof WorkflowCase && target instanceof WorkItemForm) {
            this.convert((WorkflowCase)source, (WorkItemForm)((Object)target));
        } else if (target instanceof WorkflowCase && source instanceof WorkItemForm) {
            this.convert((WorkItemForm)((Object)source), (WorkflowCase)target);
        } else {
            throw new ConversionServiceException("Can not conver from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    private void convert(WorkflowCase workflowCase, WorkItemForm workItemForm) throws ConversionServiceException {
        FunctionalGroup functionalGroup;
        Status currentStatus;
        workItemForm.setWorkflowCaseId(workflowCase.getWorkflowCaseID().toString());
        workItemForm.setPersonId(workflowCase.getPerson().getEntityKey().getKeyValueAsString());
        Assignment currentAssignment = workflowCase.getAssignment();
        if (currentAssignment != null) {
            workItemForm.setAssignedTo(currentAssignment.getAssignedTo());
        }
        if ((currentStatus = workflowCase.getStatus()) != null) {
            workItemForm.setStatusValue(currentStatus.getStatusValue() == null ? null : currentStatus.getStatusValue().getCode());
        }
        workItemForm.setCaseGroup((functionalGroup = workflowCase.getGroupType()) == null ? "" : functionalGroup.getCode());
        ESRUserPrincipalImpl loogedInUser = (ESRUserPrincipalImpl)this.getLoggedInUser();
        workItemForm.setLoggedInUserName(loogedInUser.getName());
        FunctionalGroup userFunctionalGroup = loogedInUser.getFunctionalGroup();
        workItemForm.setLoggedInUserGroup(userFunctionalGroup == null ? "" : userFunctionalGroup.getCode());
        ArrayList comments = new ArrayList(workflowCase.getComments());
        Date currentDate = DateUtils.getCurrentDate();
        String currentUser = loogedInUser.getName();
        if (comments.size() > 0) {
            Collections.sort(comments);
            Comment comment = (Comment)comments.get(comments.size() - 1);
            if (currentDate.before(comment.getCreatedOn()) && currentUser.equalsIgnoreCase(comment.getModifiedBy().getName())) {
                workItemForm.setComment(comment.getCommentText());
                workItemForm.setCommentId(comment.getEntityKey().getKeyValueAsString());
            }
        }
    }

    private void convert(WorkItemForm workItemForm, WorkflowCase workflowCase) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            if (StringUtils.isNotEmpty((String)workItemForm.getComment())) {
                Comment comment = null;
                if (StringUtils.isNotEmpty((String)workItemForm.getCommentId())) {
                    Set comments = workflowCase.getComments();
                    Iterator i = comments.iterator();
                    while (i.hasNext() && ((comment = (Comment)i.next()) == null || !workItemForm.getCommentId().equals(comment.getEntityKey().getKeyValueAsString()))) {
                    }
                    if (comment != null) {
                        comment.setCommentText(workItemForm.getComment());
                    }
                } else {
                    comment = new Comment();
                    if (comment != null) {
                        comment.setCommentText(workItemForm.getComment());
                        workflowCase.addComments(comment);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)workItemForm.getAssignedTo())) {
                Assignment assignment = workflowCase.getAssignment();
                if (assignment == null) {
                    assignment = new Assignment();
                    assignment.setAssignedTo(workItemForm.getAssignedTo());
                    assignment.setAssignmentDate(DateUtils.getCurrentDate());
                    assignment.setAssignedBy(this.getLoggedInUser().getName());
                    workflowCase.setAssignment(assignment);
                } else if (!workItemForm.getAssignedTo().equals(assignment.getAssignedTo())) {
                    assignment.setAssignedTo(workItemForm.getAssignedTo());
                    assignment.setAssignmentDate(DateUtils.getCurrentDate());
                    assignment.setAssignedBy(this.getLoggedInUser().getName());
                }
            }
            if (StringUtils.isNotEmpty((String)workItemForm.getStatusValue())) {
                WkfCaseStatusType statusType = (WkfCaseStatusType)lookupCacheService.getByCodeFromCache(WkfCaseStatusType.class, workItemForm.getStatusValue());
                Status status = workflowCase.getStatus();
                if (status == null) {
                    status = new Status();
                    status.setStatusValue(statusType);
                    workflowCase.setStatus(status);
                } else if (!statusType.equals((Object)status.getStatusValue())) {
                    status.setStatusValue(statusType);
                    workflowCase.setStatus(status);
                }
            }
        }
        catch (Exception e) {
            throw new ConversionServiceException("Conversion Failed ", e);
        }
    }
}

