/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.workflow.action;

import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.ui.workflow.action.WorkItemForm;
import gov.va.med.esr.ui.workflow.action.WorkflowAction;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class WorkItemAction
extends WorkflowAction {
    public static final String PARAM_SELECTED_CASE_ID = "selectedCaseId";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String caseId = request.getParameter(PARAM_SELECTED_CASE_ID);
        if (StringUtils.isEmpty((String)caseId)) {
            caseId = (String)request.getAttribute(PARAM_SELECTED_CASE_ID);
        }
        this.setPristineEntity(request, null);
        this.setUpdatedEntity(request, null);
        WorkItemForm workItemForm = (WorkItemForm)form;
        EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(caseId), WorkflowCase.class);
        WorkflowCase workflowCase = this.getWorkflowService().find(entityKey);
        if (workflowCase == null) {
            throw new Exception("Workflow Case not found");
        }
        this.setPristineEntity(request, workflowCase);
        this.conversionService.convert((Object)workflowCase, (Object)workItemForm);
        return mapping.findForward("success");
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkItemForm workItemForm = (WorkItemForm)form;
        WorkflowCase pristineWorkflowCase = (WorkflowCase)this.getPristineEntity(request);
        WorkflowCase updatedWorkflowCase = (WorkflowCase)pristineWorkflowCase.clone();
        this.conversionService.convert((Object)workItemForm, (Object)updatedWorkflowCase);
        this.getWorkflowService().updateWorkItem(updatedWorkflowCase);
        this.clearCachedResults(request);
        this.updateHeader(request);
        this.setPristineEntity(request, null);
        return mapping.findForward(this.getCurrentTab(request));
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setPristineEntity(request, null);
        return mapping.findForward("returnTo" + this.getCurrentTab(request));
    }

    @Override
    protected ActionForward handleEntityNotChangedException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        WorkflowCase pristineWorkflowCase = (WorkflowCase)this.getPristineEntity(request);
        request.setAttribute(PARAM_SELECTED_CASE_ID, (Object)String.valueOf(pristineWorkflowCase.getEntityKey().getKeyValue()));
        return this.display(mapping, form, request, response);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        WorkflowCase pristineWorkflowCase = (WorkflowCase)this.getPristineEntity(request);
        request.setAttribute(PARAM_SELECTED_CASE_ID, (Object)String.valueOf(pristineWorkflowCase.getEntityKey().getKeyValue()));
        return this.display(mapping, form, request, response);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.update", "update");
        map.put("button.cancel", "cancel");
        map.put("button.display", "display");
        return map;
    }
}

