/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.voa.action;

import gov.va.med.esr.ui.common.beans.VOASearchType;
import gov.va.med.esr.ui.voa.action.VOAResubmissionAction;
import gov.va.med.esr.ui.voa.action.VOASearchForm;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class VOASearchAction
extends VOAResubmissionAction {
    public static final String MSG_SEARCH_CRITERIA_EMPTY = "error.searchCriteriaEmpty";
    public static final String MSG_SEARCH_TYPE_AND_VALUE_REQUIRED = "error.searchTypeAndValueRequired";
    public static final String VOA_SEARCH_TABLE_ID = "voaResubmissionSearchTableId";
    public static final String VOA_SEARCH_ADAPTER = "voaResubmissionSearchAdapter";
    public static final String VALUELIST = "vlhlist";
    public static String FWD_PENDING_SUBMISSIONS = "pendingSubmissions";
    public static String FWD_SEARCH_RESULTS = "searchResults";
    public static final String FWD_DISPLAY = "displayPendingSubmissions";
    public static final String FWD_CLEAR = "clear";
    public static final String FWD_RESULTS = "results";
    public static final String FWD_OVERVIEW = "overview";

    public ActionForward displayPendingSubmissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        return mapping.findForward(FWD_DISPLAY);
    }

    public ActionForward simpleSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VOASearchForm searchForm = (VOASearchForm)form;
        this.clearCachedResults(request);
        if (this.updateSearchFieldsForSimpleSearch(request, searchForm)) {
            return this.advancedSearch(mapping, (ActionForm)searchForm, request, response);
        }
        return mapping.getInputForward();
    }

    public ActionForward advancedSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VOASearchForm searchForm = (VOASearchForm)form;
        this.clearCachedResults(request);
        if (!searchForm.isSelectAll() && searchForm.isEmpty()) {
            this.addActionMessage(request, MSG_SEARCH_CRITERIA_EMPTY);
            return mapping.getInputForward();
        }
        ActionForward forward = null;
        try {
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)searchForm, (HttpServletRequest)request, (String)VOA_SEARCH_TABLE_ID, (String)VOA_SEARCH_ADAPTER);
            ValueListInfo info = valueList.getValueListInfo();
            if (info.getTotalNumberOfEntries() == 0) {
                this.addActionMessage(request, new ActionMessage("errors.search.noresult"));
                forward = mapping.findForward(FWD_DISPLAY);
            } else {
                ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)VALUELIST);
                forward = mapping.findForward(FWD_DISPLAY);
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            if (ex.getTotalRecords() > 0 && ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
            } else if (ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("error.personSearchExccededLimit", (Object)new Integer(ex.getRecordLimit())));
            } else {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded.noParams"));
            }
            forward = mapping.findForward(FWD_DISPLAY);
        }
        return forward;
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return mapping.findForward(FWD_CLEAR);
    }

    protected boolean updateSearchFieldsForSimpleSearch(HttpServletRequest request, VOASearchForm searchForm) throws Exception {
        String searchField = searchForm.getSearchField();
        String searchValue = searchForm.getSearchValue();
        if (StringUtils.isEmpty((String)searchField)) {
            this.addActionMessage(request, MSG_SEARCH_CRITERIA_EMPTY);
            return false;
        }
        if (!VOASearchType.CODE_ALL_PENDING_SUBMISSIONS.getName().equals(searchField) && StringUtils.isEmpty((String)searchValue)) {
            this.addActionMessage(request, MSG_SEARCH_TYPE_AND_VALUE_REQUIRED);
            return false;
        }
        if (VOASearchType.CODE_ALL_PENDING_SUBMISSIONS.getName().equals(searchField)) {
            searchForm.setSelectAll(true);
        } else if (VOASearchType.CODE_SUBMISSION_ID.getName().equals(searchField)) {
            searchForm.setApplicationId(searchValue);
        } else if (VOASearchType.CODE_FORM_TYPE.getName().equals(searchField)) {
            searchForm.setFormTypeValue(searchValue);
        } else if (VOASearchType.CODE_REQUEST_RECEIVED_DATE.getName().equals(searchField)) {
            searchForm.setReqRecdDateTo(searchValue);
            searchForm.setReqRecdDateFrom(searchValue);
        } else if (VOASearchType.CODE_FORM_PENDING_REASON.getName().equals(searchField)) {
            searchForm.setFormPendingReason(searchValue);
        }
        return true;
    }

    protected String getCode(Class clazz, String description) throws Exception {
        AbstractLookup lookup = null;
        try {
            lookup = this.getLookupService().getByDescription(clazz, description);
            if (lookup != null) {
                return lookup.getCode();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            lookup = this.getLookupCacheService().getByCodeFromCache(clazz, description);
            if (lookup != null) {
                return lookup.getCode();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> keyMethodMap = new HashMap<String, String>();
        keyMethodMap.put("link.name.pendingSubmissions", FWD_DISPLAY);
        keyMethodMap.put("link.name.searchVOAResubmission", "displayPendingResubmissions");
        keyMethodMap.put("button.display", FWD_DISPLAY);
        keyMethodMap.put("button.search", "search");
        keyMethodMap.put("button.clear", FWD_CLEAR);
        return keyMethodMap;
    }
}

