/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.voa.action;

import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.ui.voa.action.VOAPendingListForm;
import gov.va.med.esr.ui.voa.action.VOAResubmissionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VOAPendingListAction
extends VOAResubmissionAction {
    public static final String PENDING_SUBMISSION = "voaPendingList";
    public static final String FWD_DISPLAY = "displayPendingSubmissions";
    public static final String TXT_1010EZ = "1010EZ";
    public static final String TXT_1010EZR = "1010EZR";
    public static final String TXT_1010HS = "1010HS";
    public static final String TXT_1010SH = "1010SH";
    public static final String TXT_1010CG = "1010CG";
    public static final String TXT_21526EZ = "21526EZ";
    public static final String PENDING_IDENTITY_TRAITS = "Pending Identity Traits Update";
    public static final String PERSON_NOT_FOUND = "Person not found";
    public static final String PROXY_PF_FAILED = "Proxy PF Add Failed";
    public static final String PERSON_INFO_NOT_ACCEPTED = "Person Info Not Accepted";
    private VOAApplication voaApplication = null;

    public ActionForward displayPendingSubmissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        ((VOAPendingListForm)form).resetFilter();
        this.getPendingSubmissions(request, (VOAPendingListForm)form);
        return mapping.findForward(FWD_PENDING_SUBMISSIONS);
    }

    public ActionForward resubmitVOAApplications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List selectedPendingSubmissions = this.getSelectedPendingSubmissions(mapping, form, request, response);
        if (selectedPendingSubmissions.size() > 0) {
            this.getVoaApplicationService().resubmit(selectedPendingSubmissions);
            this.clearCachedResults(request);
        }
        return mapping.findForward(FWD_DISPLAY);
    }

    public ActionForward applyFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        if (this.validateFilter(request, (VOAPendingListForm)form)) {
            this.getPendingSubmissions(request, (VOAPendingListForm)form);
        }
        return mapping.findForward(FWD_PENDING_SUBMISSIONS);
    }

    public ActionForward resetFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearCachedResults(request);
        VOAPendingListForm voaPendingListForm = (VOAPendingListForm)form;
        voaPendingListForm.resetFilter();
        return mapping.findForward(FWD_DISPLAY);
    }

    private boolean validateFilter(HttpServletRequest request, VOAPendingListForm form) {
        Date date;
        String applicationId;
        boolean valid = true;
        if (StringUtils.isNotEmpty((String)form.getApplicationId()) && !(applicationId = form.getApplicationId()).matches("[^-][0-9]+")) {
            this.addActionMessage(request, "errors.numeric", applicationId);
            valid = false;
            form.setApplicationId(null);
        }
        if (StringUtils.isNotEmpty((String)form.getReqRecdDateFrom())) {
            String reqRecdDateFrom = form.getReqRecdDateFrom();
            date = null;
            try {
                date = CommonDateUtils.getDate((String)reqRecdDateFrom);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.addActionMessage(request, "errors.date", reqRecdDateFrom);
                valid = false;
                form.setReqRecdDateFrom(null);
            }
        }
        if (StringUtils.isNotEmpty((String)form.getReqRecdDateTo())) {
            String reqRecdDateTo = form.getReqRecdDateTo();
            date = null;
            try {
                date = CommonDateUtils.getDate((String)reqRecdDateTo);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.addActionMessage(request, "errors.date", reqRecdDateTo);
                valid = false;
                form.setReqRecdDateTo(null);
            }
        }
        if (StringUtils.isNotEmpty((String)form.getFormTypeValue())) {
            String formTypeValue = form.getFormTypeValue();
            if (formTypeValue.equals(TXT_1010EZ) || formTypeValue.equals(TXT_1010EZR) || formTypeValue.equals(TXT_1010HS) || formTypeValue.equals(TXT_1010SH) || formTypeValue.equals(TXT_1010CG) || formTypeValue.equals(TXT_21526EZ)) {
                valid = true;
            } else {
                this.addActionMessage(request, "errors.form.type", formTypeValue);
                valid = false;
                form.setFormType(null);
            }
        }
        if (StringUtils.isNotEmpty((String)form.getFormPendingReason())) {
            String formPendingReason = form.getFormPendingReason();
            if (formPendingReason.equalsIgnoreCase(PENDING_IDENTITY_TRAITS) || formPendingReason.equalsIgnoreCase(PERSON_NOT_FOUND) || formPendingReason.equalsIgnoreCase(PROXY_PF_FAILED) || formPendingReason.equalsIgnoreCase(PERSON_INFO_NOT_ACCEPTED)) {
                valid = true;
            } else {
                this.addActionMessage(request, "errors.pending.reason", formPendingReason);
                valid = false;
                form.setFormPendingReason(null);
            }
        }
        return valid;
    }

    public VOAApplication getVoaApplication() {
        return this.voaApplication;
    }

    public void setVoaApplication(VOAApplication voaApplication) {
        this.voaApplication = voaApplication;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> keyMethodMap = new HashMap<String, String>();
        keyMethodMap.put("link.name.pendingSubmissions", FWD_DISPLAY);
        keyMethodMap.put("button.applyFilter", "applyFilter");
        keyMethodMap.put("button.resetFilter", "resetFilter");
        keyMethodMap.put("button.resubmit", "resubmitVOAApplications");
        return keyMethodMap;
    }
}

