/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.util;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.TriState;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AffectedExtremity;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.CDDeterminationMethod;
import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.Condition;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.EligibilityFactor;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.EmailSourceOfChange;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.FeeBasisProgram;
import gov.va.med.esr.common.model.lookup.FeeBasisTreatmentType;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.InsurancePlanType;
import gov.va.med.esr.common.model.lookup.InsuredRelationship;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MilitarySexualTraumaStatus;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.NTRVerificationMethod;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.POWCampLocation;
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.lookup.Procedure;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.EGTService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.ui.util.ServiceOutageException;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.security.Principal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.ps.model.PersonVPID;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockPersonBuilder
extends AbstractComponent {
    private static final Log log = LogFactory.getLog(MockPersonBuilder.class);
    private LookupService lookupService = null;
    private PersonHelperService personHelperService = null;
    private PersonService personService = null;
    private EGTService egtService = null;
    private static BigDecimal identifier = new BigDecimal(1000);
    private static boolean setIdentifierActive = true;

    public Person getPerson(String personId) throws Exception {
        Person person = null;
        if (personId == null) {
            log.info((Object)"No person Id specified so returning mock person.");
        } else {
            try {
                if (this.personIdValid(personId)) {
                    PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey((String)personId);
                    person = this.getPersonService().getPerson((PersonEntityKey)personKey);
                }
            }
            catch (ServiceException se) {
                log.error((Object)("Could not retrive the person with the id " + personId), (Throwable)se);
            }
        }
        if (person == null) {
            try {
                person = this.buildPerson();
                MockPersonBuilder.setIdentifier(person, new BigDecimal(12345));
            }
            catch (Exception ex) {
                throw new ServiceOutageException("Unable to build Person Object", ex);
            }
        } else {
            this.setAdditionalData(person);
        }
        return person;
    }

    public boolean personIdValid(String personId) {
        try {
            Integer.parseInt(personId);
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)("Invalid Person Id: '" + personId + "'."), (Throwable)nfe);
            return false;
        }
        return true;
    }

    public Person getSimplePerson() throws Exception {
        return this.buildSimplePerson();
    }

    public Person createPersonInDB() throws Exception {
        MockPersonBuilder.disableSetIdentifier();
        Person person = this.buildPerson();
        this.personService.save(person);
        MockPersonBuilder.enableSetIdentifier();
        return person;
    }

    protected Calendar createCalendar(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar;
    }

    protected Calendar createCalendar(int year, int month) {
        Calendar calendar = this.createCalendar(year);
        calendar.set(2, month - 1);
        return calendar;
    }

    protected Calendar createCalendar(int year, int month, int day) {
        Calendar calendar = this.createCalendar(year, month);
        calendar.set(5, day);
        return calendar;
    }

    protected Calendar createCalendar(int year, int month, int day, int hour) {
        Calendar calendar = this.createCalendar(year, month, day);
        calendar.set(11, hour);
        return calendar;
    }

    protected Calendar createCalendar(int year, int month, int day, int hour, int minute) {
        Calendar calendar = this.createCalendar(year, month, day, hour);
        calendar.set(12, minute);
        return calendar;
    }

    protected Calendar createCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = this.createCalendar(year, month, day, hour, minute);
        calendar.set(13, second);
        return calendar;
    }

    protected Calendar createCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar calendar = this.createCalendar(year, month, day, hour, minute, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    protected ImpreciseDate createImpreciseDate(int year) {
        return new ImpreciseDate(this.createCalendar(year));
    }

    protected ImpreciseDate createImpreciseDate(int year, int month) {
        return new ImpreciseDate(this.createCalendar(year, month));
    }

    protected ImpreciseDate createImpreciseDate(int year, int month, int day) {
        return new ImpreciseDate(this.createCalendar(year, month, day));
    }

    protected ImpreciseDate createImpreciseDate(int year, int month, int day, int hour) {
        return new ImpreciseDate(this.createCalendar(year, month, day, hour));
    }

    protected ImpreciseDate createImpreciseDate(int year, int month, int day, int hour, int minute) {
        return new ImpreciseDate(this.createCalendar(year, month, day, hour, minute));
    }

    protected ImpreciseDate createImpreciseDate(int year, int month, int day, int hour, int minute, int second) {
        return new ImpreciseDate(this.createCalendar(year, month, day, hour, minute, second));
    }

    protected ImpreciseDate createImpreciseDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return new ImpreciseDate(this.createCalendar(year, month, day, hour, minute, second, millisecond));
    }

    protected Serializable generatePersonID() throws Exception {
        return null;
    }

    protected Person buildPerson() throws Exception {
        Person person = this.buildSimplePerson();
        ServiceConnectionAward serviceConnectionAward = new ServiceConnectionAward();
        serviceConnectionAward.setServiceConnectedPercentage(new Integer(60));
        serviceConnectionAward.setCombinedServiceConnectedPercentageEffectiveDate(this.createImpreciseDate(2004, 5, 5));
        serviceConnectionAward.addRatedDisability(this.createRatedDisability(Disability.CODE_RESPIRATORY_CONDITION_GENERAL.getName(), new Integer(60)));
        serviceConnectionAward.setUnemployable(Boolean.TRUE);
        serviceConnectionAward.setPermanentAndTotal(Boolean.TRUE);
        serviceConnectionAward.setPermanentAndTotalEffectiveDate(this.createCalendar(2000, 2, 1).getTime());
        person.setServiceConnectionAward(serviceConnectionAward);
        person.setBirthRecord(this.createBirthRecord(this.createImpreciseDate(1969, 1, 1)));
        person.setDeathRecord(this.createDeathRecord());
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_EXEMPT_LTC_COPAY_EXEMPTION_TEST.getName(), new Integer(2004));
        incomeTest.setSiteConductingTest(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
        incomeTest.setEffectiveDate(this.createCalendar(1995, 2, 1).getTime());
        person.setIncomeTest(new Integer(2004), incomeTest);
        this.attachSignature(person);
        MonetaryBenefitAward mba = new MonetaryBenefitAward();
        mba.setCheckAmount(new BigDecimal(20));
        mba.addMonetaryBenefit(this.createMonetaryBenefit(MonetaryBenefitType.CODE_HOUSEBOUND.getName()));
        mba.addMonetaryBenefit(this.createMonetaryBenefit(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName()));
        mba.addMonetaryBenefit(this.createMonetaryBenefit(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName()));
        mba.addMonetaryBenefit(this.createMonetaryBenefit(MonetaryBenefitType.CODE_VA_PENSION.getName()));
        person.setMonetaryBenefitAward(mba);
        person.addSpecialFactor((SpecialFactor)this.createAgentOrange());
        person.setEnrollmentDetermination(this.createEnrollmentDetermination());
        person.setCancelDecline(this.createCancelDecline());
        EnrollmentOverride override = new EnrollmentOverride();
        override.setOverride(Boolean.TRUE);
        override.setOverrideReason(null);
        override.setOverrideComment("Test Comment");
        person.setEnrollmentOverride(override);
        this.attachCatastrophicDisability(person);
        this.attachMilitarySexualTrauma(person);
        this.attachNoseThroatRadium(person);
        this.attachPOW(person);
        this.attachPurpleHeartWithPHStatusPending(person);
        this.attachRatedIncompetent(person);
        this.attachIneligibleFactor(person);
        this.attachMedicaidFactor(person);
        person.setEligibilityVerification(this.createEligibilityVerification());
        this.setAACIndicator("2", person);
        this.attachApplication(person);
        person.addAddress(this.createPrimaryAddress());
        person.addAddress(this.createTemporayCorrespondanceAddress());
        person.addAddress(this.createConfidentialAddress());
        person.addPhone(this.createHomePhone(MockPersonBuilder.getNextId()));
        person.addPhone(this.createBusinessPhone(MockPersonBuilder.getNextId()));
        person.addEmail(this.createPrivateEmail(MockPersonBuilder.getNextId()));
        person.addEmail(this.createBusinessEmail(MockPersonBuilder.getNextId()));
        this.attachAssociation(person);
        this.attachAgentOrangeExposure(person);
        this.attachEnvironmentalContaminationExposure(person);
        this.attachRadiationExposure(person);
        this.attachEnvironmentalContaminationExposure(person);
        this.attachRadiationExposure(person);
        this.attachTriCare(person);
        this.attachOtherFederalAgency(person);
        this.attachMilitaryService(person);
        this.attachPreferredFacility(person);
        this.attachPatientVisitSummaries(person);
        this.attachInsurance(person);
        this.attachFinancialInfo(person, new Integer(2005));
        this.attachFinancialInfo(person, new Integer(2003));
        return person;
    }

    protected void setAdditionalData(Person person) throws Exception {
    }

    protected Person buildSimplePerson() throws Exception {
        Person person = new Person();
        person.addName(this.createName("TEST", "PERSON", NameType.LEGAL_NAME.getName()));
        person.addSsn(this.createSSN("456010001", SSNType.CODE_ACTIVE.getName()));
        person.setBirthRecord(this.createBirthRecord(this.createImpreciseDate(1950, 1, 1)));
        person.setGender(this.lookupService.getGenderByCode(Gender.MALE.getName()));
        PersonVPID.initializeVPID((Person)person, (String)"12345678");
        person.setSensitiveRecord(Boolean.TRUE);
        person.setVeteran(Boolean.TRUE);
        return person;
    }

    protected SSN createSSN(String text, String ssnTypeCode) throws Exception {
        SSN ssn = new SSN();
        ssn.setSsnText(text);
        ssn.setType(this.lookupService.getSSNTypeByCode(ssnTypeCode));
        return ssn;
    }

    protected IncomeTest createIncomeTest(String testType, String status, Integer incomeYear) throws Exception {
        IncomeTest incomeTest = new IncomeTest();
        incomeTest.setIncomeYear(incomeYear);
        incomeTest.setType(this.lookupService.getIncomeTestTypeByCode(testType));
        incomeTest.setIncomeVerificationStatus(this.lookupService.getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName()));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1000));
        incomeTest.setThresholdA(new BigDecimal(2000));
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.FALSE);
        incomeTest.setTotalNumberOfDependents(new Integer(0));
        IncomeTestStatus incomeTestStatus = new IncomeTestStatus();
        incomeTestStatus.setStatus(this.lookupService.getMeansTestStatusByCode(status));
        incomeTestStatus.setType(this.lookupService.getIncomeTestTypeByCode(testType));
        incomeTestStatus.setCompletedDate(new Date());
        incomeTest.addStatus(incomeTestStatus);
        return incomeTest;
    }

    protected ReceivedEligibility createReceivedEligibility(String type) throws Exception {
        ReceivedEligibility receivedEligibility = new ReceivedEligibility();
        receivedEligibility.setType(this.lookupService.getEligibilityTypeByCode(type));
        return receivedEligibility;
    }

    protected void setServiceConnectedPercentage(Integer percentage, Person person) {
        ServiceConnectionAward scw = person.getServiceConnectionAward();
        scw.setServiceConnectedPercentage(percentage);
    }

    protected MonetaryBenefit createMonetaryBenefit(String type) throws Exception {
        MonetaryBenefit monetaryBenefit = new MonetaryBenefit();
        monetaryBenefit.setType(this.lookupService.getMonetaryBenefitTypeByCode(type));
        return monetaryBenefit;
    }

    protected CDCondition createCDCondition() throws Exception {
        CDCondition condition = new CDCondition();
        condition.setCondition(this.lookupService.getConditionByCode(Condition.CODE_FIM.getName()));
        condition.setScore(new Integer(45));
        return condition;
    }

    protected CDDiagnosis createCDDiagnosis() throws Exception {
        CDDiagnosis diagnosis = new CDDiagnosis();
        diagnosis.setDiagnosis(this.lookupService.getDiagnosisByCode(Diagnosis.CODE_QUADRIPLEGIA_C1_C4_COMPLETE.getName()));
        return diagnosis;
    }

    protected CDProcedure createCDProcedure() throws Exception {
        CDProcedure procedure = new CDProcedure();
        procedure.setAffectedExtremity(this.lookupService.getAffectedExtremityByCode(AffectedExtremity.CODE_RIGHT_UPPER.getName()));
        procedure.setProcedure(this.lookupService.getProcedureByCode(Procedure.CODE_TOE_AMPUTATION.getName()));
        return procedure;
    }

    protected CatastrophicDisability createCatastrophicDisability(Date reviewDate, Date determinationDate, String cdDeterminationType, String determineBy) throws Exception {
        CatastrophicDisability catastrophicDisability = new CatastrophicDisability();
        catastrophicDisability.setDecisionDate(determinationDate);
        catastrophicDisability.setReviewDate(reviewDate);
        catastrophicDisability.setDeterminedBy(determineBy);
        catastrophicDisability.setVeteranRequestedCDReviewDate(this.createCalendar(2004, 5, 5).getTime());
        catastrophicDisability.setFacilityInitiatedCDReviewDate(this.createCalendar(2004, 5, 9).getTime());
        catastrophicDisability.setVeteranWasNotifiedCDDate(this.createCalendar(2004, 6, 9).getTime());
        CDDeterminationMethod cdDeterminationMethod = this.lookupService.getCdDeterminationMethodByCode(cdDeterminationType);
        catastrophicDisability.setDeterminationMethod(cdDeterminationMethod);
        catastrophicDisability.setDeterminationFacility(this.getVaFacility(VAFacility.CODE_NEW_BEDFORD_CBOC.getName()));
        catastrophicDisability.setCatastrophicallyDisabled(Boolean.TRUE);
        catastrophicDisability.addCondition(this.createCDCondition());
        catastrophicDisability.addDiagnosis(this.createCDDiagnosis());
        catastrophicDisability.addProcedure(this.createCDProcedure());
        return catastrophicDisability;
    }

    protected Name createName(String familyName, String givenName, String type) throws Exception {
        Name name = new Name();
        NameType nameType = this.lookupService.getNameTypeByCode(type);
        name.setFamilyName(familyName);
        name.setGivenName(givenName);
        name.setType(nameType);
        return name;
    }

    protected RatedDisability createRatedDisability(String type, Integer percent) throws Exception {
        RatedDisability ratedDisability = new RatedDisability();
        ratedDisability.setPercentage(new Integer(60));
        ratedDisability.setServiceConnected(Boolean.TRUE);
        ratedDisability.setDisability(this.lookupService.getDisabilityByCode(type));
        ratedDisability.setDiagnosticExtremity(null);
        ratedDisability.setOriginalEffectiveRatingDate(this.createImpreciseDate(1999, 12, 12));
        ratedDisability.setRatingDate(this.createImpreciseDate(1999, 12, 20));
        return ratedDisability;
    }

    protected BirthRecord createBirthRecord(ImpreciseDate date) {
        BirthRecord birthRecord = new BirthRecord();
        birthRecord.setBirthDate(date);
        return birthRecord;
    }

    protected AgentOrangeExposure createAgentOrange() throws Exception {
        AgentOrangeExposure agentOrangeExposure = new AgentOrangeExposure();
        agentOrangeExposure.setLocation(this.lookupService.getAgentOrangeExposureLocationByCode(AgentOrangeExposureLocation.CODE_VIETNAM.getName()));
        return agentOrangeExposure;
    }

    protected EnvironmentalContaminationExposure createEnvironmentalContaminationExposure() throws Exception {
        return new EnvironmentalContaminationExposure();
    }

    protected RadiationExposure createRadiationExposure() throws Exception {
        RadiationExposure radiationExposure = new RadiationExposure();
        radiationExposure.setExposureMethod(this.lookupService.getRadiationExposureMethodByCode(RadiationExposureMethod.CODE_ATMOSPHERIC_NUCLEAR_TESTING.getName()));
        return radiationExposure;
    }

    protected void setAACIndicator(String code, Person person) throws Exception {
        this.personHelperService.setAACIndicator(code, person);
    }

    protected void setEligibilityStatus(String status, Person person) throws Exception {
        this.personHelperService.setEligibilityStatus(status, person);
    }

    protected void setEligibilityStatusToVerified(Person person) throws Exception {
        this.setEligibilityStatus(EligibilityStatus.CODE_VERIFIED.getName(), person);
    }

    protected void setEligibilityStatusToPendingVerification(Person person) throws Exception {
        this.setEligibilityStatus(EligibilityStatus.CODE_PENDING_VERIFICATION.getName(), person);
    }

    protected void setEligibilityStatusToPendingReverification(Person person) throws Exception {
        this.setEligibilityStatus(EligibilityStatus.CODE_PENDING_REVERIFICATION.getName(), person);
    }

    protected String getEligibilityStatusCode(Person person) throws Exception {
        EligibilityStatus status = this.personHelperService.getEligibilityStatus(person);
        return status != null ? status.getCode() : null;
    }

    protected void setEnrollmentStatus(String status, Person person) throws Exception {
        this.personHelperService.setEnrollmentStatus(status, person);
    }

    protected String getEnrollmentCategoryCode(Person person) throws Exception {
        EnrollmentCategory status = this.personHelperService.getEnrollmentCategory(person);
        return status != null ? status.getCode() : null;
    }

    protected String getEnrollmentStatusCode(Person person) throws Exception {
        EnrollmentStatus status = this.personHelperService.getEnrollmentStatus(person);
        return status != null ? status.getCode() : null;
    }

    protected void setPurpleHeartStatus(String status, Person person) throws Exception {
        this.personHelperService.setPurpleHeartStatus(status, person);
    }

    protected String getPurpleHeartStatusCode(Person person) throws Exception {
        DecorationStatus decorationStatus = this.personHelperService.getPurpleHeartStatus(person);
        return decorationStatus != null ? decorationStatus.getCode() : null;
    }

    protected void assessIfHasPrimaryRanking(String type, Person person) {
        this.assertTrue(this.hasPrimaryEligibility(type, person));
        this.assertFalse(this.hasSecondaryEligibility(type, person));
        this.assertFalse(this.hasOtherEligibility(type, person));
    }

    protected void assessIfHasOtherRanking(String type, Person person) {
        this.assertFalse(this.hasPrimaryEligibility(type, person));
        this.assertFalse(this.hasSecondaryEligibility(type, person));
        this.assertTrue(this.hasOtherEligibility(type, person));
    }

    protected void assessIfHasSecondaryRanking(String type, Person person) {
        this.assertFalse(this.hasPrimaryEligibility(type, person));
        this.assertTrue(this.hasSecondaryEligibility(type, person));
        this.assertFalse(this.hasOtherEligibility(type, person));
    }

    protected void attachMeansTestWithMtCopayRequired(Person person, BigDecimal gmtThresholdAmount, BigDecimal thresholdA) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName(), new Integer(2004));
        incomeTest.setGmtThresholdAmount(gmtThresholdAmount);
        incomeTest.setThresholdA(thresholdA);
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachMeansTestWithNoLongerRequired(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachMeansTestWithRequired(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_REQUIRED.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachMeansTestWithMtCopayExempt(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachPharmacyCopayTestWithRXCopayExempt(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName(), MeansTestStatus.MT_STATUS_EXEMPT.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachPharmacyCopayTestWithNonExempt(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName(), MeansTestStatus.MT_STATUS_NON_EXEMPT.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachPharmacyCopayTestWithNoLongerApplicable(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName(), MeansTestStatus.MT_STATUS_NP_LONGER_APPLICABLE_RX_COPAY_ONLY.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachLongTermCareTestWithExempt(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST.getName(), MeansTestStatus.MT_STATUS_EXEMPT.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachLongTermCareTestWithNonExempt(Person person) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST.getName(), MeansTestStatus.MT_STATUS_NON_EXEMPT.getName(), new Integer(2004));
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachMeansTestWithGmtCopayRequired(Person person, BigDecimal gmtThresholdAmount, BigDecimal thresholdA) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName(), new Integer(2004));
        incomeTest.setGmtThresholdAmount(gmtThresholdAmount);
        incomeTest.setThresholdA(thresholdA);
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachMeansTestWithHardship(Person person) throws Exception {
        IncomeTest incomeTest = person.getIncomeTest(new Integer(2004));
        if (incomeTest == null) {
            incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName(), new Integer(2004));
            person.setIncomeTest(new Integer(2004), incomeTest);
        }
        Hardship hardship = new Hardship();
        hardship.setEffectiveDate(new Date());
        hardship.setHardshipGranted(Boolean.TRUE);
        incomeTest.setHardship(hardship);
    }

    protected void attachMeansTestWithMtStatusPendingAdjudication(Person person, BigDecimal gmtThresholdAmount, BigDecimal thresholdA) throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName(), new Integer(2004));
        incomeTest.setGmtThresholdAmount(gmtThresholdAmount);
        incomeTest.setThresholdA(thresholdA);
        person.setIncomeTest(new Integer(2004), incomeTest);
    }

    protected void attachServiceConnectionAward(Person person, Integer percent) {
        this.attachServiceConnectionAward(person);
        person.getServiceConnectionAward().setServiceConnectedPercentage(percent);
    }

    protected void attachServiceConnectionAward(Person person) {
        ServiceConnectionAward serviceConnectionAward = person.getServiceConnectionAward();
        if (serviceConnectionAward == null) {
            serviceConnectionAward = new ServiceConnectionAward();
            person.setServiceConnectionAward(serviceConnectionAward);
        }
    }

    protected void attachNoseThroatRadium(Person person) throws Exception {
        NoseThroatRadium noseThroatRadium = this.createNoseThroatRadium(new Date(), VAFacility.CODE_CONNECTICUT_HCS.getName(), NTRVerificationMethod.CODE_MILITARY_RECORD.getName());
        person.addClinicalDetermination((ClinicalDetermination)noseThroatRadium);
    }

    protected void attachVaDisabilityCompensation(Person person) throws Exception {
        MonetaryBenefit monetaryBenefit = this.createMonetaryBenefit(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName());
        this.attachMonetaryBenefitAward(person);
        person.getMonetaryBenefitAward().addMonetaryBenefit(monetaryBenefit);
    }

    protected void attachVaPension(Person person) throws Exception {
        MonetaryBenefit monetaryBenefit = this.createMonetaryBenefit(MonetaryBenefitType.CODE_VA_PENSION.getName());
        this.attachMonetaryBenefitAward(person);
        person.getMonetaryBenefitAward().addMonetaryBenefit(monetaryBenefit);
    }

    protected void attachHousebound(Person person) throws Exception {
        MonetaryBenefit monetaryBenefit = this.createMonetaryBenefit(MonetaryBenefitType.CODE_HOUSEBOUND.getName());
        this.attachMonetaryBenefitAward(person);
        person.getMonetaryBenefitAward().addMonetaryBenefit(monetaryBenefit);
    }

    protected void attachAidAndAttendance(Person person) throws Exception {
        MonetaryBenefit monetaryBenefit = this.createMonetaryBenefit(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName());
        this.attachMonetaryBenefitAward(person);
        person.getMonetaryBenefitAward().addMonetaryBenefit(monetaryBenefit);
    }

    protected void attachMonetaryBenefitAward(Person person) throws Exception {
        MonetaryBenefitAward monetaryBenefitAward = person.getMonetaryBenefitAward();
        if (monetaryBenefitAward == null) {
            monetaryBenefitAward = new MonetaryBenefitAward();
            person.setMonetaryBenefitAward(monetaryBenefitAward);
        }
    }

    protected void attachDischargeDueToDisability(Person person) throws Exception {
        this.attachMilitaryService(person);
        person.getMilitaryService().setDischargeDueToDisability(Boolean.TRUE);
    }

    protected void attachMilitaryRetirementInLieuOfVaCompensation(Person person) throws Exception {
        this.attachMilitaryService(person);
        person.getMilitaryService().setDisabilityRetirementIndicator(Boolean.TRUE);
    }

    protected void attachMilitaryService(Person person) throws Exception {
        MilitaryService militaryService = person.getMilitaryService();
        if (militaryService == null) {
            militaryService = this.createMilitaryService();
            person.setMilitaryService(militaryService);
        }
    }

    protected void attachReceivingMilitaryRetirement(Person person) throws Exception {
        this.attachMilitaryService(person);
        person.getMilitaryService().setDisabilityRetirementIndicator(Boolean.FALSE);
    }

    protected void attachPermanentAndTotal(Person person) {
        this.attachServiceConnectionAward(person);
        person.getServiceConnectionAward().setPermanentAndTotal(Boolean.TRUE);
    }

    protected void attachUnemployable(Person person) {
        this.attachServiceConnectionAward(person);
        person.getServiceConnectionAward().setUnemployable(Boolean.TRUE);
    }

    protected void attachAgentOrangeExposure(Person person) throws Exception {
        person.addSpecialFactor((SpecialFactor)this.createAgentOrange());
    }

    protected void attachEnvironmentalContaminationExposure(Person person) throws Exception {
        person.addSpecialFactor((SpecialFactor)this.createEnvironmentalContaminationExposure());
    }

    protected void attachRadiationExposure(Person person) throws Exception {
        person.addSpecialFactor((SpecialFactor)this.createRadiationExposure());
    }

    protected void attachEmployee(Person person) throws Exception {
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.EMPLOYEE.getName()));
    }

    protected void attachEmployeeAsPrimary(Person person) throws Exception {
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.EMPLOYEE.getName()));
    }

    protected void attachMexicanBorderWar(Person person) throws Exception {
        person.setBirthRecord(this.createBirthRecord(this.createImpreciseDate(1906, 12, 31)));
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.MEXICAN_BORDER_WAR.getName()));
    }

    protected void attachMexicanBorderWarAsPrimary(Person person) throws Exception {
        person.setBirthRecord(this.createBirthRecord(this.createImpreciseDate(1906, 12, 31)));
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.MEXICAN_BORDER_WAR.getName()));
    }

    protected void attachAlliedVeteran(Person person) throws Exception {
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.ALLIED_VETERAN.getName()));
    }

    protected void attachAlliedVeteranAsPrimary(Person person) throws Exception {
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.ALLIED_VETERAN.getName()));
    }

    protected void attachWWI(Person person) throws Exception {
        person.setBirthRecord(this.createBirthRecord(this.createImpreciseDate(1907, 12, 31)));
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.WORLD_WAR_I.getName()));
    }

    protected void attachWWIAsPrimary(Person person) throws Exception {
        person.setBirthRecord(this.createBirthRecord(this.createImpreciseDate(1907, 12, 31)));
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.WORLD_WAR_I.getName()));
    }

    protected void attachTriCare(Person person) throws Exception {
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.TRICARE_CHAMPUS.getName()));
    }

    protected void attachTriCareAsPrimary(Person person) throws Exception {
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.TRICARE_CHAMPUS.getName()));
    }

    protected void attachSharingAgreement(Person person) throws Exception {
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.SHARING_AGREEMENT.getName()));
    }

    protected void attachSharingAgreementAsPrimary(Person person) throws Exception {
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.SHARING_AGREEMENT.getName()));
    }

    protected void attachChampVA(Person person) throws Exception {
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.CHAMPVA.getName()));
    }

    protected void attachChampVAAsPrimary(Person person) throws Exception {
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.CHAMPVA.getName()));
    }

    protected void attachCollateralOfVeteran(Person person) throws Exception {
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.COLLATERAL_OF_VETERAN.getName()));
    }

    protected void attachCollateralOfVeteranAsPrimary(Person person) throws Exception {
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.COLLATERAL_OF_VETERAN.getName()));
    }

    protected void attachOtherFederalAgency(Person person) throws Exception {
        person.addReceivedSecondaryEligibility(this.createReceivedEligibility(EligibilityType.OTHER_FEDERAL_AGENCY.getName()));
    }

    protected void attachOtherFederalAgencyAsPrimary(Person person) throws Exception {
        person.setReceivedPrimaryEligiblity(this.createReceivedEligibility(EligibilityType.OTHER_FEDERAL_AGENCY.getName()));
    }

    protected void attachIneligibleFactor(Person person) throws Exception {
        person.setIneligibilityFactor(this.createIneligibilityFactor());
    }

    protected void attachIneligibleFactorFromSite(Person person) throws Exception {
        person.setIneligibilityFactor(this.createIneligibilityFactor());
        person.getIneligibilityFactor().setFacilityReceived(this.getVaFacility(VAFacility.CODE_NEW_BEDFORD_CBOC.getName()));
    }

    protected IneligibilityFactor createIneligibilityFactor() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1999, 5, 23);
        IneligibilityFactor ineligibilityFactor = new IneligibilityFactor();
        ineligibilityFactor.setIneligibleDate(calendar.getTime());
        ineligibilityFactor.setReason("this person is ineligible");
        ineligibilityFactor.setFacilityReceived(this.getVaFacility(VAFacility.CODE_HEC.getName()));
        return ineligibilityFactor;
    }

    protected void attachCatastrophicDisability(Person person) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1983, 5, 15);
        Date reviewDate = calendar.getTime();
        calendar.set(1983, 7, 25);
        Date dateDecision = calendar.getTime();
        CatastrophicDisability catastrophicDisability = this.createCatastrophicDisability(reviewDate, dateDecision, CDDeterminationMethod.CODE_AUTOMATED_RECORD_REVIEW.getName(), "test reason");
        person.addClinicalDetermination((ClinicalDetermination)catastrophicDisability);
    }

    protected void attachSHAD(Person person) throws Exception {
        person.setShad(new SHAD());
    }

    protected void attachMedicaidFactor(Person person) {
        person.setMedicaidFactor(this.createMedicaidFactor());
    }

    protected MedicaidFactor createMedicaidFactor() {
        Calendar calendar = Calendar.getInstance();
        MedicaidFactor medicaidFactor = new MedicaidFactor();
        medicaidFactor.setEligibleForMedicaid(Boolean.TRUE);
        calendar.set(2004, 3, 23);
        medicaidFactor.setLastUpdateDate(calendar.getTime());
        return medicaidFactor;
    }

    protected MilitarySexualTrauma createMilitarySexualTrauma() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2005, 1, 12);
        Date statusChangeDate = calendar.getTime();
        MilitarySexualTraumaStatus militarySexualTraumaStatus = this.lookupService.getMilitarySexualTraumaStatusByCode("Y");
        MilitarySexualTrauma militarySexualTrauma = new MilitarySexualTrauma();
        militarySexualTrauma.setStatus(militarySexualTraumaStatus);
        militarySexualTrauma.setDeterminationFacility(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
        calendar.set(1986, 3, 24);
        militarySexualTrauma.setStatusChangeDate(statusChangeDate);
        return militarySexualTrauma;
    }

    protected MilitarySexualTrauma createMilitarySexualTrauma(String status) throws Exception {
        MilitarySexualTrauma militarySexualTrauma = this.createMilitarySexualTrauma();
        militarySexualTrauma.setStatus(this.lookupService.getMilitarySexualTraumaStatusByCode(MilitarySexualTraumaStatus.CODE_SCREENED_REPORTS_MST.getName()));
        return militarySexualTrauma;
    }

    protected void attachMilitarySexualTrauma(Person person) throws Exception {
        person.addClinicalDetermination((ClinicalDetermination)this.createMilitarySexualTrauma());
    }

    protected ReceivedEnrollment createReceivedEnrollment() throws Exception {
        Calendar calendar = Calendar.getInstance();
        ReceivedEnrollment receivedEnrollment = new ReceivedEnrollment();
        EnrollmentSource enrollmentSource = this.lookupService.getEnrollmentSourceByCode(EnrollmentSource.CODE_HEC.getName());
        receivedEnrollment.setCalculationSource(enrollmentSource);
        calendar.set(1986, 1, 1);
        receivedEnrollment.setEnrollmentDate(calendar.getTime());
        receivedEnrollment.setEffectiveDate(calendar.getTime());
        calendar.set(1987, 1, 1);
        receivedEnrollment.setEndDate(calendar.getTime());
        EnrollmentPriorityGroup enrollmentPriorityGroup = this.lookupService.getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_1.getName());
        receivedEnrollment.setPriorityGroup(enrollmentPriorityGroup);
        receivedEnrollment.setPrioritySubGroup(null);
        receivedEnrollment.setFacilityReceived(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
        return receivedEnrollment;
    }

    protected void attachReceivedEnrollment(Person person) throws Exception {
        person.setReceivedEnrollment(this.createReceivedEnrollment());
    }

    protected void attachPreferredFacility(Person person) throws Exception {
        person.setMostRecentPreferredFacility(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
    }

    protected CancelDecline createCancelDecline() throws Exception {
        CancelDecline cancelDecline = new CancelDecline();
        cancelDecline.setCancelDeclineIndicator(Boolean.TRUE);
        cancelDecline.setReason(this.lookupService.getCancelDeclineReasonByCode(CancelDeclineReason.CODE_OTHER.getName()));
        cancelDecline.setReasonNotProcessed(this.lookupService.getCancelDeclineNotProcessedReasonByCode(CancelDeclineNotProcessedReason.CODE_PENDING_TELEPHONE_CALLS.getName()));
        cancelDecline.setEffectiveDate(new Date());
        cancelDecline.setRemarks("test cancel decline remarks");
        return cancelDecline;
    }

    protected void attachCancelDecline(Person person) throws Exception {
        person.setCancelDecline(this.createCancelDecline());
    }

    protected IncompetenceRuling createIncompetenceRuling() {
        IncompetenceRuling incompetenceRuling = new IncompetenceRuling();
        ImpreciseDate rd = this.createImpreciseDate(1999, 1, 1);
        incompetenceRuling.setCivilRulingDate(rd);
        return incompetenceRuling;
    }

    protected void attachMilitaryServiceWithConflictExperience(Person person, Date expire) throws Exception {
        this.attachMilitaryService(person);
        person.getMilitaryService().setCombatVeteranEligibilityEndDate(expire);
        person.getMilitaryService().addMilitaryServiceSiteRecord(this.createMilitaryServiceSiteRecord());
    }

    protected MilitaryServiceSiteRecord createMilitaryServiceSiteRecord() throws Exception {
        MilitaryServiceSiteRecord militaryServiceSiteRecord = new MilitaryServiceSiteRecord();
        militaryServiceSiteRecord.setSite(this.getVaFacility(VAFacility.CODE_HEC.getName()));
        ConflictExperience conflictExperience = new ConflictExperience();
        militaryServiceSiteRecord.addConflictExperience(conflictExperience);
        return militaryServiceSiteRecord;
    }

    protected void attachIncompetenceRuling(Person person) {
        person.setIncompetenceRuling(this.createIncompetenceRuling());
    }

    protected void attachRatedIncompetent(Person person) {
        IncompetenceRuling incompetenceRuling = new IncompetenceRuling();
        incompetenceRuling.setIncompetent(Boolean.TRUE);
        incompetenceRuling.setCivilRulingDate(this.createImpreciseDate(1999, 1, 1));
        incompetenceRuling.setVaRulingDate(this.createImpreciseDate(1999, 2, 2));
        person.setIncompetenceRuling(incompetenceRuling);
    }

    protected void attachDeathRecord(Person person) throws Exception {
        person.setDeathRecord(this.createDeathRecord());
    }

    protected void attachDeathRecordFromSite(Person person) throws Exception {
        person.setDeathRecord(this.createDeathRecord());
        person.getDeathRecord().setFacilityReceived(this.getVaFacility(VAFacility.CODE_NEW_BEDFORD_CBOC.getName()));
    }

    protected MilitaryService createMilitaryService() throws Exception {
        MilitaryService militaryService = new MilitaryService();
        militaryService.setCombatVeteranEligibilityEndDate(new Date());
        militaryService.setDischargeDueToDisability(Boolean.TRUE);
        militaryService.setDisabilityRetirementIndicator(Boolean.TRUE);
        MilitaryServiceEpisode militaryServiceEpisode = null;
        ConflictExperience conflictExperience = null;
        ServiceBranch serviceBranch = null;
        DischargeType dischargeType = null;
        ImpreciseDate serviceEntryDate = null;
        ImpreciseDate serviceSeparationDate = null;
        MilitaryServiceSiteRecord militaryServiceSiteRecord = null;
        militaryServiceSiteRecord = new MilitaryServiceSiteRecord();
        MockPersonBuilder.setIdentifier(militaryServiceSiteRecord, MockPersonBuilder.getNextId());
        militaryServiceSiteRecord.setSite(this.getVaFacility(VAFacility.CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER.getName()));
        militaryServiceSiteRecord.setServicePeriod(this.getLookupService().getServicePeriodByCode(ServicePeriod.CODE_SPANISH_AMERICAN.getName()));
        militaryServiceSiteRecord.setFilipinoVeteranProof(this.getLookupService().getFilipinoVeteranProofByCode(FilipinoVeteranProof.CODE_VERIFICATION_OF_NATURALIZATION.getName()));
        militaryService.addMilitaryServiceSiteRecord(militaryServiceSiteRecord);
        serviceBranch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_NAVY.getName());
        dischargeType = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_GENERAL.getName());
        serviceEntryDate = new ImpreciseDate("01/01/1980");
        serviceSeparationDate = new ImpreciseDate("01/01/1985");
        militaryServiceEpisode = this.createMilitaryServiceEpisode("123-45-6789", serviceBranch, dischargeType, serviceEntryDate, serviceSeparationDate);
        militaryServiceSiteRecord.addMilitaryServiceEpisode(militaryServiceEpisode);
        serviceBranch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_MARINE_CORPS.getName());
        dischargeType = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_OTHER_THAN_HONORABLE.getName());
        serviceEntryDate = new ImpreciseDate("01/01/1986");
        serviceSeparationDate = new ImpreciseDate("01/01/1990");
        militaryServiceEpisode = this.createMilitaryServiceEpisode("123-45-6790", serviceBranch, dischargeType, serviceEntryDate, serviceSeparationDate);
        militaryServiceSiteRecord.addMilitaryServiceEpisode(militaryServiceEpisode);
        conflictExperience = this.createConflictExperience(ConflictLocation.CODE_WORLD_WAR_II_PACIFIC.getName());
        militaryServiceSiteRecord.addConflictExperience(conflictExperience);
        conflictExperience = this.createConflictExperience(ConflictLocation.CODE_KOREA.getName());
        militaryServiceSiteRecord.addConflictExperience(conflictExperience);
        militaryServiceSiteRecord = new MilitaryServiceSiteRecord();
        MockPersonBuilder.setIdentifier(militaryServiceSiteRecord, MockPersonBuilder.getNextId());
        militaryServiceSiteRecord.setSite(this.getVaFacility(VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER.getName()));
        militaryServiceSiteRecord.setServicePeriod(this.getLookupService().getServicePeriodByCode(ServicePeriod.CODE_POST_KOREAN.getName()));
        militaryServiceSiteRecord.setFilipinoVeteranProof(this.getLookupService().getFilipinoVeteranProofByCode(FilipinoVeteranProof.CODE_BIRTH_ABROAD_OF_US_CITIZEN.getName()));
        militaryService.addMilitaryServiceSiteRecord(militaryServiceSiteRecord);
        serviceBranch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_COAST_GUARD.getName());
        dischargeType = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_UNDESIRABLE.getName());
        serviceEntryDate = new ImpreciseDate("01/01/1991");
        serviceSeparationDate = new ImpreciseDate("01/01/1992");
        militaryServiceEpisode = this.createMilitaryServiceEpisode("123-45-6791", serviceBranch, dischargeType, serviceEntryDate, serviceSeparationDate);
        militaryServiceSiteRecord.addMilitaryServiceEpisode(militaryServiceEpisode);
        serviceBranch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_OTHER.getName());
        dischargeType = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_BAD_CONDUCT.getName());
        serviceEntryDate = new ImpreciseDate("01/01/1993");
        serviceSeparationDate = new ImpreciseDate("01/01/1999");
        militaryServiceEpisode = this.createMilitaryServiceEpisode("123-45-6792", serviceBranch, dischargeType, serviceEntryDate, serviceSeparationDate);
        militaryServiceSiteRecord.addMilitaryServiceEpisode(militaryServiceEpisode);
        conflictExperience = this.createConflictExperience(ConflictLocation.CODE_PERSIAN_GULF_WAR.getName());
        militaryServiceSiteRecord.addConflictExperience(conflictExperience);
        conflictExperience = this.createConflictExperience(ConflictLocation.CODE_YUGOSLAVIA_CONFLICT.getName());
        militaryServiceSiteRecord.addConflictExperience(conflictExperience);
        militaryServiceSiteRecord = new MilitaryServiceSiteRecord();
        MockPersonBuilder.setIdentifier(militaryServiceSiteRecord, MockPersonBuilder.getNextId());
        militaryServiceSiteRecord.setSite(this.getVaFacility(VAFacility.CODE_HEC.getName()));
        militaryServiceSiteRecord.setServicePeriod(this.getLookupService().getServicePeriodByCode(ServicePeriod.CODE_WORLD_WAR_I.getName()));
        militaryServiceSiteRecord.setFilipinoVeteranProof((FilipinoVeteranProof)this.getLookupService().getByCode(FilipinoVeteranProof.class, "BC"));
        militaryService.addMilitaryServiceSiteRecord(militaryServiceSiteRecord);
        serviceBranch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getName());
        dischargeType = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getName());
        serviceEntryDate = new ImpreciseDate("01/01/1970");
        serviceSeparationDate = new ImpreciseDate("01/01/1975");
        militaryServiceEpisode = this.createMilitaryServiceEpisode("123-45-6793", serviceBranch, dischargeType, serviceEntryDate, serviceSeparationDate);
        militaryServiceSiteRecord.addMilitaryServiceEpisode(militaryServiceEpisode);
        serviceBranch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_AIR_FORCE.getName());
        dischargeType = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_DISHONORABLE.getName());
        serviceEntryDate = new ImpreciseDate("01/01/1976");
        serviceSeparationDate = new ImpreciseDate("01/01/1999");
        militaryServiceEpisode = this.createMilitaryServiceEpisode("123-45-6794", serviceBranch, dischargeType, serviceEntryDate, serviceSeparationDate);
        militaryServiceSiteRecord.addMilitaryServiceEpisode(militaryServiceEpisode);
        conflictExperience = this.createConflictExperience(ConflictLocation.CODE_VIETNAM.getName());
        militaryServiceSiteRecord.addConflictExperience(conflictExperience);
        conflictExperience = this.createConflictExperience(ConflictLocation.CODE_OTHER.getName());
        militaryServiceSiteRecord.addConflictExperience(conflictExperience);
        return militaryService;
    }

    protected MilitaryServiceEpisode createMilitaryServiceEpisode(String serviceNumber, ServiceBranch serviceBranch, DischargeType dischargeType, ImpreciseDate startDate, ImpreciseDate endDate) throws Exception {
        MilitaryServiceEpisode militaryServiceEpisode = new MilitaryServiceEpisode();
        MockPersonBuilder.setIdentifier(militaryServiceEpisode, MockPersonBuilder.getNextId());
        militaryServiceEpisode.setServiceNumber(serviceNumber);
        militaryServiceEpisode.setServiceBranch(serviceBranch);
        militaryServiceEpisode.setDischargeType(dischargeType);
        militaryServiceEpisode.setStartDate(startDate);
        militaryServiceEpisode.setEndDate(endDate);
        return militaryServiceEpisode;
    }

    protected ConflictExperience createConflictExperience(String conflictlocationCode) throws Exception {
        ConflictExperience conflictExperience = new ConflictExperience();
        MockPersonBuilder.setIdentifier(conflictExperience, MockPersonBuilder.getNextId());
        ConflictLocation conflictLocation = this.getLookupService().getConflictByCode(conflictlocationCode);
        if (conflictLocation != null) {
            conflictExperience.setConflictLocation(conflictLocation);
            conflictExperience.setStartDate(this.createImpreciseDate(1998, 7, 1));
            conflictExperience.setEndDate(this.createImpreciseDate(1999, 7, 1));
        }
        return conflictExperience;
    }

    protected void attachAssociation(Person person) throws Exception {
        AssociationType type = this.getLookupService().getAssociationTypeByCode(AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getName());
        NameType nameType = this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName());
        AddressType addressType = this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getName());
        String orgName = "Good Corp";
        Name name = new Name();
        name.setFamilyName("LastName");
        name.setGivenName("FirstName");
        name.setMiddleName("K");
        name.setPrefix("Mrs.");
        name.setType(nameType);
        person.addAssociation(this.createAssociation(type, "Spouse", orgName, name, addressType));
        type = this.getLookupService().getAssociationTypeByCode(AssociationType.CODE_OTHER_NEXT_OF_KIN.getName());
        name = new Name();
        name.setFamilyName("LastName");
        name.setGivenName("FirstName");
        name.setMiddleName("K");
        name.setPrefix("Mrs.");
        name.setType(nameType);
        person.addAssociation(this.createAssociation(type, "Mother", orgName, name, addressType));
        type = this.getLookupService().getAssociationTypeByCode(AssociationType.CODE_EMERGENCY_CONTACT.getName());
        name = new Name();
        name.setFamilyName("LastName");
        name.setGivenName("FirstName");
        name.setMiddleName("K");
        name.setPrefix("Mr.");
        name.setSuffix("Jr.");
        name.setType(nameType);
        person.addAssociation(this.createAssociation(type, "Father", orgName, name, addressType));
        type = this.getLookupService().getAssociationTypeByCode(AssociationType.CODE_POWER_OF_ATTORNEY.getName());
        name = new Name();
        name.setFamilyName("LastName");
        name.setGivenName("FirstName");
        name.setMiddleName("K");
        name.setPrefix("Mr.");
        name.setSuffix("Jr.");
        name.setType(nameType);
        person.addAssociation(this.createAssociation(type, "Son", orgName, name, addressType));
        type = this.getLookupService().getAssociationTypeByCode(AssociationType.CODE_GUARDIAN_VA.getName());
        name = new Name();
        name.setFamilyName("LastName");
        name.setGivenName("FirstName");
        name.setMiddleName("K");
        name.setType(nameType);
        person.addAssociation(this.createAssociation(type, "Nephew", orgName, name, addressType));
        type = this.getLookupService().getAssociationTypeByCode(AssociationType.CODE_GUARDIAN_CIVIL.getName());
        name = new Name();
        name.setFamilyName("LastName");
        name.setGivenName("FirstName");
        name.setMiddleName("K");
        name.setPrefix("Ms.");
        name.setType(nameType);
        person.addAssociation(this.createAssociation(type, "Niece", orgName, name, addressType));
    }

    protected Association createAssociation(AssociationType type, String relationship, String orgName, Name name, AddressType addressType) {
        Association association = new Association();
        MockPersonBuilder.setIdentifier(association, MockPersonBuilder.getNextId());
        association.setOrganizationName(orgName);
        association.setRelationship(relationship);
        association.setType(type);
        association.setRepresentativeName(name);
        Address address = new Address();
        association.setAddress(address);
        address.setType(addressType);
        address.setLine1("1300 EDS Drive, Suite 300");
        address.setLine2("3rd Floor, Quad B");
        address.setLine3("Cube A3N-B13");
        address.setCity("Herndon");
        address.setCounty("Fairfax");
        address.setCountry(Country.CODE_USA.getName());
        address.setState("VA");
        address.setPostalCode("20191-1234");
        address.setZipCode("20191");
        address.setZipPlus4("1234");
        association.setPrimaryPhone("(703)122-2324");
        association.setPrimaryPhoneChangeDate((Date)new java.sql.Date(System.currentTimeMillis()));
        association.setModifiedBy((Principal)new UserPrincipalImpl("Mock Builder"));
        return association;
    }

    protected DeathRecord createDeathRecord() throws Exception {
        DeathRecord deathRecord = new DeathRecord();
        deathRecord.setDeathDate(this.createImpreciseDate(2000, 1, 1));
        deathRecord.setFacilityReceived(this.getVaFacility(VAFacility.CODE_HEC.getName()));
        deathRecord.setDeathReportDate(new Date());
        return deathRecord;
    }

    protected Application createApplication() {
        Application application = new Application();
        application.setApplicationDate(new Date());
        return application;
    }

    protected void attachApplication(Person person) {
        person.setApplication(this.createApplication());
    }

    protected EnrollmentDetermination getEnrollmentDetermination(Person person) {
        return this.getPersonHelperService().getEnrollmentDetermination(person);
    }

    protected VerificationInfo createVerificationInfoFromORFZ11() {
        return new VerificationInfo("0L", "ORFZ11-E", null);
    }

    protected void assessPriorityResult(Person person, String priority) {
    }

    protected void assessPrioritySubGroupResult(Person person, String subPriority) {
    }

    protected void assessEnrollmentStatusResult(Person person, String status) throws Exception {
    }

    protected VAFacility getVaFacility(String stationNumber) throws Exception {
        return this.getLookupService().getVaFacilityByStationNumber(stationNumber);
    }

    protected NoseThroatRadium createNoseThroatRadium(Date determinationDate, String stationNumber, String verificationMethodCode) throws Exception {
        NoseThroatRadium noseThroatRadium = new NoseThroatRadium();
        noseThroatRadium.setDeterminationFacility(this.getVaFacility(stationNumber));
        noseThroatRadium.setVerificationFacility(this.getVaFacility(stationNumber));
        noseThroatRadium.setVerificationDate(determinationDate);
        noseThroatRadium.setVerificationMethod(this.lookupService.getNTRVerificationMethodByCode(NTRVerificationMethod.CODE_QUALIFYING_MILITARY_SERVICE.getName()));
        noseThroatRadium.setDiagnosisVerifiedDate(this.createCalendar(2004, 12, 1).getTime());
        noseThroatRadium.setFromAviatorServiceBefore1955(new Boolean(true));
        noseThroatRadium.setFromSubmarinerServiceBefore1965(new Boolean(true));
        noseThroatRadium.setReceivingTreatment(TriState.TRUE);
        noseThroatRadium.setDiagnosedWithCancer(Boolean.TRUE);
        return noseThroatRadium;
    }

    protected boolean hasOtherEligibility(String type, Person person) {
        boolean contained = false;
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(person);
        Set others = enrollmentDetermination.getOtherEligibilities();
        if (others != null && others.size() > 0) {
            for (Eligibility eligibility : others) {
                if (!type.equals(eligibility.getType().getCode())) continue;
                contained = true;
                break;
            }
        }
        return contained;
    }

    protected boolean hasSecondaryEligibility(String type, Person person) {
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(person);
        boolean contained = false;
        Set secondaries = enrollmentDetermination.getSecondaryEligibilities();
        if (secondaries != null && secondaries.size() > 0) {
            for (Eligibility eligibility : secondaries) {
                if (!type.equals(eligibility.getType().getCode())) continue;
                contained = true;
                break;
            }
        }
        return contained;
    }

    protected boolean hasPrimaryEligibility(String type, Person person) {
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(person);
        boolean contained = false;
        Eligibility primary = enrollmentDetermination.getPrimaryEligibility();
        if (primary != null && type.equals(primary.getType().getCode())) {
            contained = true;
        }
        return contained;
    }

    protected void attachPurpleHeartWithPHStatusPending(Person person) throws Exception {
        PurpleHeart purpleHeart = new PurpleHeart();
        purpleHeart.setPhIndicator(Boolean.TRUE);
        purpleHeart.setStatus(this.lookupService.getDecorationStatusByCode(DecorationStatus.CODE_PENDING.getName()));
        person.addDecoration((Decoration)purpleHeart);
    }

    protected void attachPurpleHeartWithPHRejectRemark(Person person) throws Exception {
        PurpleHeart purpleHeart = new PurpleHeart();
        purpleHeart.setPhIndicator(Boolean.FALSE);
        purpleHeart.setRejectionRemark(this.lookupService.getRejectionRemarkByCode("1"));
        person.addDecoration((Decoration)purpleHeart);
    }

    protected void attachSignature(Person person) throws Exception {
        SignatureImage signature = new SignatureImage();
        signature.setDateIndex(new Date());
        signature.setImageIdNumber("123");
        signature.setUser("John Smith");
        signature.setSiteSubmittingImage(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
        MockPersonBuilder.setPrivateFieldData(signature, "gov.va.med.fw.model.AbstractVersionedEntity", "setModifiedOn", new Date());
        MockPersonBuilder.setIdentifier(signature, MockPersonBuilder.getNextId());
        person.addSignatureImage(signature);
    }

    protected void attachPOW(Person person) throws Exception {
        PrisonerOfWar pow = new PrisonerOfWar();
        person.setPrisonerOfWar(pow);
        POWEpisode powEpisode = new POWEpisode();
        powEpisode.setConfinementLocation(this.lookupService.getPrisonerOfWarLocationByCode(PrisonerOfWarLocation.CODE_KOREA.getName()));
        powEpisode.setCaptureDate(this.createImpreciseDate(1944, 12, 1));
        powEpisode.setReleaseDate(this.createImpreciseDate(1944, 12, 2));
        powEpisode.setDataSource((POWDataSource)this.lookupService.getByCode(POWDataSource.class, POWDataSource.CODE_VAMC.getName()));
        powEpisode.setCampLocation((POWCampLocation)this.lookupService.getByCode(POWCampLocation.class, POWCampLocation.CODE_STALAG1A.getName()));
        powEpisode.setDateEntered(this.createCalendar(2005, 12, 3).getTime());
        pow.addEpisode(powEpisode);
    }

    protected void attachEligibilityVerification(Person person, String source) throws Exception {
        EligibilityVerification eligibilityVerification = new EligibilityVerification();
        eligibilityVerification.setEligibilityStatusDate(null);
        eligibilityVerification.setVerificationMethod("01");
        eligibilityVerification.setVerificationSource(this.lookupService.getEligibilityVerificationSourceByCode(source));
        eligibilityVerification.setVerificationFacility(null);
        person.setEligibilityVerification(eligibilityVerification);
    }

    protected MonetaryBenefit getMonetaryBenefit(String type, Person person) throws Exception {
        MonetaryBenefit mb = null;
        MonetaryBenefitType mbt = null;
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        if (mba != null) {
            mbt = this.lookupService.getMonetaryBenefitTypeByCode(type);
            mb = this.getMonetaryBenefit(mbt, person);
        }
        return mb;
    }

    protected Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1989, 7, 25);
        return calendar.getTime();
    }

    protected FinancialStatement getFinancialStatement(Person person) {
        if (person.getFinancialStatements() != null && !person.getFinancialStatements().isEmpty()) {
            return (FinancialStatement)person.getFinancialStatements().values().iterator().next();
        }
        return null;
    }

    protected MonetaryBenefit getMonetaryBenefit(MonetaryBenefitType monetaryBenefitType, Person person) {
        Set monBens;
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        MonetaryBenefit mb = null;
        Set set = monBens = mba != null ? mba.getMonetaryBenefits() : null;
        if (mba != null && monBens != null && monBens.size() > 0) {
            for (MonetaryBenefit mbTemp : monBens) {
                if (mbTemp == null || mbTemp.getType() == null || !mbTemp.getType().getCode().equals(monetaryBenefitType.getCode())) continue;
                mb = mbTemp;
                break;
            }
        }
        return mb;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public EGTService getEgtService() {
        return this.egtService;
    }

    public void setEgtService(EGTService egtService) {
        this.egtService = egtService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getLookupService() == null || this.getPersonService() == null || this.getPersonHelperService() == null) {
            throw new ServiceConfigurationException("Missing required LookupService/PersonService/PersonHelperService");
        }
    }

    protected EligibilityVerification createEligibilityVerification() throws Exception {
        EligibilityVerification elVer = new EligibilityVerification();
        elVer.setEligibilityStatus(this.lookupService.getEligibilityStatusByCode(EligibilityStatus.CODE_VERIFIED.getName()));
        elVer.setEligibilityStatusDate(new ImpreciseDate(this.createCalendar(2004, 12, 1).getTime()));
        elVer.setVerificationMethod("DD-214");
        elVer.setVerificationSource(this.lookupService.getEligibilityVerificationSourceByCode(EligibilityVerificationSource.CODE_VBA.getName()));
        elVer.setVerificationFacility(this.getVaFacility(VAFacility.CODE_HEC.getName()));
        return elVer;
    }

    public EnrollmentDetermination createEnrollmentDetermination() throws Exception {
        EnrollmentDetermination enrollDet = new EnrollmentDetermination();
        Eligibility eligibility = new Eligibility();
        eligibility.setType(this.lookupService.getEligibilityTypeByCode(EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getName()));
        enrollDet.setPrimaryEligiblity(eligibility);
        Eligibility secEligibility1 = new Eligibility();
        secEligibility1.setType(this.lookupService.getEligibilityTypeByCode(EligibilityType.CHAMPVA.getName()));
        enrollDet.addSecondaryEligibility(secEligibility1);
        Eligibility secEligibility2 = new Eligibility();
        secEligibility2.setType(this.lookupService.getEligibilityTypeByCode(EligibilityType.EMPLOYEE.getName()));
        enrollDet.addSecondaryEligibility(secEligibility2);
        Eligibility otherEligibility1 = new Eligibility();
        otherEligibility1.setFactor(this.lookupService.getEligibilityFactorByCode(EligibilityFactor.CATASTROPHICALLY_DISABLED.getName()));
        enrollDet.addOtherEligibility(otherEligibility1);
        Eligibility otherEligibility2 = new Eligibility();
        otherEligibility2.setFactor(this.lookupService.getEligibilityFactorByCode(EligibilityFactor.MILITARY_SEXUAL_TRAUMA.getName()));
        enrollDet.addOtherEligibility(otherEligibility2);
        Eligibility otherEligibility3 = new Eligibility();
        otherEligibility3.setFactor(this.lookupService.getEligibilityFactorByCode(EligibilityFactor.NOSE_THROAT_RADIUM.getName()));
        enrollDet.addOtherEligibility(otherEligibility3);
        enrollDet.setEnrollmentDate(this.createCalendar(2003, 2, 1).getTime());
        enrollDet.setEndDate(this.createCalendar(2006, 1, 1).getTime());
        enrollDet.setCalculationSource(this.lookupService.getEnrollmentSourceByCode(EnrollmentSource.CODE_VAMC.getName()));
        enrollDet.setPriorityGroup(this.lookupService.getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_1.getName()));
        enrollDet.setEndDate(this.createCalendar(2006, 2, 1).getTime());
        enrollDet.setFacilityReceived(this.lookupService.getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
        EGTSetting egt = this.egtService.getCurrentEGTSetting();
        enrollDet.setEgtSetting(egt);
        enrollDet.setEffectiveDate(this.createCalendar(2004, 6, 1).getTime());
        enrollDet.setEnrollmentStatus(this.lookupService.getEnrollmentStatusByCode(EnrollmentStatus.CODE_VERIFIED.getName()));
        return enrollDet;
    }

    public Address createPrimaryAddress() throws Exception {
        return this.createAddress(AddressType.CODE_PERMANENT_ADDRESS.getName());
    }

    public Address createTemporayCorrespondanceAddress() throws Exception {
        Address address = this.createAddress(AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getName());
        address.setStartDate(new ImpreciseDate(this.createCalendar(2004, 5, 31)));
        address.setEndDate(new ImpreciseDate(this.createCalendar(2004, 8, 31)));
        return address;
    }

    public Address createConfidentialAddress() throws Exception {
        Address address = this.createAddress(AddressType.CODE_CONFIDENTIAL_ADDRESS.getName());
        address.setEndDate(new ImpreciseDate(this.createCalendar(2006, 8, 31)));
        return address;
    }

    public Address createAddress(String addressTypeCode) throws Exception {
        Address address = new Address();
        address.setLine1("123 Chain Bridge Road");
        address.setLine2("Suite 220");
        address.setLine3("Attn: David Henry");
        address.setCity("Herndon");
        address.setZipCode("20171");
        address.setZipPlus4("1234");
        address.setState("VA");
        address.setCountry(Country.CODE_USA.getName());
        address.setCounty("Fairfax");
        address.setBadAddressReason(this.lookupService.getBadAddressReasonByCode(BadAddressReason.CODE_UNDELIVERABLE.getName()));
        address.setType(this.lookupService.getAddressTypeByCode(addressTypeCode));
        address.setStartDate(new ImpreciseDate(this.createCalendar(2005, 6, 1)));
        address.setChangeSource(this.lookupService.getAddressChangeSourceByCode(AddressChangeSource.CODE_VAMC.getName()));
        address.setChangeSite(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
        address.setChangeDate(new Date());
        address.setPhoneNumber("703-713-2848");
        return address;
    }

    public Phone createBusinessPhone(BigDecimal id) throws Exception {
        return this.createPhone(PhoneType.CODE_BUSINESS.getName(), id);
    }

    public Phone createHomePhone(BigDecimal id) throws Exception {
        return this.createPhone(PhoneType.CODE_HOME.getName(), id);
    }

    public Phone createPhone(String phoneTypeCode, BigDecimal id) throws Exception {
        Phone phone = new Phone();
        phone.setPhoneNumber("703-733-7254");
        phone.setType(this.lookupService.getPhoneTypeByCode(phoneTypeCode));
        if (id != null) {
            MockPersonBuilder.setIdentifier(phone, id);
        }
        phone.setSourceOfChange(this.lookupService.getPhoneSourceOfChangeByCode(PhoneSourceOfChange.CODE_VAMC.getName()));
        phone.setSiteOfChange(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
        MockPersonBuilder.setPrivateFieldData(phone, "gov.va.med.fw.model.AbstractVersionedEntity", "setModifiedOn", new Date());
        return phone;
    }

    public Email createPrivateEmail(BigDecimal id) throws Exception {
        return this.createEmail("privatemail@eds.com", EmailType.CODE_PRIVATE.getName(), id);
    }

    public Email createBusinessEmail(BigDecimal id) throws Exception {
        return this.createEmail("business@eds.com", EmailType.CODE_BUSINESS.getName(), id);
    }

    public Email createEmail(String emailAddress, String emailTypeCode, BigDecimal id) throws Exception {
        Email email = new Email();
        email.setAddress(emailAddress == null ? "email@eds.com" : emailAddress);
        email.setType(this.lookupService.getEmailTypeByCode(emailTypeCode));
        if (id != null) {
            MockPersonBuilder.setIdentifier(email, id);
        }
        email.setSourceOfChange(this.lookupService.getEmailSourceOfChangeByCode(EmailSourceOfChange.CODE_VAMC.getName()));
        email.setSiteOfChange(this.getVaFacility(VAFacility.CODE_NEW_BEDFORD_CBOC.getName()));
        MockPersonBuilder.setPrivateFieldData(email, "gov.va.med.fw.model.AbstractVersionedEntity", "setModifiedOn", new Date());
        return email;
    }

    protected void attachPatientVisitSummaries(Person person) throws Exception {
        VAFacility facility = this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName());
        PatientVisitSummary visitSummary = new PatientVisitSummary();
        visitSummary.setLastVisitDate(this.createCalendar(2005, 6, 1).getTime());
        Integer incomeYear = new Integer(2004);
        visitSummary.setIncomeYear(incomeYear);
        visitSummary.setInpatientDays(new Integer(10));
        visitSummary.setOutpatientDays(new Integer(20));
        MockPersonBuilder.setPrivateFieldData(visitSummary, "gov.va.med.esr.common.model.financials.PatientVisitSummary", "setFacilityVisited", facility);
        person.setPatientVisitSummary(incomeYear, facility, visitSummary);
        FeeBasis feeBasis = new FeeBasis();
        feeBasis.setAuthorizationFromDate(new Date());
        feeBasis.setAuthorizationToDate(new Date());
        feeBasis.setReportDate(new Date());
        feeBasis.setReportSite(facility);
        feeBasis.setProgram(this.lookupService.getFeeBasisProgramByCode(FeeBasisProgram.CODE_HOME_HEALTH_SERVICES.getName()));
        feeBasis.setTreatmentType(this.lookupService.getFeeBasisTreatmentTypeByCode(FeeBasisTreatmentType.CODE_SHORT_TERM_FEE_STATUS.getName()));
        person.addFeeBasis(feeBasis);
        facility = this.getVaFacility(VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER.getName());
        visitSummary = new PatientVisitSummary();
        visitSummary.setLastVisitDate(this.createCalendar(2005, 6, 1).getTime());
        visitSummary.setIncomeYear(incomeYear);
        visitSummary.setInpatientDays(new Integer(30));
        visitSummary.setOutpatientDays(new Integer(40));
        MockPersonBuilder.setPrivateFieldData(visitSummary, "gov.va.med.esr.common.model.financials.PatientVisitSummary", "setFacilityVisited", facility);
        person.setPatientVisitSummary(incomeYear, facility, visitSummary);
        feeBasis = new FeeBasis();
        feeBasis.setAuthorizationFromDate(new Date());
        feeBasis.setAuthorizationToDate(new Date());
        feeBasis.setReportDate(new Date());
        feeBasis.setReportSite(facility);
        feeBasis.setProgram(this.lookupService.getFeeBasisProgramByCode(FeeBasisProgram.CODE_HOME_HEALTH_SERVICES.getName()));
        feeBasis.setTreatmentType(this.lookupService.getFeeBasisTreatmentTypeByCode(FeeBasisTreatmentType.CODE_SHORT_TERM_FEE_STATUS.getName()));
        person.addFeeBasis(feeBasis);
    }

    protected void attachInsurance(Person person) throws Exception {
        Set ins = person.getInsurances();
        if (ins.isEmpty()) {
            InsurancePolicy insurance = this.createPrivateInsurance();
            insurance.setReportSite(this.getVaFacility(VAFacility.CODE_HEC.getName()));
            person.addInsurance(insurance);
            insurance = this.createMedicare();
            insurance.setReportSite(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
            person.addInsurance(insurance);
        }
    }

    protected InsurancePolicy createMedicare() throws Exception {
        Medicare ins = new Medicare();
        MockPersonBuilder.setIdentifier(ins, MockPersonBuilder.getNextId());
        ins.setGroupName("A");
        ins.setGroupNumber("987");
        ins.setEnrolledInPartA(Boolean.TRUE);
        ins.setPartAEffectiveDate(new ImpreciseDate(Calendar.getInstance()));
        ins.setEnrolledInPartB(Boolean.FALSE);
        ins.setMedicareClaimNumber("987654321");
        ins.setNameOnMedicareCard("Test Veteran");
        ins.setAddress(this.createAddress(AddressType.CODE_PERMANENT_ADDRESS.getName()));
        ins.setBusinessPhone(this.createBusinessPhone(MockPersonBuilder.getNextId()));
        InsurancePlan plan = new InsurancePlan();
        plan.setPrecertificationRequired(Boolean.TRUE);
        plan.setPlanType(this.lookupService.getInsurancePlanTypeByCode(InsurancePlanType.CODE_MEDICARE_M.getName()));
        ins.setInsurancePlan(plan);
        InsuranceSubscriber sub = new InsuranceSubscriber();
        sub.setName("Test Person B");
        sub.setRelationship(this.lookupService.getInsuredRelationshipByCode(InsuredRelationship.CODE_VETERAN.getName()));
        ins.setSubscriber(sub);
        return ins;
    }

    protected InsurancePolicy createPrivateInsurance() throws Exception {
        PrivateInsurance ins = new PrivateInsurance();
        MockPersonBuilder.setIdentifier(ins, MockPersonBuilder.getNextId());
        ins.setCompanyName("Cigna");
        ins.setGroupName("GroupName123");
        ins.setGroupNumber("123");
        ins.setPolicyNumber("123456789");
        ins.setPolicyEffectiveDate(new ImpreciseDate("01/01/2005"));
        ins.setPolicyExpirationDate(new ImpreciseDate("12/31/2005"));
        ins.setAddress(this.createAddress(AddressType.CODE_PERMANENT_ADDRESS.getName()));
        ins.setBusinessPhone(this.createBusinessPhone(MockPersonBuilder.getNextId()));
        InsurancePlan plan = new InsurancePlan();
        plan.setPrecertificationRequired(Boolean.TRUE);
        plan.setPlanType(this.lookupService.getInsurancePlanTypeByCode(InsurancePlanType.CODE_PPO.getName()));
        ins.setInsurancePlan(plan);
        InsuranceSubscriber sub = new InsuranceSubscriber();
        sub.setName("Test Person A");
        sub.setRelationship(this.lookupService.getInsuredRelationshipByCode(InsuredRelationship.CODE_VETERAN.getName()));
        ins.setSubscriber(sub);
        return ins;
    }

    protected void attachFinancialInfo(Person person, Integer year) throws Exception {
        FinancialStatement fin = person.getFinancialStatement(year);
        if (fin == null) {
            BeneficiaryTravel bf = new BeneficiaryTravel();
            bf.setAmountCertified(new BigDecimal(666));
            bf.setClaimDate(new Date());
            IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST.getName(), MeansTestStatus.MT_STATUS_EXEMPT_LTC_COPAY_EXEMPTION_TEST.getName(), year);
            incomeTest.setSiteConductingTest(this.getVaFacility(VAFacility.CODE_CONNECTICUT_HCS.getName()));
            incomeTest.setEffectiveDate(this.createCalendar(1995, 2, 1).getTime());
            person.setIncomeTest(year, incomeTest);
            Income i = new Income();
            i.setAmount(new BigDecimal(3000));
            FinancialStatement fstmt = new FinancialStatement();
            fstmt.setIsPost2005Format(new Boolean(true));
            MockPersonBuilder.setIdentifier(fstmt, MockPersonBuilder.getNextId());
            fstmt.setContributionToSpouse(new BigDecimal(9988));
            fstmt.setMarriedLastCalendarYear(Boolean.TRUE);
            fstmt.setNumberOfDependentChildren(new Integer(5));
            fstmt.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName()), i);
            fstmt.setDebt(new Debt(new BigDecimal(333)));
            NameType nameType = this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName());
            Name name = new Name();
            name.setFamilyName("LastName");
            name.setGivenName("Spouse");
            name.setMiddleName("V");
            name.setPrefix("Mrs.");
            name.setType(nameType);
            Spouse spouse = new Spouse();
            MockPersonBuilder.setIdentifier(spouse, MockPersonBuilder.getNextId());
            spouse.setName(name);
            spouse.addSsn(this.createSSN("222222222", SSNType.CODE_ACTIVE.getName()));
            spouse.setDob(new ImpreciseDate("01/01/1969"));
            spouse.setRelationship(this.getLookupService().getRelationshipByCode("2"));
            SpouseFinancials sp = new SpouseFinancials();
            MockPersonBuilder.setIdentifier(sp, MockPersonBuilder.getNextId());
            sp.setLivedWithPatient(Boolean.TRUE);
            Income si = new Income();
            si.setAmount(new BigDecimal(2000));
            sp.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName()), si);
            sp.setDebt(new Debt(new BigDecimal(222)));
            sp.setReportedOn(spouse);
            fstmt.addSpouseFinancials(sp);
            NameType nameTypeD = this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName());
            Name depName = new Name();
            depName.setFamilyName("LastName");
            depName.setGivenName("Dependent");
            depName.setMiddleName("P");
            depName.setPrefix("Ms.");
            depName.setType(nameTypeD);
            Dependent dep = new Dependent();
            MockPersonBuilder.setIdentifier(dep, MockPersonBuilder.getNextId());
            dep.setName(depName);
            dep.addSsn(this.createSSN("444444444", SSNType.CODE_ACTIVE.getName()));
            dep.setDob(new ImpreciseDate("01/01/1999"));
            dep.setRelationship(this.getLookupService().getRelationshipByCode("4"));
            DependentFinancials dp = new DependentFinancials();
            MockPersonBuilder.setIdentifier(dp, MockPersonBuilder.getNextId());
            dp.setAttendedSchool(Boolean.FALSE);
            dp.setHasIncome(Boolean.TRUE);
            Income di = new Income();
            di.setAmount(new BigDecimal(1500));
            dp.setDebt(new Debt(new BigDecimal(111)));
            dp.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName()), di);
            dp.setIncomeAvailableToPatient(Boolean.TRUE);
            dp.setLivedWithPatient(Boolean.TRUE);
            dp.setReportedOn(dep);
            fstmt.addDependentFinancials(dp);
            person.setFinancialStatement(year, fstmt);
        }
    }

    public static void setIdentifier(Object obj, BigDecimal id) {
        if (!setIdentifierActive) {
            log.error((Object)("setIdentifier is disabled:" + obj));
            return;
        }
        try {
            Class<?> abstractKeyedEntity = Class.forName("gov.va.med.fw.model.AbstractKeyedEntity");
            Method[] methods = abstractKeyedEntity.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("setIdentifier")) continue;
                Object[] params = new Object[]{id};
                methods[i].setAccessible(true);
                methods[i].invoke(obj, params);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception in setIdentifier", (Throwable)e);
        }
    }

    public static void setPrivateFieldData(Object obj, String className, String methodName, Object data) {
        try {
            Class<?> objectClass = Class.forName(className);
            Method[] methods = objectClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Method:" + methods[i].getName()));
                    Class<?>[] parTypes = methods[i].getParameterTypes();
                    for (int j = 0; j < parTypes.length; ++j) {
                        log.debug((Object)("Parameters: " + parTypes[j].getName()));
                    }
                }
                if (!methods[i].getName().equals(methodName)) continue;
                Object[] params = new Object[]{data};
                methods[i].setAccessible(true);
                methods[i].invoke(obj, params);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception in setPrivateFieldData ", (Throwable)e);
        }
    }

    public static Timestamp createTimestamp(int year, int month, int day) {
        Calendar calender = Calendar.getInstance();
        calender.clear();
        calender.set(1, year);
        calender.set(2, month - 1);
        calender.set(5, day);
        return new Timestamp(calender.getTime().getTime());
    }

    public static Set getChangeEvents(EntityKey entityKey) {
        HashSet<ChangeEvent> changeEvents = new HashSet<ChangeEvent>();
        changeEvents.add(new ChangeEvent(MockPersonBuilder.createTimestamp(2005, 8, 1), entityKey));
        changeEvents.add(new ChangeEvent(MockPersonBuilder.createTimestamp(2005, 6, 1), entityKey));
        changeEvents.add(new ChangeEvent(MockPersonBuilder.createTimestamp(2005, 4, 1), entityKey));
        changeEvents.add(new ChangeEvent(MockPersonBuilder.createTimestamp(2005, 3, 1), entityKey));
        changeEvents.add(new ChangeEvent(MockPersonBuilder.createTimestamp(2005, 1, 1), entityKey));
        return changeEvents;
    }

    private static void enableSetIdentifier() {
        setIdentifierActive = true;
    }

    private static void disableSetIdentifier() {
        setIdentifierActive = false;
    }

    public static synchronized BigDecimal getNextId() {
        identifier = identifier.add(new BigDecimal(1));
        return identifier;
    }

    private void assertTrue(boolean value) {
    }

    private void assertFalse(boolean value) {
    }

    private void assertNull(boolean value) {
    }

    private void assertNotNull(boolean value) {
    }
}

