/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.util;

import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.springframework.web.context.WebApplicationContext;

public class GenericExceptionHandler
extends ExceptionHandler {
    public static final String DEPLOYMENT_TYPE_LOCAL = "local";
    public static final String INCLUDE_STACK_TRACE_MESSAGE_KEY = "ui.error.include.stacktrace";
    public static final String EXCEPTION_STACK_TRACE_KEY = "exceptionStackTrace";
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public ActionForward execute(Exception exception, ExceptionConfig exceptionConfig, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String applicationErrorPath = "error";
        try {
            applicationErrorPath = exceptionConfig.getPath();
            if (StringUtils.isEmpty((String)applicationErrorPath)) {
                applicationErrorPath = "error";
            }
            this.logger.error((Object)("Going to display application error page with URL = " + applicationErrorPath), (Throwable)exception);
            HttpSession session = request.getSession();
            WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext((ServletContext)session.getServletContext());
            boolean stackTraceVisible = (Boolean)ac.getBean(INCLUDE_STACK_TRACE_MESSAGE_KEY);
            if (exception != null && stackTraceVisible) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                String trace = stringWriter.toString();
                if (StringUtils.isNotEmpty((String)trace)) {
                    request.setAttribute(EXCEPTION_STACK_TRACE_KEY, (Object)trace);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error while handling the exception", (Throwable)ex);
        }
        return new ActionForward(mapping.findForward(applicationErrorPath));
    }
}

