/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.infra.TriState;
import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.BenefitType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.EthnicityType;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceActionHelper;
import gov.va.med.fw.util.StringUtils;
import java.awt.Color;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Financials1010EZApplication {
    private static final Logger log = Logger.getLogger(Financials1010EZApplication.class);
    private HashMap fieldMap = new HashMap();
    private Person person = null;
    private MilitaryService militaryService = null;
    private Set insurances;
    private Set privateinsurances;
    private Set medicares;
    private Set dependentFinancials;
    private SpouseFinancials sf = null;
    private FinancialStatement ftmt = null;
    private Integer incomeYear;
    private boolean FinDisclosureFlag = false;
    private Spouse spouse = null;
    private List patientVisitSummaries = null;
    private AcroFields fields;
    private PdfReader reader;
    private PdfStamper stamper;
    private Document additionalInsDocument;
    private Document additionalChildDocument;
    private boolean isAdditionalDocumentInsNeeded = false;
    private boolean isAdditionalDocumentChildNeeded = false;
    private Font font_helve;
    private Font font_courier;
    private Font font_times;
    private String formFileName;
    private String additionalInsFileName;
    private String additionalChildFileName;
    private String finalFileName;
    private String filePath;
    private String templateLocation;
    private InputStream fillablePDF;
    private FileOutputStream outStaticForm;
    private FileOutputStream outAdditionalInsForm;
    private FileOutputStream outAdditionalChildForm;
    private FileOutputStream outCombinedForm;
    private String veteranName = "";
    private String veteranSSN = "";

    public Financials1010EZApplication(Person person, Integer incomeYear, InputStream is, String outputPath) {
        this.person = person;
        this.incomeYear = incomeYear;
        this.filePath = outputPath;
        this.fillablePDF = is;
        this.initializeFieldMap();
        String personId = person.getEntityKey().getKeyValueAsString();
        this.setOutputFiles(personId);
        this.militaryService = person.getMilitaryService();
        this.privateinsurances = person.getPrivateInsurances();
        this.ftmt = person.getFinancialStatement(incomeYear);
        if (this.ftmt == null) {
            this.ftmt = new FinancialStatement();
        }
        this.sf = this.ftmt.getRecentSpouseFinancials();
        this.dependentFinancials = this.ftmt.getDependentFinancials();
        if (this.privateinsurances != null && this.privateinsurances.size() > 1) {
            this.initializeAdditionalInsPDF();
        }
        if (this.dependentFinancials != null && this.dependentFinancials.size() > 1) {
            this.initializeAdditionalChildPDF();
        }
        this.initializePDF();
        this.font_helve = FontFactory.getFont((String)"Helvetica-Bold", (float)8.0f);
        this.font_courier = FontFactory.getFont((String)"Courier", (float)8.0f);
        this.font_times = FontFactory.getFont((String)"Times-Roman", (float)8.0f);
    }

    private void setOutputFiles(String vetId) {
        String currDate = new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime());
        currDate = currDate == null ? "" : currDate.trim();
        String fSeparater = "_";
        String fForm = "file002";
        String fInsurance = "file003";
        String fChild = "file004";
        String fFinal = "file001";
        String fExt = ".pdf";
        this.formFileName = vetId + fSeparater + fForm + fSeparater + currDate + fExt;
        this.additionalInsFileName = vetId + fSeparater + fInsurance + fSeparater + currDate + fExt;
        this.additionalChildFileName = vetId + fSeparater + fChild + fSeparater + currDate + fExt;
        this.finalFileName = vetId + fSeparater + fFinal + fSeparater + currDate + fExt;
    }

    private String getFormFileName() {
        return this.formFileName;
    }

    private String getAdditionalInsuranceFileName() {
        return this.additionalInsFileName;
    }

    private String getAdditionalDependentFileName() {
        return this.additionalChildFileName;
    }

    private String getFinalFileName() {
        return this.finalFileName;
    }

    private String getOutputFilePath() {
        return this.filePath;
    }

    private void initializePDF() {
        try {
            this.reader = new PdfReader(this.fillablePDF);
            if (this.isAdditionalDocumentInsNeeded || this.isAdditionalDocumentChildNeeded) {
                this.outStaticForm = new FileOutputStream(this.getOutputFilePath() + this.getFormFileName());
                this.stamper = new PdfStamper(this.reader, (OutputStream)this.outStaticForm, '\u0000');
            } else {
                this.outCombinedForm = new FileOutputStream(this.getOutputFilePath() + this.getFinalFileName());
                this.stamper = new PdfStamper(this.reader, (OutputStream)this.outCombinedForm, '\u0000');
            }
            this.fields = this.stamper.getAcroFields();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeAdditionalInsPDF() {
        this.isAdditionalDocumentInsNeeded = true;
        try {
            this.additionalInsDocument = new Document(PageSize.A4, 25.0f, 25.0f, 50.0f, 50.0f);
            this.outAdditionalInsForm = new FileOutputStream(this.getOutputFilePath() + this.getAdditionalInsuranceFileName());
            PdfWriter.getInstance((Document)this.additionalInsDocument, (OutputStream)this.outAdditionalInsForm);
            this.additionalInsDocument.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeAdditionalChildPDF() {
        this.isAdditionalDocumentChildNeeded = true;
        try {
            this.additionalChildDocument = new Document(PageSize.A4, 25.0f, 25.0f, 50.0f, 50.0f);
            this.outAdditionalChildForm = new FileOutputStream(this.getOutputFilePath() + this.getAdditionalDependentFileName());
            PdfWriter.getInstance((Document)this.additionalChildDocument, (OutputStream)this.outAdditionalChildForm);
            this.additionalChildDocument.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get1010EZ() throws Exception {
        try {
            this.fillSection1();
            this.fillSection2();
            this.fillSection3();
            this.fillSection4();
            this.fillSection5();
            this.fillSection7();
            this.fillSection8_9_10();
            this.fillSection12();
            this.stamper.setFormFlattening(true);
            this.reader.close();
            this.stamper.close();
            if (this.isAdditionalDocumentInsNeeded) {
                this.additionalInsDocument.close();
                this.outAdditionalInsForm.close();
            }
            if (this.isAdditionalDocumentChildNeeded) {
                this.additionalChildDocument.close();
                this.outAdditionalChildForm.close();
            }
            if (this.isAdditionalDocumentInsNeeded || this.isAdditionalDocumentChildNeeded) {
                this.outStaticForm.close();
            } else {
                this.outCombinedForm.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reader.close();
            try {
                if (this.isAdditionalDocumentInsNeeded) {
                    this.additionalInsDocument.close();
                    this.outAdditionalInsForm.close();
                }
                if (this.isAdditionalDocumentChildNeeded) {
                    this.additionalChildDocument.close();
                    this.outAdditionalChildForm.close();
                }
                if (this.isAdditionalDocumentInsNeeded || this.isAdditionalDocumentChildNeeded) {
                    this.outStaticForm.close();
                } else {
                    this.outCombinedForm.close();
                }
                this.stamper.close();
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
        }
        finally {
            this.reader.close();
            try {
                if (this.isAdditionalDocumentInsNeeded) {
                    this.additionalInsDocument.close();
                    this.outAdditionalInsForm.close();
                }
                if (this.isAdditionalDocumentChildNeeded) {
                    this.additionalChildDocument.close();
                    this.outAdditionalChildForm.close();
                }
                if (this.isAdditionalDocumentInsNeeded || this.isAdditionalDocumentChildNeeded) {
                    this.outStaticForm.close();
                } else {
                    this.outCombinedForm.close();
                }
                this.stamper.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.isAdditionalDocumentInsNeeded || this.isAdditionalDocumentChildNeeded) {
                log.debug((Object)"Concatenating the pdf documents in 1010EZ");
                FileInputStream inStaticForm = null;
                FileInputStream inAdditionalInsForm = null;
                FileInputStream inAdditionalChildForm = null;
                ArrayList<FileInputStream> pdfs = new ArrayList<FileInputStream>();
                File file1 = new File(this.getOutputFilePath() + this.getFormFileName());
                inStaticForm = new FileInputStream(file1);
                pdfs.add(inStaticForm);
                File file2 = null;
                File file3 = null;
                if (this.isAdditionalDocumentInsNeeded) {
                    file2 = new File(this.getOutputFilePath() + this.getAdditionalInsuranceFileName());
                    inAdditionalInsForm = new FileInputStream(file2);
                    pdfs.add(inAdditionalInsForm);
                }
                if (this.isAdditionalDocumentChildNeeded) {
                    file3 = new File(this.getOutputFilePath() + this.getAdditionalDependentFileName());
                    inAdditionalChildForm = new FileInputStream(file3);
                    pdfs.add(inAdditionalChildForm);
                }
                FileOutputStream output = new FileOutputStream(this.getOutputFilePath() + this.getFinalFileName());
                this.concatPDFs(pdfs, output, true);
                ((OutputStream)output).close();
                inStaticForm.close();
                if (inAdditionalInsForm != null) {
                    inAdditionalInsForm.close();
                }
                if (inAdditionalChildForm != null) {
                    inAdditionalChildForm.close();
                }
                if (file1.exists()) {
                    file1.delete();
                }
                if (this.isAdditionalDocumentInsNeeded && file2.exists()) {
                    file2.delete();
                }
                if (this.isAdditionalDocumentChildNeeded && file3.exists()) {
                    file3.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeFieldMap() {
        this.fieldMap.put("Section1:Question1", "Text1");
        this.fieldMap.put("Section1:Question2", "Text2");
        this.fieldMap.put("Section1:Question3", "Text3");
        this.fieldMap.put("Section1:Question4:Male", "Check Box20");
        this.fieldMap.put("Section1:Question4:Female", "Check Box21");
        this.fieldMap.put("Section1:Question5:Yes", "Check Box22");
        this.fieldMap.put("Section1:Question5:No", "Check Box23");
        this.fieldMap.put("Section1:Question6:AlaskaNative", "Check Box24");
        this.fieldMap.put("Section1:Question6:Asian", "Check Box25");
        this.fieldMap.put("Section1:Question6:White", "Check Box26");
        this.fieldMap.put("Section1:Question6:Black", "Check Box27");
        this.fieldMap.put("Section1:Question6:NativeHawaiian", "Check Box28");
        this.fieldMap.put("Section1:Question7", "Text4");
        this.fieldMap.put("Section1:Question8", "Text7");
        this.fieldMap.put("Section1:Question9", "Text5");
        this.fieldMap.put("Section1:Question9A", "Text8");
        this.fieldMap.put("Section1:Question10", "Text6");
        this.fieldMap.put("Section1:Question11", "Text10");
        this.fieldMap.put("Section1:Question11A", "Text11");
        this.fieldMap.put("Section1:Question11B", "Text12");
        this.fieldMap.put("Section1:Question11C", "Text13");
        this.fieldMap.put("Section1:Question11D", "Text14");
        this.fieldMap.put("Section1:Question11E", "Text15");
        this.fieldMap.put("Section1:Question11F", "Text16");
        this.fieldMap.put("Section1:Question11G", "Text17");
        this.fieldMap.put("Section1:Question11H", "Text18");
        this.fieldMap.put("Section1:Question12:HealthServices", "Check Box29");
        this.fieldMap.put("Section1:Question12:NursingHome", "Check Box30");
        this.fieldMap.put("Section1:Question12:Domiciliary", "Check Box31");
        this.fieldMap.put("Section1:Question12:Dental", "Check Box32");
        this.fieldMap.put("Section1:Question13", "Text19");
        this.fieldMap.put("Section1:Question14:Yes", "Check Box33");
        this.fieldMap.put("Section1:Question14:No", "Check Box34");
        this.fieldMap.put("Section1:Question15:Yes", "Check Box35");
        this.fieldMap.put("Section1:Question15:No", "Check Box36");
        this.fieldMap.put("Section1:Question15:Location", "Text22");
        this.fieldMap.put("Section1:Question16:Married", "Check Box37");
        this.fieldMap.put("Section1:Question16:NeverMarried", "Check Box38");
        this.fieldMap.put("Section1:Question16:Separated", "Check Box39");
        this.fieldMap.put("Section1:Question16:Widowed", "Check Box40");
        this.fieldMap.put("Section1:Question16:Divorced", "Check Box41");
        this.fieldMap.put("Section1:Question16:Unknown", "Check Box42");
        this.fieldMap.put("Section1:Question17", "Text45");
        this.fieldMap.put("Section1:Question17A", "Text46");
        this.fieldMap.put("Section1:Question17B", "Text47");
        this.fieldMap.put("Section1:Question18", "Text50");
        this.fieldMap.put("Section1:Question18A", "Text48");
        this.fieldMap.put("Section1:Question18B", "Text49");
        this.fieldMap.put("Section1:Question19:EmergencyContact", "Check Box43");
        this.fieldMap.put("Section1:Question19:NextOfKin", "Check Box44");
        this.fieldMap.put("Section2:Question1:Yes", "Check Box61");
        this.fieldMap.put("Section2:Question1:No", "Check Box62");
        this.fieldMap.put("Section2:Question2", "Text53");
        this.fieldMap.put("Section2:Question3", "Text54");
        this.fieldMap.put("Section2:Question4", "Text55");
        this.fieldMap.put("Section2:Question5", "Text56");
        this.fieldMap.put("Section2:Question6:Yes", "Check Box63");
        this.fieldMap.put("Section2:Question6:No", "Check Box64");
        this.fieldMap.put("Section2:Question7:Yes", "Check Box65");
        this.fieldMap.put("Section2:Question7:No", "Check Box66");
        this.fieldMap.put("Section2:Question7A", "Text57");
        this.fieldMap.put("Section2:Question8:Yes", "Check Box68");
        this.fieldMap.put("Section2:Question8:No", "Check Box67");
        this.fieldMap.put("Section2:Question8A", "Text58");
        this.fieldMap.put("Section2:Question9", "Text60");
        this.fieldMap.put("Section2:Question10", "Text59");
        this.fieldMap.put("Section2:Question11:Yes", "Check Box69");
        this.fieldMap.put("Section2:Question11:No", "Check Box70");
        this.fieldMap.put("Section2:Question12:Yes", "Check Box71");
        this.fieldMap.put("Section2:Question12:No", "Check Box72");
        this.fieldMap.put("Section3:Question1:FullTime", "Check Box73");
        this.fieldMap.put("Section3:Question1:NotEmployed", "Check Box74");
        this.fieldMap.put("Section3:Question1:Retired", "Check Box75");
        this.fieldMap.put("Section3:Question1:PartTime", "Check Box76");
        this.fieldMap.put("Section3:Question1:RetirementDate", "Text9");
        this.fieldMap.put("Section3:Question1A", "Text81");
        this.fieldMap.put("Section3:Question2:FullTime", "Check Box77");
        this.fieldMap.put("Section3:Question2:NotEmployed", "Check Box78");
        this.fieldMap.put("Section3:Question2:Retired", "Check Box80");
        this.fieldMap.put("Section3:Question2:PartTime", "Check Box79");
        this.fieldMap.put("Section3:Question2:RetirementDate", "Text20");
        this.fieldMap.put("Section3:Question2A", "Text82");
        this.fieldMap.put("Section4:Question1", "Text83");
        this.fieldMap.put("Section4:Question1A", "Text84");
        this.fieldMap.put("Section4:Question1B", "Text85");
        this.fieldMap.put("Section4:Question1C", "Text86");
        this.fieldMap.put("Section4:Question1D", "Text87");
        this.fieldMap.put("Section4:Question2A:Yes", "Check Box88");
        this.fieldMap.put("Section4:Question2A:No", "Check Box97");
        this.fieldMap.put("Section4:Question2B:Yes", "Check Box89");
        this.fieldMap.put("Section4:Question2B:No", "Check Box96");
        this.fieldMap.put("Section4:Question2C:Yes", "Check Box90");
        this.fieldMap.put("Section4:Question2C:No", "Check Box110");
        this.fieldMap.put("Section4:Question2C1", "Text21");
        this.fieldMap.put("Section4:Question2D:Yes", "Check Box91");
        this.fieldMap.put("Section4:Question2D:No", "Check Box94");
        this.fieldMap.put("Section4:Question2E:Yes", "Check Box92");
        this.fieldMap.put("Section4:Question2E:No", "Check Box93");
        this.fieldMap.put("Section4:Question2E1:Yes", "Check Box98");
        this.fieldMap.put("Section4:Question2E1:No", "Check Box99");
        this.fieldMap.put("Section4:Question2F:Yes", "Check Box100");
        this.fieldMap.put("Section4:Question2F:No", "Check Box101");
        this.fieldMap.put("Section4:Question2G:Yes", "Check Box102");
        this.fieldMap.put("Section4:Question2G:No", "Check Box103");
        this.fieldMap.put("Section4:Question2H:Yes", "Check Box109");
        this.fieldMap.put("Section4:Question2H:No", "Check Box104");
        this.fieldMap.put("Section4:Question2I:Yes", "Check Box108");
        this.fieldMap.put("Section4:Question2I:No", "Check Box105");
        this.fieldMap.put("Section4:Question2J:Yes", "Check Box107");
        this.fieldMap.put("Section4:Question2J:No", "Check Box106");
        this.fieldMap.put("Section5:No", "Check Box113");
        this.fieldMap.put("Section5:Yes", "Check Box114");
        this.fieldMap.put("Section7:Question1", "Text115");
        this.fieldMap.put("Section7:Question1A", "Text117");
        this.fieldMap.put("Section7:Question1B", "Text118");
        this.fieldMap.put("Section7:Question1C", "Text123");
        this.fieldMap.put("Section7:Question1D", "Text122");
        this.fieldMap.put("Section7:Question1E", "Text124");
        this.fieldMap.put("Section7:Question2", "Text116");
        this.fieldMap.put("Section7:Question2A:Son", "Check Box45");
        this.fieldMap.put("Section7:Question2A:Daughter", "Check Box46");
        this.fieldMap.put("Section7:Question2A:Stepson", "Check Box47");
        this.fieldMap.put("Section7:Question2A:Stepdaughter", "Check Box48");
        this.fieldMap.put("Section7:Question2B", "Text119");
        this.fieldMap.put("Section7:Question2C", "Text120");
        this.fieldMap.put("Section7:Question2D", "Text121");
        this.fieldMap.put("Section7:Question2E:Yes", "Check Box49");
        this.fieldMap.put("Section7:Question2E:No", "Check Box50");
        this.fieldMap.put("Section7:Question2F:Yes", "Check Box51");
        this.fieldMap.put("Section7:Question2F:No", "Check Box52");
        this.fieldMap.put("Section7:Question2G", "Text61");
        this.fieldMap.put("Section7:Question3:Spouse", "Text125");
        this.fieldMap.put("Section7:Question3:Child", "Text126");
        this.fieldMap.put("Section7:Question3:Yes", "Check Box53");
        this.fieldMap.put("Section8:Question1:Veteran", "Text127");
        this.fieldMap.put("Section8:Question1:Spouse", "Text128");
        this.fieldMap.put("Section8:Question1:Child", "Text129");
        this.fieldMap.put("Section8:Question2:Veteran", "Text132");
        this.fieldMap.put("Section8:Question2:Spouse", "Text131");
        this.fieldMap.put("Section8:Question2:Child", "Text130");
        this.fieldMap.put("Section8:Question3:Veteran", "Text133");
        this.fieldMap.put("Section8:Question3:Spouse", "Text134");
        this.fieldMap.put("Section8:Question3:Child", "Text135");
        this.fieldMap.put("Section9:Question1", "Text136");
        this.fieldMap.put("Section9:Question2", "Text137");
        this.fieldMap.put("Section9:Question3", "Text138");
        this.fieldMap.put("Section10:Question1:Veteran", "Text139");
        this.fieldMap.put("Section10:Question1:Spouse", "Text140");
        this.fieldMap.put("Section10:Question1:Child", "Text141");
        this.fieldMap.put("Section10:Question2:Veteran", "Text144");
        this.fieldMap.put("Section10:Question2:Spouse", "Text143");
        this.fieldMap.put("Section10:Question2:Child", "Text142");
        this.fieldMap.put("Section10:Question3:Veteran", "Text145");
        this.fieldMap.put("Section10:Question3:Spouse", "Text146");
        this.fieldMap.put("Section10:Question3:Child", "Text147");
        this.fieldMap.put("Section12:Date", "Text148");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatPDFs(List streamOfPDFFiles, OutputStream outputStream, boolean paginate) {
        Document document = new Document();
        try {
            List pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                totalPages += pdfReader.getNumberOfPages();
            }
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            BaseFont bf = BaseFont.createFont((String)"Courier", (String)"Cp1252", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    ++currentPageNumber;
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    cb.beginText();
                    cb.setFontAndSize(bf, 10.0f);
                    cb.showTextAligned(0, "" + currentPageNumber + " of " + totalPages, 520.0f, 5.0f, 0.0f);
                    cb.endText();
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void fillSection1() throws DocumentException, IOException {
        BenefitType benefitType;
        Email vemail;
        Phone pagephone;
        Phone homephone;
        SSN officialSSN;
        Set raceset;
        EthnicityType ethnicitytype;
        Ethnicity ethnicity;
        Name legalName = null;
        Name aliasName = null;
        Set names = this.person.getNames();
        aliasName = Name.getNameOfType((Set)names, (String)NameType.ALIAS_NAME.getName());
        legalName = Name.getNameOfType((Set)names, (String)NameType.LEGAL_NAME.getName());
        String p_legalname = this.getLastFirstMiddleByComma(legalName);
        String p_aliasname = aliasName != null ? aliasName.getFormattedName() : "";
        this.veteranName = p_legalname;
        this.fields.setField((String)this.fieldMap.get("Section1:Question1"), p_legalname);
        this.fields.setField((String)this.fieldMap.get("Section1:Question2"), p_aliasname);
        this.fields.setField((String)this.fieldMap.get("Section1:Question3"), this.person.getMothersMaidenName());
        if (this.person.getGender() != null) {
            if (Gender.MALE.getCode().equalsIgnoreCase(this.person.getGender().getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question4:Male"), "Yes");
            } else if (Gender.FEMALE.getCode().equalsIgnoreCase(this.person.getGender().getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question4:Female"), "Yes");
            }
        }
        if ((ethnicity = this.person.getEthnicity()) != null && ethnicity.getEthnicityType() != null && (ethnicitytype = ethnicity.getEthnicityType()) != null) {
            if (EthnicityType.CODE_HISPANIC.getCode().equals(ethnicitytype.getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question5:Yes"), "Yes");
            } else if (EthnicityType.CODE_NOT_HISPANIC.getCode().equals(ethnicitytype.getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question5:No"), "Yes");
            }
        }
        if ((raceset = this.person.getRaces()) != null) {
            for (Race race : raceset) {
                RaceType raceType = race.getRaceType();
                if (raceType == null) continue;
                if (RaceType.CODE_AMERICAN_INDIAN_ALASKA.getCode().equals(raceType.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section1:Question6:AlaskaNative"), "Yes");
                    continue;
                }
                if (RaceType.CODE_ASIAN.getCode().equals(raceType.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section1:Question6:Asian"), "Yes");
                    continue;
                }
                if (RaceType.CODE_BLACK_AFRICAN.getCode().equals(raceType.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section1:Question6:Black"), "Yes");
                    continue;
                }
                if (RaceType.CODE_WHITE.getCode().equals(raceType.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section1:Question6:White"), "Yes");
                    continue;
                }
                if (!RaceType.CODE_HAWAIIAN_PACIFIC.getCode().equals(raceType.getCode())) continue;
                this.fields.setField((String)this.fieldMap.get("Section1:Question6:NativeHawaiian"), "Yes");
            }
        }
        this.veteranSSN = (officialSSN = this.person.getOfficialSsn()) != null ? JspUtils.displaySSN((String)officialSSN.getSsnText()) : "";
        this.fields.setField((String)this.fieldMap.get("Section1:Question7"), officialSSN != null ? JspUtils.displaySSN((String)officialSSN.getSsnText()) : "");
        ImpreciseDate birthdate = null;
        if (this.person.getBirthRecord() != null) {
            birthdate = this.person.getBirthRecord().getBirthDate();
        }
        this.fields.setField((String)this.fieldMap.get("Section1:Question8"), this.person.getClaimFolderNumber());
        this.fields.setField((String)this.fieldMap.get("Section1:Question9"), DateUtils.format((ImpreciseDate)birthdate, null));
        this.fields.setField((String)this.fieldMap.get("Section1:Question9A"), this.person.getBirthRecord() != null ? this.getBirthPlace(this.person.getBirthRecord().getCity(), this.person.getBirthRecord().getState()) : "");
        this.fields.setField((String)this.fieldMap.get("Section1:Question10"), this.person.getReligion() != null ? this.person.getReligion().getName() : "");
        Address permAddress = this.person.getPermanentAddress();
        if (permAddress != null) {
            String stateProvince = null;
            String zipPostalCode = null;
            if (Country.isUSAddress((String)permAddress.getCountry())) {
                stateProvince = permAddress.getState();
                zipPostalCode = permAddress.getZipCode();
                if (StringUtils.isNotEmpty((String)zipPostalCode) && StringUtils.isNotEmpty((String)permAddress.getZipPlus4())) {
                    zipPostalCode = zipPostalCode + "-" + permAddress.getZipPlus4();
                }
            } else {
                stateProvince = permAddress.getProvince();
                zipPostalCode = permAddress.getPostalCode();
            }
            StringBuffer resultBuffer = new StringBuffer();
            permAddress.appendAddressPieceOnNewLine(resultBuffer, permAddress.getLine1());
            permAddress.appendAddressPieceOnNewLine(resultBuffer, permAddress.getLine2());
            permAddress.appendAddressPieceOnNewLine(resultBuffer, permAddress.getLine3());
            this.fields.setField((String)this.fieldMap.get("Section1:Question11"), resultBuffer.toString());
            this.fields.setField((String)this.fieldMap.get("Section1:Question11A"), permAddress.getCity());
            this.fields.setField((String)this.fieldMap.get("Section1:Question11B"), stateProvince);
            this.fields.setField((String)this.fieldMap.get("Section1:Question11C"), zipPostalCode);
            this.fields.setField((String)this.fieldMap.get("Section1:Question11D"), permAddress.getCounty());
        }
        if ((homephone = this.person.getHomePhone()) != null) {
            this.fields.setField((String)this.fieldMap.get("Section1:Question11E"), homephone.getFormattedPhone());
        }
        ArrayList emails = new ArrayList(this.person.getEmails());
        String cellphonenumber = "";
        String pagephonenumber = "";
        Phone cellphone = Phone.getPhoneOfType((Set)this.person.getPhones(), (String)PhoneType.CODE_MOBILE.getCode());
        if (cellphone != null) {
            cellphonenumber = cellphone.getFormattedPhone();
        }
        if ((pagephone = Phone.getPhoneOfType((Set)this.person.getPhones(), (String)PhoneType.CODE_PAGER.getCode())) != null) {
            pagephonenumber = pagephone.getFormattedPhone();
        }
        String emailaddress = "";
        Iterator iterator = emails.iterator();
        while (iterator.hasNext() && ((emailaddress = (vemail = (Email)iterator.next()).getAddress()) == null || !StringUtils.isNotEmpty((String)emailaddress))) {
        }
        this.fields.setField((String)this.fieldMap.get("Section1:Question11G"), cellphonenumber);
        this.fields.setField((String)this.fieldMap.get("Section1:Question11H"), pagephonenumber);
        this.fields.setField((String)this.fieldMap.get("Section1:Question11F"), emailaddress);
        this.fields.setField((String)this.fieldMap.get("Section1:Question13"), this.person.getMostRecentPreferredFacility() != null ? this.person.getMostRecentPreferredFacility().getFacilityName() : "");
        Application application = this.person.getApplication();
        if (application != null && (benefitType = application.getBenefitType()) != null) {
            if (BenefitType.CODE_HEATH_SERVICES.getCode().equals(benefitType.getCode()) || BenefitType.CODE_ENROLLMENT.getCode().equals(benefitType.getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question12:HealthServices"), "Yes");
            } else if (BenefitType.CODE_DENTAL.getCode().equals(benefitType.getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question12:Dental"), "Yes");
            } else if (BenefitType.CODE_DOMICILIARY.getCode().equals(benefitType.getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question12:Domiciliary"), "Yes");
            } else if (BenefitType.CODE_NURSING_HOME.getCode().equals(benefitType.getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question12:NursingHome"), "Yes");
            }
        }
        this.patientVisitSummaries = this.getPatientVisitSummaries();
        if (this.patientVisitSummaries != null && this.patientVisitSummaries.size() > 0) {
            PatientVisitSummary patientVisitSummary = PatientVisitSummary.getLastestVisitedSummary((Collection)this.patientVisitSummaries);
            this.fields.setField((String)this.fieldMap.get("Section1:Question15:Yes"), "Yes");
            this.fields.setField((String)this.fieldMap.get("Section1:Question15:Location"), patientVisitSummary != null && patientVisitSummary.getFacilityVisited() != null ? patientVisitSummary.getFacilityVisited().getName() : "");
        } else {
            this.fields.setField((String)this.fieldMap.get("Section1:Question15:No"), "Yes");
        }
        MaritalStatus mstatus = this.person.getMaritalStatus();
        if (mstatus != null) {
            if (mstatus.getName().equalsIgnoreCase("MARRIED")) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question16:Married"), "Yes");
            } else if (mstatus.getName().equalsIgnoreCase("NEVER MARRIED")) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question16:NeverMarried"), "Yes");
            } else if (mstatus.getName().equalsIgnoreCase("SEPARATED")) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question16:Separated"), "Yes");
            } else if (mstatus.getName().toUpperCase().indexOf("WIDOW") >= 0) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question16:Widowed"), "Yes");
            } else if (mstatus.getName().equalsIgnoreCase("UNKNOWN")) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question16:Unknown"), "Yes");
            } else if (mstatus.getName().equalsIgnoreCase("DIVORCED")) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question16:Divorced"), "Yes");
            }
        }
        ArrayList associations = new ArrayList(this.person.getAssociations());
        Collections.sort(associations);
        Association primary_next_of_kin = Association.getAssociationOfType((Set)this.person.getAssociations(), (String)AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode());
        Association emergency_contact = Association.getAssociationOfType((Set)this.person.getAssociations(), (String)AssociationType.CODE_EMERGENCY_CONTACT.getCode());
        if (primary_next_of_kin != null) {
            Address p_address = primary_next_of_kin.getAddress();
            String a_addr = p_address != null ? p_address.getFormattedAddress() : "";
            String a_role = primary_next_of_kin.getRelationship();
            String a_name = primary_next_of_kin.getRepresentativeName() != null ? primary_next_of_kin.getRepresentativeName().getFormattedName() : "";
            String a_h_phone = Phone.getFormattedPhone((String)primary_next_of_kin.getPrimaryPhone());
            String a_w_phone = Phone.getFormattedPhone((String)primary_next_of_kin.getAlternatePhone());
            this.fields.setField((String)this.fieldMap.get("Section1:Question17"), a_name + "\n" + a_addr + "\n" + a_role);
            this.fields.setField((String)this.fieldMap.get("Section1:Question17A"), a_h_phone);
            this.fields.setField((String)this.fieldMap.get("Section1:Question17B"), a_w_phone);
        }
        if (emergency_contact != null) {
            Address e_address = emergency_contact.getAddress();
            String e_addr = e_address != null ? e_address.getFormattedAddress() : "";
            String e_role = emergency_contact.getRelationship();
            String e_name = emergency_contact.getRepresentativeName() != null ? emergency_contact.getRepresentativeName().getFormattedName() : "";
            String e_h_phone = Phone.getFormattedPhone((String)emergency_contact.getPrimaryPhone());
            String e_w_phone = Phone.getFormattedPhone((String)emergency_contact.getAlternatePhone());
            this.fields.setField((String)this.fieldMap.get("Section1:Question18"), e_name + "\n" + e_addr + "\n" + e_role);
            this.fields.setField((String)this.fieldMap.get("Section1:Question18A"), e_h_phone);
            this.fields.setField((String)this.fieldMap.get("Section1:Question18B"), e_w_phone);
        }
        if (this.person.getAppointmentRequestResponse() != null) {
            if (this.person.getAppointmentRequestResponse().booleanValue()) {
                this.fields.setField((String)this.fieldMap.get("Section1:Question14:Yes"), "Yes");
            } else {
                this.fields.setField((String)this.fieldMap.get("Section1:Question14:No"), "Yes");
            }
        }
    }

    private void fillSection2() throws DocumentException, IOException {
        this.insurances = this.person.getInsurances();
        this.medicares = this.person.getMedicareInsurances();
        MedicaidFactor medicaidfactor = this.person.getMedicaidFactor();
        if (medicaidfactor != null) {
            if (Boolean.TRUE.equals(medicaidfactor.getEligibleForMedicaid())) {
                this.fields.setField((String)this.fieldMap.get("Section2:Question6:Yes"), "Yes");
            } else if (Boolean.FALSE.equals(medicaidfactor.getEligibleForMedicaid())) {
                this.fields.setField((String)this.fieldMap.get("Section2:Question6:No"), "Yes");
            }
        }
        if (this.insurances != null && this.insurances.size() != 0) {
            this.fields.setField((String)this.fieldMap.get("Section2:Question1:Yes"), "Yes");
        } else {
            this.fields.setField((String)this.fieldMap.get("Section2:Question1:No"), "Yes");
        }
        List sortpinsr = this.sortPrivateInsurance(this.privateinsurances);
        int ins_cnt = 0;
        if (sortpinsr != null && sortpinsr.size() != 0) {
            boolean isFirst = true;
            boolean addFirst = true;
            for (PrivateInsurance insurance : sortpinsr) {
                PdfPCell cell;
                ++ins_cnt;
                if (isFirst) {
                    this.fields.setField((String)this.fieldMap.get("Section2:Question2"), this.getInsuranceCompanyAddrPhone((InsurancePolicy)insurance));
                    this.fields.setField((String)this.fieldMap.get("Section2:Question3"), insurance.getSubscriber() != null ? insurance.getSubscriber().getName() : "");
                    this.fields.setField((String)this.fieldMap.get("Section2:Question4"), insurance.getPolicyNumber());
                    this.fields.setField((String)this.fieldMap.get("Section2:Question5"), insurance.getGroupNumber());
                    isFirst = false;
                    continue;
                }
                PdfPTable table = new PdfPTable(3);
                table.setKeepTogether(true);
                table.setWidthPercentage(100.0f);
                float[] widths = new float[]{45.0f, 30.0f, 25.0f};
                table.setWidths(widths);
                if (addFirst) {
                    cell = new PdfPCell((Phrase)new Paragraph("APPLICATION FOR HEALTH BENEFITS, Continued", FontFactory.getFont((String)"Helvetica", (float)11.0f, (int)1, (Color)Color.BLACK)));
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                    cell.setHorizontalAlignment(0);
                    table.addCell(new Phrase("VETERAN'S NAME  (Last, First, Middle)\n\n" + this.veteranName, this.font_times));
                    table.addCell(new Phrase("SOCIAL SECURITY NUMBER\n\n" + this.veteranSSN, this.font_times));
                    addFirst = false;
                }
                cell = new PdfPCell((Phrase)new Paragraph("SECTION II - INSURANCE INFORMATION (Continuation #" + ins_cnt + ")", FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1, (Color)Color.BLACK)));
                cell.setColspan(3);
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(Color.lightGray);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("2.HEALTH INSURANCE COMPANY NAME,ADDRESS AND TELEPHONE NUMBER\n" + this.getInsuranceCompanyAddrPhone((InsurancePolicy)insurance), this.font_courier));
                cell.setColspan(3);
                cell.setHorizontalAlignment(0);
                table.addCell(cell);
                String policyholder = insurance.getSubscriber() != null ? insurance.getSubscriber().getName() : "";
                table.addCell(new Phrase("3.NAME OF POLICY HOLDER\n" + policyholder, this.font_courier));
                table.addCell(new Phrase("4.POLICY NUMBER\n" + insurance.getPolicyNumber(), this.font_courier));
                table.addCell(new Phrase("5.GROUP CODE\n" + insurance.getGroupNumber(), this.font_courier));
                this.additionalInsDocument.add((Element)table);
            }
        }
        if (this.medicares != null && this.medicares.size() != 0) {
            Medicare medicare2 = null;
            Medicare LatestMedicareA = null;
            Medicare LatestMedicareB = null;
            for (Medicare medicare2 : this.medicares) {
                if (Boolean.TRUE.equals(medicare2.isEnrolledInPartB())) {
                    if (LatestMedicareB == null) {
                        LatestMedicareB = medicare2;
                        continue;
                    }
                    if (!LatestMedicareB.getModifiedOn().before(medicare2.getModifiedOn())) continue;
                    LatestMedicareB = medicare2;
                    continue;
                }
                if (!Boolean.TRUE.equals(medicare2.isEnrolledInPartA())) continue;
                if (LatestMedicareA == null) {
                    LatestMedicareA = medicare2;
                    continue;
                }
                if (!LatestMedicareA.getModifiedOn().before(medicare2.getModifiedOn())) continue;
                LatestMedicareA = medicare2;
            }
            if (LatestMedicareB != null) {
                this.fields.setField((String)this.fieldMap.get("Section2:Question8:Yes"), "Yes");
                this.fields.setField((String)this.fieldMap.get("Section2:Question8A"), DateUtils.format((ImpreciseDate)LatestMedicareB.getPartBEffectiveDate(), null));
            } else {
                this.fields.setField((String)this.fieldMap.get("Section2:Question8:No"), "Yes");
            }
            if (LatestMedicareA != null) {
                this.fields.setField((String)this.fieldMap.get("Section2:Question7:Yes"), "Yes");
                this.fields.setField((String)this.fieldMap.get("Section2:Question7A"), DateUtils.format((ImpreciseDate)LatestMedicareA.getPartAEffectiveDate(), null));
                this.fields.setField((String)this.fieldMap.get("Section2:Question9"), LatestMedicareA.getNameOnMedicareCard());
                this.fields.setField((String)this.fieldMap.get("Section2:Question10"), LatestMedicareA.getMedicareClaimNumber());
            } else {
                this.fields.setField((String)this.fieldMap.get("Section2:Question7:No"), "Yes");
            }
        }
    }

    private void fillSection3() throws DocumentException, IOException {
        Employment vetEmp = this.person.getEmployment();
        if (vetEmp != null) {
            ImpreciseDate retiredate = vetEmp.getRetirementDate();
            EmploymentStatus employmentstatus = vetEmp.getEmploymentStatus();
            if (employmentstatus != null) {
                if (EmploymentStatus.CODE_FULL_TIME.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1:FullTime"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1A"), this.getEmployerCompanyAddrPhone(vetEmp));
                } else if (EmploymentStatus.CODE_ACTIVE_MILITARYSERVICE.getCode().equals(employmentstatus.getCode()) || EmploymentStatus.CODE_SELF_EMPLOYED.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1:FullTime"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1A"), this.getEmployerCompanyAddrPhone(vetEmp));
                } else if (EmploymentStatus.CODE_PART_TIME.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1:PartTime"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1A"), this.getEmployerCompanyAddrPhone(vetEmp));
                } else if (EmploymentStatus.CODE_NOT_EMPLOYED.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1:NotEmployed"), "Yes");
                } else if (EmploymentStatus.CODE_RETIRED.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1:Retired"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1:RetirementDate"), DateUtils.format((ImpreciseDate)retiredate, null));
                    this.fields.setField((String)this.fieldMap.get("Section3:Question1A"), this.getEmployerCompanyAddrPhone(vetEmp));
                }
            }
        }
        if (this.sf != null) {
            this.spouse = this.sf.getReportedOn();
        }
        if (this.spouse != null && this.spouse.getEmployment() != null) {
            Employment spEmp = this.spouse.getEmployment();
            ImpreciseDate retiredate = spEmp.getRetirementDate();
            EmploymentStatus employmentstatus = spEmp.getEmploymentStatus();
            if (employmentstatus != null) {
                if (EmploymentStatus.CODE_FULL_TIME.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2:FullTime"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2A"), this.getEmployerCompanyAddrPhone(spEmp));
                } else if (EmploymentStatus.CODE_ACTIVE_MILITARYSERVICE.getCode().equals(employmentstatus.getCode()) || EmploymentStatus.CODE_SELF_EMPLOYED.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2:FullTime"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2A"), this.getEmployerCompanyAddrPhone(spEmp));
                } else if (EmploymentStatus.CODE_PART_TIME.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2:PartTime"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2A"), this.getEmployerCompanyAddrPhone(spEmp));
                } else if (EmploymentStatus.CODE_NOT_EMPLOYED.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2:NotEmployed"), "Yes");
                } else if (EmploymentStatus.CODE_RETIRED.getCode().equals(employmentstatus.getCode())) {
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2:Retired"), "Yes");
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2:RetirementDate"), DateUtils.format((ImpreciseDate)retiredate, null));
                    this.fields.setField((String)this.fieldMap.get("Section3:Question2A"), this.getEmployerCompanyAddrPhone(spEmp));
                }
            }
        }
    }

    private void fillSection4() throws DocumentException, IOException, Exception {
        MilitaryServiceSiteRecord latestmilitaryServiceSiteRecord;
        MilitaryServiceEpisode latestEpisode;
        EnvironmentalContaminationExposure eexp;
        RadiationExposure rexp;
        ServiceConnectionAward scAward;
        PrisonerOfWar pow;
        PurpleHeart ph = this.person.getPurpleHeart();
        if (ph != null && ph.getPhIndicator() != null) {
            if (Boolean.TRUE.equals(ph.getPhIndicator()) && ph.getStatus() != null && DecorationStatus.CODE_CONFIRMED.getCode().equals(ph.getStatus().getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2A:Yes"), "Yes");
            } else if (this.isFalse(ph.getPhIndicator())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2A:No"), "Yes");
            }
        }
        if ((pow = this.person.getPrisonerOfWar()) != null && pow.getPowIndicator() != null) {
            if (Boolean.TRUE.equals(pow.getPowIndicator().toBoolean())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2B:Yes"), "Yes");
            } else if (Boolean.FALSE.equals(pow.getPowIndicator().toBoolean())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2B:No"), "Yes");
            }
        }
        if ((scAward = this.person.getServiceConnectionAward()) != null && scAward.getServiceConnectedPercentage() != null) {
            if (scAward.getServiceConnectedPercentage() > 0 && Boolean.TRUE.equals(scAward.getServiceConnectedIndicator())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2C:Yes"), "Yes");
                this.fields.setField((String)this.fieldMap.get("Section4:Question2C1"), scAward.getServiceConnectedPercentage().toString());
            } else {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2C:No"), "Yes");
            }
        } else {
            this.fields.setField((String)this.fieldMap.get("Section4:Question2C:No"), "Yes");
        }
        AgentOrangeExposure aoe = this.person.getAgentOrangeExposure();
        if (aoe != null && aoe.getAgentOrangeExposureIndicator() != null) {
            if (Indicator.YES.getCode().equals(aoe.getAgentOrangeExposureIndicator().getCode()) && aoe.getLocation() != null && AgentOrangeExposureLocation.CODE_VIETNAM.getCode().equalsIgnoreCase(aoe.getLocation().getCode())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2G:Yes"), "Yes");
            } else {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2G:No"), "Yes");
            }
        }
        if ((rexp = this.person.getRadiationExposure()) != null && rexp.getRadiationExposureIndicator() != null) {
            if (Indicator.YES.getCode().equals(rexp.getRadiationExposureIndicator().getCode()) && rexp.getExposureMethod() != null) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2H:Yes"), "Yes");
            } else {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2H:No"), "Yes");
            }
        }
        if ((eexp = this.person.getEnvironmentalContaminationExposure()) != null && eexp.getEnvironmentalContaminationExposureIndicator() != null && Indicator.YES.getCode().equals(eexp.getEnvironmentalContaminationExposureIndicator().getCode())) {
            this.fields.setField((String)this.fieldMap.get("Section4:Question2F:Yes"), "Yes");
        } else {
            this.fields.setField((String)this.fieldMap.get("Section4:Question2F:No"), "Yes");
        }
        NoseThroatRadium ntr = (NoseThroatRadium)this.person.getClinicalDeterminationByType(NoseThroatRadium.class);
        if (ntr != null && ntr.getReceivingTreatment() != null) {
            if (ntr.getVerificationDate() != null && TriState.TRUE.equals((Object)ntr.getReceivingTreatment())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2I:Yes"), "Yes");
            } else if (ntr.getVerificationDate() == null && TriState.FALSE.equals((Object)ntr.getReceivingTreatment())) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2I:No"), "Yes");
            }
        }
        if (this.militaryService != null) {
            if (this.militaryService.getDisabilityRetirementIndicator() != null && Indicator.YES.getCode().equals(this.getIndicatorCode(this.militaryService.getDisabilityRetirementIndicator()))) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2E1:Yes"), "Yes");
            } else if (this.militaryService.getDisabilityRetirementIndicator() != null && Indicator.NO.getCode().equals(this.getIndicatorCode(this.militaryService.getDisabilityRetirementIndicator()))) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2E1:No"), "Yes");
            }
            if (this.militaryService.getDischargeDueToDisability() != null && Indicator.YES.getCode().equals(this.getIndicatorCode(this.militaryService.getDischargeDueToDisability()))) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2E:Yes"), "Yes");
            } else if (this.militaryService.getDischargeDueToDisability() != null && Indicator.NO.getCode().equals(this.getIndicatorCode(this.militaryService.getDischargeDueToDisability()))) {
                this.fields.setField((String)this.fieldMap.get("Section4:Question2E:No"), "Yes");
            }
        }
        if ((latestEpisode = this.getLatestMilitaryServiceEpisode(latestmilitaryServiceSiteRecord = this.getLatestMilitaryServiceSiteRecord())) != null) {
            String militaryServiceNumber = latestEpisode.getServiceNumber();
            String branchOfService = latestEpisode.getServiceBranch() == null ? "" : latestEpisode.getServiceBranch().getDescription();
            String entryDate = JspUtils.displayValue((Object)latestEpisode.getStartDate(), (String)"MM/dd/yyyy");
            String separationDate = JspUtils.displayValue((Object)latestEpisode.getEndDate(), (String)"MM/dd/yyyy");
            String dischargeType = latestEpisode.getDischargeType() == null ? "" : latestEpisode.getDischargeType().getDescription();
            this.fields.setField((String)this.fieldMap.get("Section4:Question1"), branchOfService);
            this.fields.setField((String)this.fieldMap.get("Section4:Question1A"), entryDate);
            this.fields.setField((String)this.fieldMap.get("Section4:Question1B"), separationDate);
            this.fields.setField((String)this.fieldMap.get("Section4:Question1C"), dischargeType);
            this.fields.setField((String)this.fieldMap.get("Section4:Question1D"), militaryServiceNumber);
        }
        ImpreciseDate afterDate = ImpreciseDateUtils.createImpreciseDate((int)1998, (int)11, (int)11);
        boolean isServeCombat = false;
        Set combatepisodes = this.militaryService.getCombatEpisodes();
        MilitaryServiceActionHelper.sortCombatEpisodes(combatepisodes);
        if (combatepisodes != null && !combatepisodes.isEmpty()) {
            List combats = MilitaryServiceActionHelper.sortCombatEpisodes(combatepisodes);
            for (CombatEpisode cbats : combats) {
                ImpreciseDate combatStartDate = cbats.getStartDate();
                if (combatStartDate == null || combatStartDate.compareTo(afterDate) != 1) continue;
                this.fields.setField((String)this.fieldMap.get("Section4:Question2D:Yes"), "Yes");
                isServeCombat = true;
                break;
            }
        }
        if (!isServeCombat) {
            this.fields.setField((String)this.fieldMap.get("Section4:Question2D:No"), "Yes");
        }
    }

    private void fillSection5() throws DocumentException, IOException {
        IncomeTest test = this.person.getIncomeTest(this.incomeYear);
        if (test == null || test.getDiscloseFinancialInformation() == null) {
            this.FinDisclosureFlag = false;
        } else if (this.isTrue(test.getDiscloseFinancialInformation())) {
            this.fields.setField((String)this.fieldMap.get("Section5:Yes"), "Yes");
            this.FinDisclosureFlag = true;
        } else if (this.isFalse(test.getDiscloseFinancialInformation())) {
            this.fields.setField((String)this.fieldMap.get("Section5:No"), "Yes");
            this.FinDisclosureFlag = false;
        }
    }

    private void fillSection7() throws DocumentException, IOException {
        if (this.spouse != null) {
            this.fields.setField((String)this.fieldMap.get("Section7:Question1"), this.spouse.getName() != null ? this.getLastFirstMiddleByComma(this.spouse.getName()) : "");
            this.fields.setField((String)this.fieldMap.get("Section7:Question1A"), this.spouse.getMaidenName());
            this.fields.setField((String)this.fieldMap.get("Section7:Question1B"), this.spouse.getOfficialSsn() != null ? JspUtils.displaySSN((String)this.spouse.getOfficialSsn().getSsnText()) : "");
            this.fields.setField((String)this.fieldMap.get("Section7:Question1C"), DateUtils.format((ImpreciseDate)this.spouse.getDob(), null));
            this.fields.setField((String)this.fieldMap.get("Section7:Question1D"), DateUtils.format((ImpreciseDate)this.spouse.getMarriageDate(), null));
            String spAddr = this.spouse.getAddress() != null ? this.spouse.getAddress().getFormattedAddress() : "";
            String spPhone = this.spouse.getHomePhone() != null ? this.spouse.getHomePhone().getFormattedPhone() : "";
            this.fields.setField((String)this.fieldMap.get("Section7:Question1E"), spAddr + "\n" + spPhone);
            if (this.FinDisclosureFlag && this.sf.getLivedWithPatient() != null && !this.sf.getLivedWithPatient().booleanValue()) {
                this.fields.setField((String)this.fieldMap.get("Section7:Question3:Yes"), "Yes");
            }
        }
        DependentFinancials df2 = null;
        Dependent dependent = null;
        int dep_cnt = 0;
        int add_cnt = 0;
        if (this.dependentFinancials != null && this.dependentFinancials.size() != 0) {
            boolean isFirst = true;
            boolean addFirst = true;
            for (DependentFinancials df2 : this.dependentFinancials) {
                PdfPCell cell;
                dependent = df2.getReportedOn();
                if (dependent == null) continue;
                ++dep_cnt;
                if (isFirst) {
                    this.fields.setField((String)this.fieldMap.get("Section7:Question2"), dependent.getName() != null ? this.getLastFirstMiddleByComma(dependent.getName()) : "");
                    if (dependent.getRelationship() != null) {
                        if (Relationship.CODE_SON.getCode().equals(dependent.getRelationship().getCode())) {
                            this.fields.setField((String)this.fieldMap.get("Section7:Question2A:Son"), "Yes");
                        } else if (Relationship.CODE_DAUGHTER.getCode().equals(dependent.getRelationship().getCode())) {
                            this.fields.setField((String)this.fieldMap.get("Section7:Question2A:Daughter"), "Yes");
                        } else if (Relationship.CODE_STEPSON.getCode().equals(dependent.getRelationship().getCode())) {
                            this.fields.setField((String)this.fieldMap.get("Section7:Question2A:Stepson"), "Yes");
                        } else if (Relationship.CODE_STEPDAUGHTER.getCode().equals(dependent.getRelationship().getCode())) {
                            this.fields.setField((String)this.fieldMap.get("Section7:Question2A:Stepdaughter"), "Yes");
                        }
                    }
                    this.fields.setField((String)this.fieldMap.get("Section7:Question2B"), dependent.getOfficialSsn() != null ? JspUtils.displaySSN((String)dependent.getOfficialSsn().getSsnText()) : "");
                    this.fields.setField((String)this.fieldMap.get("Section7:Question2C"), DateUtils.format((ImpreciseDate)dependent.getStartDate(), null));
                    this.fields.setField((String)this.fieldMap.get("Section7:Question2D"), DateUtils.format((ImpreciseDate)dependent.getDob(), null));
                    if (df2.getIncapableOfSelfSupport() != null && df2.getIncapableOfSelfSupport().booleanValue()) {
                        this.fields.setField((String)this.fieldMap.get("Section7:Question2E:Yes"), "Yes");
                    } else {
                        this.fields.setField((String)this.fieldMap.get("Section7:Question2E:No"), "Yes");
                    }
                    if (df2.getAttendedSchool() != null && df2.getAttendedSchool().booleanValue()) {
                        this.fields.setField((String)this.fieldMap.get("Section7:Question2F:Yes"), "Yes");
                    } else {
                        this.fields.setField((String)this.fieldMap.get("Section7:Question2F:No"), "Yes");
                    }
                    if (this.FinDisclosureFlag) {
                        if (df2.getLivedWithPatient() != null && !df2.getLivedWithPatient().booleanValue()) {
                            this.fields.setField((String)this.fieldMap.get("Section7:Question3:Yes"), "Yes");
                        }
                        this.fields.setField((String)this.fieldMap.get("Section7:Question2G"), df2.getEducationExpense() != null && df2.getEducationExpense().getAmount() != null ? df2.getEducationExpense().getAmount().toString() : "");
                    }
                    isFirst = false;
                    continue;
                }
                ++add_cnt;
                PdfPTable table = new PdfPTable(5);
                table.setKeepTogether(true);
                table.setWidthPercentage(100.0f);
                table.setSpacingAfter(0.0f);
                float[] widths = new float[]{23.0f, 22.0f, 5.0f, 25.0f, 25.0f};
                table.setWidths(widths);
                if (add_cnt % 4 == 1 || addFirst) {
                    cell = new PdfPCell((Phrase)new Paragraph("APPLICATION FOR HEALTH BENEFITS, Continued", FontFactory.getFont((String)"Helvetica", (float)11.0f, (int)1, (Color)Color.BLACK)));
                    cell.setHorizontalAlignment(1);
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("VETERAN'S NAME  (Last, First, Middle)\n\n" + this.veteranName, this.font_times));
                    cell.setColspan(2);
                    cell.setHorizontalAlignment(0);
                    table.addCell(cell);
                    table.addCell(new Phrase("SOCIAL SECURITY NUMBER\n\n" + this.veteranSSN, this.font_times));
                    addFirst = false;
                }
                cell = new PdfPCell((Phrase)new Paragraph("Section VII - DEPENDENT INFORMATION (Child #" + dep_cnt + ")", FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1, (Color)Color.BLACK)));
                cell.setColspan(5);
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(Color.LIGHT_GRAY);
                table.addCell(cell);
                String depname = dependent.getName() != null ? this.getLastFirstMiddleByComma(dependent.getName()) : "";
                cell = new PdfPCell(new Phrase("2.CHILD'S NAME(Last, First , Middle Name)\n\n" + depname, this.font_courier));
                cell.setColspan(3);
                table.addCell(cell);
                String deprelation = dependent.getRelationship() != null ? dependent.getRelationship().getDescription() : "";
                cell = new PdfPCell(new Phrase("2A.CHILD'S RELATIONSHIP TO YOU\n\n" + deprelation, this.font_courier));
                cell.setColspan(2);
                table.addCell(cell);
                String depssn = dependent.getOfficialSsn() != null ? JspUtils.displaySSN((String)dependent.getOfficialSsn().getSsnText()) : "";
                table.addCell(new Phrase("2B.CHILD SOCIAL SECURITY NUMBER\n\n" + depssn, this.font_courier));
                cell = new PdfPCell(new Phrase("2C.DATE CHILD BECAME YOUR DEPENDENT (mm/dd/yyyy)\n\n" + DateUtils.format((ImpreciseDate)dependent.getStartDate(), null), this.font_courier));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase("2D.CHILD'S DATE OF BIRTH(mm/dd/yyyy)\n\n" + DateUtils.format((ImpreciseDate)dependent.getDob(), null), this.font_courier));
                cell.setColspan(2);
                table.addCell(cell);
                String disable = df2.getIncapableOfSelfSupport() != null && df2.getIncapableOfSelfSupport() != false ? "YES" : "NO";
                cell = new PdfPCell(new Phrase("2E.WAS CHILD PERMANENTLY AND TOTALY DISABLED BEFORE THE AGE OF 18?\n\n" + disable, this.font_courier));
                cell.setColspan(3);
                table.addCell(cell);
                String attendschool = df2.getAttendedSchool() != null && df2.getAttendedSchool() != false ? "YES" : "NO";
                cell = new PdfPCell(new Phrase("2F.IF CHILD IS BETWEEN 18 and 23 YEARS OF AGE,DID CHILD ATTEND SCHOOL LAST CALENDAR YEAR?\n\n" + attendschool, this.font_courier));
                cell.setColspan(2);
                table.addCell(cell);
                String childschool = "";
                String childsupport = "";
                if (this.FinDisclosureFlag) {
                    childschool = df2.getEducationExpense() != null && df2.getEducationExpense().getAmount() != null ? df2.getEducationExpense().getAmount().toString() : "";
                    childsupport = df2.getAmountContributedToSupport() != null ? df2.getAmountContributedToSupport().toString() : "";
                }
                cell = new PdfPCell(new Phrase("3.IF YOUR DEPENDENT CHILD DID NOT LIVE WITH YOU LAST YEAR ENTER THE AMOUNT YOU CONTRIBUTED TO THEIR SUPPORT.\n\nCHILD     $     " + childsupport, this.font_courier));
                cell.setColspan(3);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase("2G.EXPENSES PAID BY YOUR DEPENDENT CHILD FOR COLLEGE,VOCATIONAL REHABILITATION ORTRAINING(e.g.,tuition,books,materials)\n\n$     " + childschool, this.font_courier));
                cell.setColspan(2);
                table.addCell(cell);
                this.additionalChildDocument.add((Element)table);
            }
        }
    }

    private void fillSection8_9_10() throws DocumentException, IOException {
        DependentFinancials df2 = null;
        Dependent dependent = null;
        if (this.FinDisclosureFlag) {
            if (this.ftmt != null) {
                this.fields.setField((String)this.fieldMap.get("Section8:Question1:Veteran"), this.ftmt.getTotalEmploymentIncome() != null && this.ftmt.getTotalEmploymentIncome().getAmount() != null ? this.ftmt.getTotalEmploymentIncome().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section8:Question2:Veteran"), this.ftmt.getFarmRanchBusinessIncome() != null && this.ftmt.getFarmRanchBusinessIncome().getAmount() != null ? this.ftmt.getFarmRanchBusinessIncome().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section8:Question3:Veteran"), this.ftmt.getOtherIncome() != null && this.ftmt.getOtherIncome().getAmount() != null ? this.ftmt.getOtherIncome().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section9:Question1"), this.ftmt.getNonReimbursableExpense() != null && this.ftmt.getNonReimbursableExpense().getAmount() != null ? this.ftmt.getNonReimbursableExpense().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section9:Question2"), this.ftmt.getFuneralBurialExpense() != null && this.ftmt.getFuneralBurialExpense().getAmount() != null ? this.ftmt.getFuneralBurialExpense().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section9:Question3"), this.ftmt.getVeteranEducationExpense() != null && this.ftmt.getVeteranEducationExpense().getAmount() != null ? this.ftmt.getVeteranEducationExpense().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section10:Question1:Veteran"), this.ftmt.getCashAndBankAccountBalances() != null && this.ftmt.getCashAndBankAccountBalances().getAmount() != null ? this.ftmt.getCashAndBankAccountBalances().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section10:Question2:Veteran"), this.ftmt.getRealEstate() != null && this.ftmt.getRealEstate().getAmount() != null ? this.ftmt.getRealEstate().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section10:Question3:Veteran"), this.ftmt.getOtherPropertyOrAssets() != null && this.ftmt.getOtherPropertyOrAssets().getAmount() != null ? this.ftmt.getOtherPropertyOrAssets().getAmount().toString() : "");
            }
            if (this.sf != null) {
                this.fields.setField((String)this.fieldMap.get("Section8:Question1:Spouse"), this.sf.getTotalEmploymentIncome() != null && this.sf.getTotalEmploymentIncome().getAmount() != null ? this.sf.getTotalEmploymentIncome().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section8:Question2:Spouse"), this.sf.getFarmRanchBusinessIncome() != null && this.sf.getFarmRanchBusinessIncome().getAmount() != null ? this.sf.getFarmRanchBusinessIncome().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section8:Question3:Spouse"), this.sf.getOtherIncome() != null && this.sf.getOtherIncome().getAmount() != null ? this.sf.getOtherIncome().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section10:Question1:Spouse"), this.sf.getCashAndBankAccountBalances() != null && this.sf.getCashAndBankAccountBalances().getAmount() != null ? this.sf.getCashAndBankAccountBalances().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section10:Question2:Spouse"), this.sf.getRealEstate() != null && this.sf.getRealEstate().getAmount() != null ? this.sf.getRealEstate().getAmount().toString() : "");
                this.fields.setField((String)this.fieldMap.get("Section10:Question3:Spouse"), this.sf.getOtherPropertyOrAssets() != null && this.sf.getOtherPropertyOrAssets().getAmount() != null ? this.sf.getOtherPropertyOrAssets().getAmount().toString() : "");
            }
            if (this.dependentFinancials != null && this.dependentFinancials.size() != 0) {
                PdfPCell cell;
                float[] widths;
                PdfPTable table;
                boolean isFirst_8 = true;
                boolean isFirst_10 = true;
                boolean addFirst = true;
                int childCnt = 0;
                int add_child_cnt = 0;
                for (DependentFinancials df2 : this.dependentFinancials) {
                    dependent = df2.getReportedOn();
                    if (dependent == null) continue;
                    ++childCnt;
                    if (isFirst_8) {
                        this.fields.setField((String)this.fieldMap.get("Section8:Question1:Child"), df2.getTotalEmploymentIncome() != null && df2.getTotalEmploymentIncome().getAmount() != null ? df2.getTotalEmploymentIncome().getAmount().toString() : "");
                        this.fields.setField((String)this.fieldMap.get("Section8:Question2:Child"), df2.getFarmRanchBusinessIncome() != null && df2.getFarmRanchBusinessIncome().getAmount() != null ? df2.getFarmRanchBusinessIncome().getAmount().toString() : "");
                        this.fields.setField((String)this.fieldMap.get("Section8:Question3:Child"), df2.getOtherIncome() != null && df2.getOtherIncome().getAmount() != null ? df2.getOtherIncome().getAmount().toString() : "");
                        isFirst_8 = false;
                        continue;
                    }
                    if (++add_child_cnt % 9 == 1 || addFirst) {
                        this.additionalChildDocument.newPage();
                        table = new PdfPTable(3);
                        table.setWidthPercentage(100.0f);
                        table.setSpacingAfter(0.0f);
                        table.setKeepTogether(true);
                        widths = new float[]{45.0f, 30.0f, 25.0f};
                        table.setWidths(widths);
                        cell = new PdfPCell((Phrase)new Paragraph("APPLICATION FOR HEALTH BENEFITS, Continued", FontFactory.getFont((String)"Helvetica", (float)11.0f, (int)1, (Color)Color.BLACK)));
                        cell.setHorizontalAlignment(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("VETERAN'S NAME  (Last, First, Middle)\n\n" + this.veteranName, this.font_times));
                        cell.setHorizontalAlignment(0);
                        table.addCell(cell);
                        table.addCell(new Phrase("SOCIAL SECURITY NUMBER\n\n" + this.veteranSSN, this.font_times));
                        cell = new PdfPCell((Phrase)new Paragraph("Section VIII - PREVIOUS CALENDAR YEAR GROSS ANNUAL INCOME OF VETERAN, SPOUSE AND DEPENDENT CHILDREN (Continued)", FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1, (Color)Color.BLACK)));
                        cell.setColspan(3);
                        cell.setHorizontalAlignment(1);
                        cell.setBackgroundColor(Color.LIGHT_GRAY);
                        table.addCell(cell);
                        addFirst = false;
                        this.additionalChildDocument.add((Element)table);
                    }
                    table = new PdfPTable(3);
                    table.setWidthPercentage(100.0f);
                    table.setKeepTogether(true);
                    widths = new float[]{34.0f, 33.0f, 33.0f};
                    table.setWidths(widths);
                    table.setSpacingAfter(0.0f);
                    cell = new PdfPCell((Phrase)new Paragraph("Child #" + childCnt, FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1, (Color)Color.BLACK)));
                    cell.setColspan(3);
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                    String grossincome = df2.getTotalEmploymentIncome() != null && df2.getTotalEmploymentIncome().getAmount() != null ? df2.getTotalEmploymentIncome().getAmount().toString() : "";
                    table.addCell(new Phrase("1.GROSS ANNUAL INCOME FROM EMPLOYMENT  * (wages,bonuses,tips,etc.) EXCLUDING INCOME FROM YOUR FARM,RANCH,PROPERTYOR BUSINESS\n\n" + this.addCurrencySymbol(grossincome), this.font_courier));
                    String netincome = df2.getFarmRanchBusinessIncome() != null && df2.getFarmRanchBusinessIncome().getAmount() != null ? df2.getFarmRanchBusinessIncome().getAmount().toString() : "";
                    table.addCell(new Phrase("2.NET INCOME FROM YOUR FARM,RANCH,PROPERTY,OR BUSINESS\n\n" + this.addCurrencySymbol(netincome), this.font_courier));
                    String otherincome = df2.getOtherIncome() != null && df2.getOtherIncome().getAmount() != null ? df2.getOtherIncome().getAmount().toString() : "";
                    table.addCell(new Phrase("3.LIST OTHER INCOME AMOUNTS (eg.Social Security, compensation, pension interest,dividends),EXCLUDING WELFARE.\n\n" + this.addCurrencySymbol(otherincome), this.font_courier));
                    this.additionalChildDocument.add((Element)table);
                }
                childCnt = 0;
                add_child_cnt = 0;
                addFirst = true;
                for (DependentFinancials df2 : this.dependentFinancials) {
                    dependent = df2.getReportedOn();
                    if (dependent == null) continue;
                    ++childCnt;
                    if (isFirst_10) {
                        this.fields.setField((String)this.fieldMap.get("Section10:Question1:Child"), df2.getCashAndBankAccountBalances() != null && df2.getCashAndBankAccountBalances().getAmount() != null ? df2.getCashAndBankAccountBalances().getAmount().toString() : "");
                        this.fields.setField((String)this.fieldMap.get("Section10:Question2:Child"), df2.getRealEstate() != null && df2.getRealEstate().getAmount() != null ? df2.getRealEstate().getAmount().toString() : "");
                        this.fields.setField((String)this.fieldMap.get("Section10:Question3:Child"), df2.getOtherPropertyOrAssets() != null && df2.getOtherPropertyOrAssets().getAmount() != null ? df2.getOtherPropertyOrAssets().getAmount().toString() : "");
                        isFirst_10 = false;
                        continue;
                    }
                    if (++add_child_cnt % 7 == 1 || addFirst) {
                        this.additionalChildDocument.newPage();
                        table = new PdfPTable(3);
                        table.setWidthPercentage(100.0f);
                        table.setSpacingAfter(0.0f);
                        table.setKeepTogether(true);
                        widths = new float[]{45.0f, 30.0f, 25.0f};
                        table.setWidths(widths);
                        cell = new PdfPCell((Phrase)new Paragraph("APPLICATION FOR HEALTH BENEFITS, Continued", FontFactory.getFont((String)"Helvetica", (float)11.0f, (int)1, (Color)Color.BLACK)));
                        cell.setHorizontalAlignment(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("VETERAN'S NAME  (Last, First, Middle)\n\n" + this.veteranName, this.font_times));
                        cell.setHorizontalAlignment(0);
                        table.addCell(cell);
                        table.addCell(new Phrase("SOCIAL SECURITY NUMBER\n\n" + this.veteranSSN, this.font_times));
                        cell = new PdfPCell((Phrase)new Paragraph("Section X - PREVIOUS CALENDAR YEAR NET WORTH (Continued)", FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1, (Color)Color.BLACK)));
                        cell.setColspan(3);
                        cell.setHorizontalAlignment(1);
                        cell.setBackgroundColor(Color.LIGHT_GRAY);
                        table.addCell(cell);
                        addFirst = false;
                        this.additionalChildDocument.add((Element)table);
                    }
                    table = new PdfPTable(3);
                    table.setWidthPercentage(100.0f);
                    widths = new float[]{34.0f, 33.0f, 33.0f};
                    table.setWidths(widths);
                    table.setSpacingAfter(0.0f);
                    cell = new PdfPCell((Phrase)new Paragraph("Child #" + childCnt, FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1, (Color)Color.BLACK)));
                    cell.setColspan(3);
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                    String bankamt = df2.getCashAndBankAccountBalances() != null && df2.getCashAndBankAccountBalances().getAmount() != null ? df2.getCashAndBankAccountBalances().getAmount().toString() : "";
                    table.addCell(new Phrase("1.CASH,AMOUNT IN BANK ACCOUNTS.\n\n" + this.addCurrencySymbol(bankamt), this.font_courier));
                    String marketvalue = df2.getRealEstate() != null && df2.getRealEstate().getAmount() != null ? df2.getRealEstate().getAmount().toString() : "";
                    table.addCell(new Phrase("2.MARKET VALUE OF LAND AND BUILDINGS MINUS MORTGAGES AND LIENS. (e.g. second homes and non-income producing property. Do not countyour primary home.)\n\n" + this.addCurrencySymbol(marketvalue), this.font_courier));
                    String othervalue = df2.getOtherPropertyOrAssets() != null && df2.getOtherPropertyOrAssets().getAmount() != null ? df2.getOtherPropertyOrAssets().getAmount().toString() : "";
                    table.addCell(new Phrase("3.VALUE OF OTHER PROPERTY OR ASSETS (e.g. art, rare coins,collectables) MINUS THE AMOUNT YOU OWE ON THESE ITEMS. INCLUDE VALUE OFFARM, RANCH OR BUSINESS ASSETS. Exclude household effects and family vehicles.\n\n" + this.addCurrencySymbol(othervalue), this.font_courier));
                    this.additionalChildDocument.add((Element)table);
                }
            }
        }
    }

    private void fillSection12() throws DocumentException, IOException {
        this.fields.setField((String)this.fieldMap.get("Section12:Date"), new SimpleDateFormat("MM/dd/yyyy").format(new Date()));
    }

    private String removeCurrencySymbol(String currency) {
        if (currency != null && StringUtils.isEmpty((String)currency)) {
            return currency.substring(1);
        }
        return "";
    }

    private String addCurrencySymbol(String currency) {
        if (currency != null && StringUtils.isNotEmpty((String)currency)) {
            return "$ " + currency;
        }
        return "$";
    }

    private String getInsuranceCompanyAddrPhone(InsurancePolicy insurance) {
        StringBuffer insuranceInfo = new StringBuffer();
        if (insurance.getCompanyName() != null && StringUtils.isNotEmpty((String)insurance.getCompanyName())) {
            insuranceInfo.append(insurance.getCompanyName());
        }
        if (insurance.getAddress() != null && StringUtils.isNotEmpty((String)insurance.getAddress().getFormattedAddress())) {
            if (insuranceInfo.length() > 0) {
                insuranceInfo.append("\n");
            }
            insuranceInfo.append(insurance.getAddress().getFormattedAddress());
        }
        if (insurance.getBusinessPhone() != null && StringUtils.isNotEmpty((String)insurance.getBusinessPhone().getFormattedPhone())) {
            if (insuranceInfo.length() > 0) {
                insuranceInfo.append("\n");
            }
            insuranceInfo.append(insurance.getBusinessPhone().getFormattedPhone());
        }
        return insuranceInfo.toString();
    }

    private String getEmployerCompanyAddrPhone(Employment em) {
        StringBuffer emInfo = new StringBuffer();
        if (em.getEmployerName() != null && StringUtils.isNotEmpty((String)em.getEmployerName())) {
            emInfo.append(em.getEmployerName());
        }
        if (em.getEmployerAddress() != null && StringUtils.isNotEmpty((String)em.getEmployerAddress().getFormattedAddress())) {
            if (emInfo.length() > 0) {
                emInfo.append("\n");
            }
            emInfo.append(em.getEmployerAddress().getFormattedAddress());
        }
        if (em.getEmployerPhone() != null && StringUtils.isNotEmpty((String)em.getEmployerPhone())) {
            if (emInfo.length() > 0) {
                emInfo.append("\n");
            }
            emInfo.append(em.getEmployerPhone());
        }
        return emInfo.toString();
    }

    private String getIndicatorCode(Boolean flag) {
        if (flag == null) {
            return Indicator.UNKNOWN.getCode();
        }
        return flag.equals(Boolean.TRUE) ? Indicator.YES.getCode() : Indicator.NO.getCode();
    }

    private boolean isTrue(Boolean bool) {
        return bool != null && bool != false;
    }

    private boolean isTrue(Indicator ind) {
        return ind != null && ind.getCode().equals(Indicator.YES.getCode());
    }

    private boolean isFalse(Boolean bool) {
        return bool != null && bool == false;
    }

    private boolean isFalse(Indicator ind) {
        return ind != null && ind.getCode().equals(Indicator.NO.getCode());
    }

    private boolean isUnknown(Boolean bool) {
        return bool == null;
    }

    private boolean isUnknown(Indicator ind) {
        return ind != null && ind.getCode().equals(Indicator.UNKNOWN.getCode());
    }

    private List getPatientVisitSummaries() {
        Map patientVisits = null;
        Set facilityKeys = null;
        if (this.patientVisitSummaries == null) {
            this.patientVisitSummaries = new ArrayList();
        }
        if ((patientVisits = this.person.getPatientVisitSummaries()) != null) {
            facilityKeys = patientVisits.keySet();
        }
        if (facilityKeys != null) {
            for (SiteYear siteYear : facilityKeys) {
                VAFacility facility;
                if (siteYear == null || (facility = siteYear.getFacility()) == null || facility.getType() == null || !facility.getType().getIsMedicalTreating()) continue;
                PatientVisitSummary patientVisitSummary = (PatientVisitSummary)patientVisits.get(siteYear);
                this.patientVisitSummaries.add(patientVisitSummary);
            }
        }
        return this.patientVisitSummaries;
    }

    private MilitaryServiceSiteRecord getLatestMilitaryServiceSiteRecord() throws Exception {
        boolean isHECsiteRecordPresent = false;
        boolean isVOAsiteRecordPresent = false;
        boolean isVAMCsiteRecordPresent = false;
        MilitaryServiceSiteRecord latestSiteRec = null;
        MilitaryServiceSiteRecord siteRec = null;
        Iterator itr = null;
        if (this.militaryService != null) {
            Set siteRecords = this.militaryService.getMilitaryServiceSiteRecords();
            itr = siteRecords != null ? siteRecords.iterator() : null;
            MilitaryServiceSiteRecord latestHECSiteRec = null;
            MilitaryServiceSiteRecord latestVOASiteRec = null;
            MilitaryServiceSiteRecord latestVAMCSiteRec = null;
            while (itr != null && itr.hasNext()) {
                siteRec = (MilitaryServiceSiteRecord)itr.next();
                if (siteRec.getSite() != null && VAFacility.CODE_HEC.getName().equalsIgnoreCase(siteRec.getSite().getName())) {
                    isHECsiteRecordPresent = true;
                    if (latestHECSiteRec == null) {
                        latestHECSiteRec = siteRec;
                        continue;
                    }
                    if (!latestHECSiteRec.getModifiedOn().before(siteRec.getModifiedOn())) continue;
                    latestHECSiteRec = siteRec;
                    continue;
                }
                if (siteRec.getSite() != null && VAFacility.CODE_MHV.getName().equalsIgnoreCase(siteRec.getSite().getName())) {
                    isVOAsiteRecordPresent = true;
                    if (latestVOASiteRec == null) {
                        latestVOASiteRec = siteRec;
                        continue;
                    }
                    if (!latestVOASiteRec.getModifiedOn().before(siteRec.getModifiedOn())) continue;
                    latestVOASiteRec = siteRec;
                    continue;
                }
                isVAMCsiteRecordPresent = true;
                if (latestVAMCSiteRec == null) {
                    latestVAMCSiteRec = siteRec;
                    continue;
                }
                if (!latestVAMCSiteRec.getModifiedOn().before(siteRec.getModifiedOn())) continue;
                latestVAMCSiteRec = siteRec;
            }
            if (isHECsiteRecordPresent) {
                latestSiteRec = latestHECSiteRec;
            } else if (isVAMCsiteRecordPresent) {
                latestSiteRec = latestVAMCSiteRec;
            } else if (isVOAsiteRecordPresent) {
                latestSiteRec = latestVOASiteRec;
            }
        }
        return latestSiteRec;
    }

    private MilitaryServiceEpisode getLatestMilitaryServiceEpisode(MilitaryServiceSiteRecord mtsiterecords) throws Exception {
        MilitaryServiceEpisode latestEpisode = null;
        Iterator itr = null;
        if (mtsiterecords != null) {
            Set episodes = mtsiterecords.getMilitaryServiceEpisodes();
            itr = episodes != null ? episodes.iterator() : null;
            MilitaryServiceEpisode episode = null;
            while (itr != null && itr.hasNext()) {
                episode = (MilitaryServiceEpisode)itr.next();
                if (latestEpisode == null) {
                    latestEpisode = episode;
                    continue;
                }
                if (latestEpisode.getEndDate() == null || latestEpisode.getEndDate().compareTo(episode.getEndDate()) >= 0) continue;
                latestEpisode = episode;
            }
        }
        return latestEpisode;
    }

    private List sortPrivateInsurance(Set pinsr) {
        if (pinsr == null) {
            return null;
        }
        ArrayList privateList = new ArrayList(pinsr);
        if (!privateList.isEmpty()) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date startImDate2;
                    Date startImDate1 = pObject1 != null && pObject1 instanceof PrivateInsurance ? ((PrivateInsurance)pObject1).getModifiedOn() : null;
                    Date date = startImDate2 = pObject2 != null && pObject2 instanceof PrivateInsurance ? ((PrivateInsurance)pObject2).getModifiedOn() : null;
                    if (startImDate1 != null && startImDate2 != null) {
                        long secondTime;
                        long thisTime = startImDate1.getTime();
                        return thisTime > (secondTime = startImDate2.getTime()) ? -1 : (thisTime == secondTime ? 0 : 1);
                    }
                    return 0;
                }
            };
            Collections.sort(privateList, comparator);
        }
        return privateList;
    }

    private String getLastFirstMiddleByComma(Name name) {
        StringBuffer buf = new StringBuffer();
        if (name == null) {
            return null;
        }
        String flname = name.getFormattedName();
        String middleName = name.getMiddleName();
        if (StringUtils.isNotBlank((String)flname)) {
            buf.append(flname);
        }
        if (StringUtils.isNotBlank((String)middleName)) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(middleName);
        }
        return buf.toString().toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display1010EZ(HttpServletResponse resp) throws Exception {
        FileInputStream input = null;
        FilterOutputStream dataostream = null;
        String finalFname = this.getOutputFilePath() + this.getFinalFileName();
        try {
            int bytesRead;
            input = new FileInputStream(finalFname);
            resp.setContentType("application/pdf");
            resp.setHeader("Content-Disposition", "inline");
            resp.setHeader("Accept-Ranges", "bytes");
            dataostream = new DataOutputStream((OutputStream)resp.getOutputStream());
            byte[] buf = new byte[4096];
            while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                ((DataOutputStream)dataostream).write(buf, 0, bytesRead);
            }
        }
        finally {
            File file_temp;
            if (input != null) {
                ((InputStream)input).close();
            }
            if (dataostream != null) {
                dataostream.close();
            }
            if ((file_temp = new File(finalFname)) != null && file_temp.exists()) {
                file_temp.delete();
            }
        }
    }

    private String getBirthPlace(String city, String state) {
        StringBuffer birthPlace = new StringBuffer();
        if (city != null) {
            birthPlace.append(city);
        }
        if (birthPlace.length() > 0) {
            birthPlace.append(", ");
        }
        if (state != null) {
            birthPlace.append(state);
        }
        return birthPlace.toString();
    }

    private InputStream readTemplate(String fillableFormFileName) throws Exception {
        FileInputStream inFillablePDFFile;
        FileInputStream inFillablePDF = inFillablePDFFile = new FileInputStream(fillableFormFileName);
        return inFillablePDF;
    }
}

