/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.util;

import gov.va.med.esr.common.model.lookup.Indicator;

public class ConvertUtils {
    public static final String YES_VALUE = "y";
    public static final String NO_VALUE = "n";
    public static final String UNKNOWN_VALUE = "uk";
    public static final String NULL_VALUE = "nd";
    public static final String YES_STRING = "Yes";
    public static final String NO_STRING = "No";
    public static final String UNKNOWN_STRING = "Unknown";
    public static final String NULL_STRING = "No Data";

    private ConvertUtils() {
    }

    public static Boolean convertBoolean(String value) {
        if (value != null && (value.equalsIgnoreCase(YES_VALUE) || value.equalsIgnoreCase(YES_STRING))) {
            return Boolean.TRUE;
        }
        if (value != null && (value.equalsIgnoreCase(NO_VALUE) || value.equalsIgnoreCase(NO_STRING))) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String convertIndicator(String value) {
        if (value != null && (value.equalsIgnoreCase(YES_VALUE) || value.equalsIgnoreCase(YES_STRING))) {
            return Indicator.YES.getCode();
        }
        if (value != null && (value.equalsIgnoreCase(NO_VALUE) || value.equalsIgnoreCase(NO_STRING))) {
            return Indicator.NO.getCode();
        }
        return Indicator.UNKNOWN.getCode();
    }

    public static boolean isYes(String value) {
        return value != null && value.equalsIgnoreCase(YES_VALUE);
    }

    public static String convertYesNo(Object value) {
        if (value == null) {
            return NO_VALUE;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return YES_VALUE;
            }
            return NO_VALUE;
        }
        return YES_VALUE;
    }

    public static String convertYesNoNoData(Object value) {
        if (value == null) {
            return NULL_VALUE;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return YES_VALUE;
            }
            return NO_VALUE;
        }
        return YES_VALUE;
    }

    public static String convertYesNoUnknown(Object value) {
        if (value == null) {
            return UNKNOWN_VALUE;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return YES_VALUE;
            }
            return NO_VALUE;
        }
        return YES_VALUE;
    }

    public static String convertYesNoNoDataString(Object value) {
        if (value == null) {
            return NULL_STRING;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return YES_STRING;
            }
            return NO_STRING;
        }
        return YES_STRING;
    }
}

