/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.util;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.util.ConvertUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.apache.struts.util.LabelValueBean;

public class ApplicationInitializer {
    public static final String YES_VALUE = "y";
    public static final String NO_VALUE = "n";
    public static final String UNKNOWN_VALUE = "uk";
    public static final String NULL_VALUE = "nd";
    public static final String NAME_SUFFIX_JR = "Jr.";
    public static final String NAME_SUFFIX_SR = "Sr.";
    public static final String NAME_SUFFIX_II = "II";
    public static final String NAME_SUFFIX_III = "III";
    public static final String NAME_SUFFIX_IV = "IV";
    public static final String CONTEXT_KEY_YES_NO_LIST = "yesNoList";
    public static final String CONTEXT_KEY_YES_NO_NODATA_LIST = "yesNoNoDataList";
    public static final String CONTEXT_KEY_YES_NO_UNKNOWN_LIST = "yesNoUnknownList";
    public static final String CONTEXT_KEY_NAME_SUFFIX_LIST = "nameSuffixList";
    public static final String CONTEXT_KEY_INCOME_YEARS_LIST = "incomeYearsList";

    public static String convertYesNo(Object value) {
        return ConvertUtils.convertYesNo(value);
    }

    public static String convertYesNoNoData(Object value) {
        return ConvertUtils.convertYesNoNoData(value);
    }

    public static void initialize(ServletContext context) {
        if (context.getAttribute(CONTEXT_KEY_YES_NO_LIST) == null) {
            context.setAttribute(CONTEXT_KEY_YES_NO_LIST, (Object)ApplicationInitializer.getYesNoList());
            context.setAttribute(CONTEXT_KEY_YES_NO_NODATA_LIST, (Object)ApplicationInitializer.getYesNoNoDataList());
            context.setAttribute(CONTEXT_KEY_YES_NO_UNKNOWN_LIST, (Object)ApplicationInitializer.getYesNoUnknownList());
        }
        if (context.getAttribute(CONTEXT_KEY_NAME_SUFFIX_LIST) == null) {
            context.setAttribute(CONTEXT_KEY_NAME_SUFFIX_LIST, (Object)ApplicationInitializer.getNameSuffixList());
        }
        if (context.getAttribute(CONTEXT_KEY_INCOME_YEARS_LIST) == null) {
            context.setAttribute(CONTEXT_KEY_INCOME_YEARS_LIST, (Object)ApplicationInitializer.getIncomeYearsList());
        }
    }

    private static Collection getYesNoList() {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        list.add(new LabelValueBean("label.yes", YES_VALUE));
        list.add(new LabelValueBean("label.no", NO_VALUE));
        return list;
    }

    private static Collection getYesNoNoDataList() {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>(ApplicationInitializer.getYesNoList());
        list.add(new LabelValueBean("label.noData", NULL_VALUE));
        return list;
    }

    private static Collection getYesNoUnknownList() {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>(ApplicationInitializer.getYesNoList());
        list.add(new LabelValueBean("label.unknown", UNKNOWN_VALUE));
        return list;
    }

    private static Collection getNameSuffixList() {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        list.add(new LabelValueBean(NAME_SUFFIX_JR, NAME_SUFFIX_JR));
        list.add(new LabelValueBean(NAME_SUFFIX_SR, NAME_SUFFIX_SR));
        list.add(new LabelValueBean(NAME_SUFFIX_II, NAME_SUFFIX_II));
        list.add(new LabelValueBean(NAME_SUFFIX_III, NAME_SUFFIX_III));
        list.add(new LabelValueBean(NAME_SUFFIX_IV, NAME_SUFFIX_IV));
        return list;
    }

    private static Collection getIncomeYearsList() {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        for (int i = Person.EARLIEST_INCOME_YEAR.intValue(); i <= DateUtils.getCurrentYear() + 1; ++i) {
            list.add(new LabelValueBean(String.valueOf(new Integer(i)), String.valueOf(new Integer(i))));
        }
        return list;
    }
}

