/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.taglib;

import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.struts.taglib.TagUtils;
import org.springframework.web.context.WebApplicationContext;

public class SetLookupTag
extends BodyTagSupport {
    private static final long serialVersionUID = 2787899133475609011L;
    public static final String PAGE_SCOPE = "page";
    public static final String REQUEST_SCOPE = "request";
    public static final String SESSION_SCOPE = "session";
    public static final String APPLICATION_SCOPE = "application";
    private String className;
    private String var;
    private String scope;
    private String removeCollection = null;
    private String removeCollectionScope = null;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getRemoveCollection() {
        return this.removeCollection;
    }

    public void setRemoveCollection(String removeCollection) {
        this.removeCollection = removeCollection;
    }

    public String getRemoveCollectionScope() {
        return this.removeCollectionScope;
    }

    public void setRemoveCollectionScope(String removeCollectionScope) {
        this.removeCollectionScope = removeCollectionScope;
    }

    public int doStartTag() throws JspException {
        UserPrincipal user = SecurityContextHelper.getSecurityContext().getUserPrincipal();
        this.setLookup(this.getLookup(this.className));
        return 6;
    }

    public void release() {
        super.release();
        this.className = null;
        this.var = null;
        this.scope = null;
        this.removeCollection = null;
        this.removeCollectionScope = null;
    }

    protected Collection getLookup(String className) throws JspException {
        Collection list = null;
        try {
            WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
            LookupCacheService lookupCacheService = (LookupCacheService)ac.getBean("lookupCacheService");
            list = this.filterCollection(lookupCacheService.getFromCache(className));
        }
        catch (Exception ex) {
            throw new JspException("Error while getting lookup data.", (Throwable)ex);
        }
        return list;
    }

    protected void setLookup(Collection lookup) throws JspException {
        String localVar;
        String string = localVar = StringUtils.isNotEmpty((String)this.var) ? this.var : this.className;
        if (StringUtils.isEmpty((String)this.scope) || StringUtils.equals((String)this.scope, (String)PAGE_SCOPE)) {
            this.pageContext.setAttribute(localVar, (Object)lookup);
        } else {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (StringUtils.equals((String)this.scope, (String)REQUEST_SCOPE)) {
                request.setAttribute(localVar, (Object)lookup);
            } else if (StringUtils.equals((String)this.scope, (String)SESSION_SCOPE)) {
                request.getSession().setAttribute(localVar, (Object)lookup);
            } else if (StringUtils.equals((String)this.scope, (String)APPLICATION_SCOPE)) {
                request.getSession().getServletContext().setAttribute(localVar, (Object)lookup);
            }
        }
    }

    protected Collection filterCollection(Collection list) throws JspException {
        if (list == null || list.isEmpty()) {
            return list;
        }
        Map removables = this.getRemovables();
        if (removables == null || removables.isEmpty()) {
            return list;
        }
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        for (Lookup lookup : list) {
            if (removables.get(lookup.getCode()) != null) continue;
            result.add(lookup);
        }
        return result;
    }

    protected Map getRemovables() throws JspException {
        HashMap<Object, String> removeble;
        block3: {
            Object col;
            block4: {
                if (StringUtils.isEmpty((String)this.getRemoveCollection())) {
                    return null;
                }
                removeble = new HashMap<Object, String>();
                TagUtils util = TagUtils.getInstance();
                col = util.lookup(this.pageContext, this.getRemoveCollection(), this.getRemoveCollectionScope());
                if (col == null) break block3;
                if (!col.getClass().isArray()) break block4;
                Object[] array = (Object[])col;
                for (int i = 0; i < array.length; ++i) {
                    removeble.put(array[i] instanceof Lookup ? ((Lookup)array[i]).getCode() : array[i], "");
                }
                break block3;
            }
            if (!(col instanceof Collection)) break block3;
            for (Object obj : (Collection)col) {
                removeble.put(obj instanceof Lookup ? ((Lookup)obj).getCode() : obj, "");
            }
        }
        return removeble;
    }
}

