/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.taglib;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.ui.common.beans.VISNSite;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.struts.taglib.TagUtils;
import org.springframework.web.context.WebApplicationContext;

public class SetLookupP8Tag
extends BodyTagSupport {
    private static final long serialVersionUID = 2787899133475609011L;
    public static final String PAGE_SCOPE = "page";
    public static final String REQUEST_SCOPE = "request";
    public static final String SESSION_SCOPE = "session";
    public static final String APPLICATION_SCOPE = "application";
    public static final String VISN_CLASS = "gov.va.med.esr.common.model.lookup.VISN";
    public static final String VISN_SITE_CLASS = "gov.va.med.esr.ui.common.beans.VISNSite";
    public static final String SITE_CLASS = "gov.va.med.esr.ui.common.beans.PreferredFacility";
    public static final String VAFACILITY_CLASS = "gov.va.med.esr.common.model.lookup.VAFacility";
    public static final String HEC_USER_CLASS = "hec.user";
    private String className;
    private String var;
    private String scope;
    private String reportId;
    private String removeCollection = null;
    private String removeCollectionScope = null;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getRemoveCollection() {
        return this.removeCollection;
    }

    public void setRemoveCollection(String removeCollection) {
        this.removeCollection = removeCollection;
    }

    public String getRemoveCollectionScope() {
        return this.removeCollectionScope;
    }

    public void setRemoveCollectionScope(String removeCollectionScope) {
        this.removeCollectionScope = removeCollectionScope;
    }

    public int doStartTag() throws JspException {
        this.setLookup(this.getLookup(this.className));
        return 6;
    }

    public void release() {
        super.release();
        this.className = null;
        this.var = null;
        this.scope = null;
        this.removeCollection = null;
        this.removeCollectionScope = null;
    }

    protected Collection getLookup(String className) throws JspException {
        Collection list = null;
        try {
            ESRUserPrincipalImpl user;
            VAFacility userFacility;
            WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
            if (className.indexOf(HEC_USER_CLASS) < 0) {
                LookupCacheService lookupCacheService = (LookupCacheService)ac.getBean("lookupCacheService");
                list = this.filterCollection(lookupCacheService.getFromCache(className));
            }
            if ((userFacility = (user = (ESRUserPrincipalImpl)SecurityContextHelper.getCurrentUser()).getFacility()) == null) {
                return new ArrayList();
            }
            if (!this.isHECUser()) {
                list = this.userProfileSecuredList(list, className, userFacility);
            }
        }
        catch (Exception ex) {
            throw new JspException("Error while getting lookup data.", (Throwable)ex);
        }
        return list;
    }

    private boolean isHECUser() {
        boolean hecUser = false;
        ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)SecurityContextHelper.getCurrentUser();
        VAFacility userFacility = user.getFacility();
        if (userFacility != null) {
            String str;
            String stationNumber = userFacility.getStationNumber();
            if (stationNumber.equalsIgnoreCase(str = VAFacility.CODE_HEC.getName())) {
                hecUser = true;
            } else if (userFacility.getCode().equals(VAFacility.CODE_HEC)) {
                hecUser = true;
            }
        }
        return hecUser;
    }

    private Collection userProfileSecuredList(Collection list, String className, VAFacility userFacility) {
        if (list == null || userFacility == null) {
            return list;
        }
        if (className.indexOf(VISN_CLASS) > -1) {
            list = this.filterVISNList(list, userFacility);
        } else if (className.indexOf(SITE_CLASS) > -1) {
            list = this.filterSiteList(list, userFacility);
        } else if (className.indexOf(VAFACILITY_CLASS) > -1) {
            list = this.filterSiteList(list, userFacility);
        } else if (className.indexOf(VISN_SITE_CLASS) > -1) {
            list = this.filterVisnSiteList(list, userFacility);
        }
        return list;
    }

    private Collection filterVISNList(Collection list, VAFacility userFacility) {
        ArrayList securedList = new ArrayList();
        for (Object obj : list) {
            VISN visn = (VISN)obj;
            BigDecimal visnId = visn.getIdentifier();
            BigDecimal userFacilityVisnId = userFacility.getVisnId();
            if (visnId == null || userFacilityVisnId == null || visnId.compareTo(userFacilityVisnId) != 0) continue;
            securedList.add(obj);
            break;
        }
        return securedList;
    }

    private Collection filterSiteList(Collection list, VAFacility userFacility) {
        ArrayList securedList = new ArrayList();
        for (Object obj : list) {
            VAFacility facility = (VAFacility)obj;
            BigDecimal visnId = facility.getVisnId();
            BigDecimal userFacilityVisnId = userFacility.getVisnId();
            if (visnId == null || userFacilityVisnId == null || visnId.compareTo(userFacilityVisnId) != 0) continue;
            securedList.add(obj);
        }
        return securedList;
    }

    private Collection filterVisnSiteList(Collection list, VAFacility userFacility) {
        ArrayList securedList = new ArrayList();
        Iterator listIter = list.iterator();
        while (listIter.hasNext()) {
            Object facilityObj;
            Object obj = listIter.next();
            if (!(obj instanceof VISN)) continue;
            VISN facility = (VISN)obj;
            BigDecimal visnId = facility.getIdentifier();
            BigDecimal userFacilityVisnId = userFacility.getVisnId();
            if (visnId == null || userFacilityVisnId == null || visnId.compareTo(userFacilityVisnId) != 0) continue;
            securedList.add(obj);
            while (listIter.hasNext() && (facilityObj = listIter.next()) instanceof VISNSite) {
                securedList.add(facilityObj);
            }
            break block0;
        }
        return securedList;
    }

    protected void setLookup(Collection lookup) throws JspException {
        String localVar;
        String string = localVar = StringUtils.isNotEmpty((String)this.var) ? this.var : this.className;
        if (this.className.indexOf(HEC_USER_CLASS) >= 0) {
            if (this.isHECUser()) {
                this.setHECUserLookup();
            }
            return;
        }
        if (StringUtils.isEmpty((String)this.scope) || StringUtils.equals((String)this.scope, (String)PAGE_SCOPE)) {
            this.pageContext.setAttribute(localVar, (Object)lookup);
            if (this.className.indexOf(HEC_USER_CLASS) >= 0) {
                this.pageContext.setAttribute(localVar, (Object)"false");
            }
        } else {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (StringUtils.equals((String)this.scope, (String)REQUEST_SCOPE)) {
                request.setAttribute(localVar, (Object)lookup);
            } else if (StringUtils.equals((String)this.scope, (String)SESSION_SCOPE)) {
                request.getSession().setAttribute(localVar, (Object)lookup);
            } else if (StringUtils.equals((String)this.scope, (String)APPLICATION_SCOPE)) {
                request.getSession().getServletContext().setAttribute(localVar, (Object)lookup);
            }
        }
    }

    protected void setHECUserLookup() throws JspException {
        String localVar = "hecUserflag";
        String lookup = "true";
        if (StringUtils.isEmpty((String)this.scope) || StringUtils.equals((String)this.scope, (String)PAGE_SCOPE)) {
            this.pageContext.setAttribute(localVar, (Object)lookup);
        } else {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (StringUtils.equals((String)this.scope, (String)REQUEST_SCOPE)) {
                request.setAttribute(localVar, (Object)lookup);
            } else if (StringUtils.equals((String)this.scope, (String)SESSION_SCOPE)) {
                request.getSession().setAttribute(localVar, (Object)lookup);
            } else if (StringUtils.equals((String)this.scope, (String)APPLICATION_SCOPE)) {
                request.getSession().getServletContext().setAttribute(localVar, (Object)lookup);
            }
        }
    }

    protected Collection filterCollection(Collection list) throws JspException {
        if (list == null || list.isEmpty()) {
            return list;
        }
        Map removables = this.getRemovables();
        if (removables == null || removables.isEmpty()) {
            return list;
        }
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        for (Lookup lookup : list) {
            if (removables.get(lookup.getCode()) != null) continue;
            result.add(lookup);
        }
        return result;
    }

    protected Map getRemovables() throws JspException {
        HashMap<Object, String> removeble;
        block3: {
            Object col;
            block4: {
                if (StringUtils.isEmpty((String)this.getRemoveCollection())) {
                    return null;
                }
                removeble = new HashMap<Object, String>();
                TagUtils util = TagUtils.getInstance();
                col = util.lookup(this.pageContext, this.getRemoveCollection(), this.getRemoveCollectionScope());
                if (col == null) break block3;
                if (!col.getClass().isArray()) break block4;
                Object[] array = (Object[])col;
                for (int i = 0; i < array.length; ++i) {
                    removeble.put(array[i] instanceof Lookup ? ((Lookup)array[i]).getCode() : array[i], "");
                }
                break block3;
            }
            if (!(col instanceof Collection)) break block3;
            for (Object obj : (Collection)col) {
                removeble.put(obj instanceof Lookup ? ((Lookup)obj).getCode() : obj, "");
            }
        }
        return removeble;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }
}

