/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.taglib;

import gov.va.med.esr.ui.taglib.support.HtmlDisplayCheckBoxSortingProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import net.mlw.vlh.ValueListInfo;
import net.mlw.vlh.web.tag.ConfigurableTag;
import net.mlw.vlh.web.tag.ValueListSpaceTag;
import net.mlw.vlh.web.util.JspUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

public class PagingSelectedTag
extends ConfigurableTag {
    private static final long serialVersionUID = -7960507634063427309L;
    public static final String SELECTED_REQUEST_ATTRIBUTE_KEY = "selected";
    public static final String CHECKBOX_PARAM = "checkboxName";
    private int pages = 0;
    private boolean showSummary = false;
    private int page;
    private int total;
    private int qtyOnPage;
    private int numberOfPages;
    private int currentPage = 0;
    private int maxPage = 0;
    private ValueListSpaceTag _parent;
    private Map parameters;

    public int doStartTag() throws JspException {
        this._parent = (ValueListSpaceTag)JspUtils.getParent((Tag)this, ValueListSpaceTag.class);
        Locale local = this._parent.getConfig().getLocaleResolver().resolveLocale((HttpServletRequest)this.pageContext.getRequest());
        MessageSource message = this._parent.getConfig().getMessageSource();
        this.parameters = new HashMap(this._parent.getTableInfo().getParameters());
        this.parameters.remove(SELECTED_REQUEST_ATTRIBUTE_KEY);
        if (this.parameters.get(CHECKBOX_PARAM) == null) {
            throw new JspException("Can not find param: checkboxName.\nPlease addParam under root. Example\n<vlh:addParam name=\"checkboxName\" value=\"selected\" temp=\"false\"/>");
        }
        StringBuffer sb = new StringBuffer();
        this.page = this._parent.getValueList().getValueListInfo().getPagingPage();
        this.total = this._parent.getValueList().getValueListInfo().getTotalNumberOfEntries();
        this.qtyOnPage = this._parent.getValueList().getValueListInfo().getPagingNumberPer();
        this.numberOfPages = this._parent.getValueList().getValueListInfo().getTotalNumberOfPages();
        this.currentPage = this.page - this.pages / 2;
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
        this.maxPage = this.currentPage - 1 + this.pages;
        if (this.maxPage > this.numberOfPages) {
            this.currentPage -= this.maxPage - this.numberOfPages;
            this.maxPage = this.numberOfPages;
        }
        if (this.maxPage < 2) {
            this.maxPage = 0;
        }
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
        sb.append("\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"" + (this.getAttributes() == null ? "" : " " + this.getAttributes()) + ">\n");
        sb.append("  <tr>\n");
        if (this.showSummary) {
            sb.append(this.generateSumary(message, local));
            sb.append("     <td align=\"right\">\n");
            sb.append("\n      <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >\n");
            sb.append("          <tr>\n");
        }
        String value = null;
        String delim = this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.delim", null, "", local));
        sb.append(this.generateFocusControl(this._parent.getValueList().getValueListInfo(), delim, message, local));
        if (this.page > 1) {
            sb.append("   <td><a href=\"");
            sb.append(this.addScript(this.parameters.get(CHECKBOX_PARAM)));
            sb.append(this._parent.getTableInfo().getUrl());
            this.parameters.put("pagingPage" + this._parent.getTableInfo().getId(), "1");
            sb.append(this._parent.getConfig().getLinkEncoder().encode(this.pageContext, this.parameters));
            sb.append("')\">");
            value = this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.first(on)", null, local));
            sb.append(value).append("</a></td>\n");
            if (value.length() > 0 && delim.length() > 0) {
                sb.append("   <td>").append(delim).append("</td>\n");
            }
            sb.append("   <td><a href=\"");
            sb.append(this.addScript(this.parameters.get(CHECKBOX_PARAM)));
            sb.append(this._parent.getTableInfo().getUrl());
            this.parameters.put("pagingPage" + this._parent.getTableInfo().getId(), String.valueOf(this.page - 1));
            sb.append(this._parent.getConfig().getLinkEncoder().encode(this.pageContext, this.parameters));
            sb.append("')\">");
            value = this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.previous(on)", null, local));
            sb.append(value).append("</a></td>\n");
            if (value.length() > 0 && delim.length() > 0) {
                sb.append("   <td>").append(delim).append("</td>\n");
            }
        } else {
            sb.append("   <td>").append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.first(off)", null, local))).append("</td>\n");
            sb.append("   <td>").append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.previous(off)", null, local))).append("</td>\n");
        }
        JspUtils.write((PageContext)this.pageContext, (String)sb.toString());
        this.pageContext.setAttribute("page" + this._parent.getTableInfo().getId(), (Object)new Integer(this.currentPage));
        return 2;
    }

    private String addScript(Object fieldName) {
        return HtmlDisplayCheckBoxSortingProvider.addScript(fieldName);
    }

    private StringBuffer generateSumary(MessageSource message, Locale local) throws NoSuchMessageException, JspException {
        StringBuffer sb = new StringBuffer();
        sb.append(" <td nowrap=\"true\" valign=\"top\" align=\"left\">");
        sb.append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.text.totalRow", new Object[]{new Integer(this.total)}, local)));
        sb.append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.text.pageFromTotal", new Object[]{new Integer(this.page), new Integer(this.numberOfPages)}, local)));
        sb.append(" </td>\n");
        return sb;
    }

    private StringBuffer generateFocusControl(ValueListInfo info, String delim, MessageSource message, Locale local) throws JspException {
        StringBuffer sb = new StringBuffer();
        if (info.isFocusEnabled()) {
            this.parameters.put("focusProperty" + this._parent.getTableInfo().getId(), info.getFocusProperty());
            if (info.getFocusValue() != null) {
                this.parameters.put("focusValue" + this._parent.getTableInfo().getId(), info.getFocusValue());
            }
            HashMap<String, String> focusParameters = new HashMap<String, String>(this.parameters);
            if (info.getFocusStatus() != 4) {
                sb.append("   <td><a href=\"");
                sb.append(this.addScript(this.parameters.get(CHECKBOX_PARAM)));
                sb.append(this._parent.getTableInfo().getUrl());
                focusParameters.put("doFocus" + this._parent.getTableInfo().getId(), info.isDoFocusAgain() ? "false" : "true");
                sb.append(this._parent.getConfig().getLinkEncoder().encode(this.pageContext, focusParameters));
                sb.append("')\">");
                String value = this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage(info.isDoFocusAgain() ? "paging.focus(off)" : "paging.focus(on)", null, local));
                sb.append(value).append("</a></td>\n");
                if (value.length() > 0 && delim.length() > 0) {
                    sb.append("   <td>").append(delim).append("</td>\n");
                }
            } else if (info.isFocusEnabled()) {
                sb.append("   <td>").append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.focus(error)", null, local))).append("</td>\n");
            }
        } else {
            sb.append("   <td>").append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.focus(disabled)", null, local))).append("</td>\n");
        }
        return sb;
    }

    public int doAfterBody() throws JspException {
        if (this.currentPage <= this.maxPage) {
            String label = this.getBodyContent().getString().trim();
            StringBuffer sb = this.getRenderedContent(label);
            JspUtils.writePrevious((PageContext)this.pageContext, (String)sb.toString());
            this.pageContext.setAttribute("page" + this._parent.getTableInfo().getId(), (Object)new Integer(++this.currentPage));
            this.getBodyContent().clearBody();
            return 2;
        }
        return 0;
    }

    private StringBuffer getRenderedContent(String label) {
        StringBuffer sb = new StringBuffer();
        if (this.currentPage == this.page) {
            sb.append("<td>").append(label).append("</td>\n");
        } else {
            sb.append("<td><a href=\"");
            sb.append(this.addScript(this.parameters.get(CHECKBOX_PARAM)));
            sb.append(this._parent.getTableInfo().getUrl());
            this.parameters.put("pagingPage" + this._parent.getTableInfo().getId(), String.valueOf(this.currentPage));
            sb.append(this._parent.getConfig().getLinkEncoder().encode(this.pageContext, this.parameters));
            sb.append("')\">").append(label).append("</a></td>\n");
        }
        return sb;
    }

    public int doEndTag() throws JspException {
        Locale local = this._parent.getConfig().getLocaleResolver().resolveLocale((HttpServletRequest)this.pageContext.getRequest());
        MessageSource message = this._parent.getConfig().getMessageSource();
        StringBuffer sb = new StringBuffer();
        String value = null;
        String delim = this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.delim", null, local));
        if (this.getBodyContent() == null || this.getBodyContent().getString() == null || this.getBodyContent().getString().trim().length() <= 0) {
            while (this.currentPage <= this.maxPage) {
                sb.append(this.getRenderedContent(String.valueOf(this.currentPage)));
                ++this.currentPage;
            }
        }
        if (this.page < this.numberOfPages) {
            sb.append("   <td><a href=\"");
            sb.append(this.addScript(this.parameters.get(CHECKBOX_PARAM)));
            sb.append(this._parent.getTableInfo().getUrl());
            this.parameters.put("pagingPage" + this._parent.getTableInfo().getId(), String.valueOf(this.page + 1));
            sb.append(this._parent.getConfig().getLinkEncoder().encode(this.pageContext, this.parameters));
            value = this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.forward(on)", null, local));
            sb.append("')\">").append(value).append("</a></td>\n");
            if (value.length() > 0 && delim.length() > 0) {
                sb.append("   <td>").append(delim).append("</td>\n");
            }
            sb.append("   <td><a href=\"");
            sb.append(this.addScript(this.parameters.get(CHECKBOX_PARAM)));
            sb.append(this._parent.getTableInfo().getUrl());
            this.parameters.put("pagingPage" + this._parent.getTableInfo().getId(), String.valueOf(this.numberOfPages));
            sb.append(this._parent.getConfig().getLinkEncoder().encode(this.pageContext, this.parameters));
            sb.append("')\">");
            sb.append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.last(on)", null, local)));
            sb.append("</a></td>\n");
        } else {
            sb.append("   <td>").append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.forward(off)", null, local))).append("</td>\n");
            sb.append("   <td>").append(this._parent.getConfig().getDisplayHelper().help(this.pageContext, message.getMessage("paging.last(off)", null, local))).append("</td>\n");
        }
        sb.append("  </tr>\n");
        sb.append("</table>\n");
        if (this.showSummary) {
            sb.append("     </td>\n");
            sb.append("</table>\n");
        }
        JspUtils.write((PageContext)this.pageContext, (String)sb.toString());
        this.pages = 0;
        this.showSummary = false;
        this.resetAttributes();
        return 0;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setShowSummary(String showSummary) {
        this.showSummary = "true".equalsIgnoreCase(showSummary);
    }
}

