/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.taglib;

import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.taglib.BaseDisplayTag;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;

public class DisplayCurrency
extends BaseDisplayTag {
    private static final long serialVersionUID = 6682543388252780591L;
    private String scope = null;
    private String name = null;
    private String currencyProperty = null;
    private String nullText = null;
    private String currencyCountry = null;

    public int doStartTag() throws JspException {
        Object value = super.lookup(this.pageContext, this.name, this.currencyProperty, this.scope);
        Locale locale = this.getLocale(this.currencyCountry);
        String output = null;
        try {
            if (value == null) {
                if (this.nullText == null) {
                    output = JspUtils.displayValue((Object)value, (String)"");
                } else {
                    try {
                        BigDecimal defValue = new BigDecimal(this.nullText);
                        output = NumberFormat.getCurrencyInstance(locale).format(defValue);
                    }
                    catch (NumberFormatException nfe) {
                        output = this.nullText;
                    }
                }
            } else {
                output = NumberFormat.getCurrencyInstance(locale).format(value);
            }
        }
        catch (Exception ex) {
            throw new JspException(ex.getMessage());
        }
        super.write(this.pageContext, output, false);
        return 0;
    }

    private Locale getLocale(String countryCode) {
        if (countryCode == null) {
            return Locale.US;
        }
        if (countryCode.equalsIgnoreCase(Locale.CANADA.getISO3Country())) {
            return Locale.CANADA;
        }
        if (countryCode.equalsIgnoreCase(Locale.CANADA_FRENCH.getISO3Country())) {
            return Locale.CANADA_FRENCH;
        }
        if (countryCode.equalsIgnoreCase(Locale.CHINA.getISO3Country())) {
            return Locale.CHINA;
        }
        if (countryCode.equalsIgnoreCase(Locale.FRANCE.getISO3Country())) {
            return Locale.FRANCE;
        }
        if (countryCode.equalsIgnoreCase(Locale.GERMANY.getISO3Country())) {
            return Locale.GERMANY;
        }
        if (countryCode.equalsIgnoreCase(Locale.ITALY.getISO3Country())) {
            return Locale.ITALY;
        }
        if (countryCode.equalsIgnoreCase(Locale.JAPAN.getISO3Country())) {
            return Locale.JAPAN;
        }
        if (countryCode.equalsIgnoreCase(Locale.KOREA.getISO3Country())) {
            return Locale.KOREA;
        }
        if (countryCode.equalsIgnoreCase(Locale.TAIWAN.getISO3Country())) {
            return Locale.TAIWAN;
        }
        if (countryCode.equalsIgnoreCase(Locale.UK.getISO3Country())) {
            return Locale.UK;
        }
        if (countryCode.equalsIgnoreCase(Locale.US.getISO3Country())) {
            return Locale.US;
        }
        return null;
    }

    public String getNullText() {
        return this.nullText;
    }

    public void setNullText(String nullText) {
        this.nullText = nullText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrencyProperty() {
        return this.currencyProperty;
    }

    public void setCurrencyProperty(String currencyProperty) {
        this.currencyProperty = currencyProperty;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getCurrencyCountry() {
        return this.currencyCountry;
    }

    public void setCurrencyCountry(String currencyCountry) {
        this.currencyCountry = currencyCountry;
    }
}

