/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.taglib;

import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.taglib.BaseDisplayTag;
import java.util.Set;
import javax.servlet.jsp.JspException;

public class DisplayAddress
extends BaseDisplayTag {
    private static final long serialVersionUID = -3654584961843800926L;
    public static final String ADDR_TYPE_CORRESPONDENCE = "correspondence";
    public static final String ADDR_TYPE_TEMPORARY = "temporary";
    public static final String ADDR_TYPE_CONFIDENTIAL = "confidential";
    public static final String ADDR_TYPE_BUSINESS = "business";
    private String scope = null;
    private String name = null;
    private String addressCollection = null;
    private String addressType = null;
    private String nullText = null;
    private boolean filter = false;

    public int doStartTag() throws JspException {
        Object value = super.lookup(this.pageContext, this.name, this.addressCollection, this.scope);
        if (value == null) {
            return 0;
        }
        Set addrColl = (Set)value;
        String addressTypeCode = this.getAddressTypeCode(this.addressType);
        String output = null;
        try {
            output = JspUtils.displayAddress((Set)addrColl, (String)addressTypeCode);
        }
        catch (Exception ex) {
            throw new JspException(ex.getMessage());
        }
        super.write(this.pageContext, output, this.filter);
        return 0;
    }

    private String getAddressTypeCode(String addressType) {
        if (addressType == null) {
            return null;
        }
        if (addressType.equalsIgnoreCase(ADDR_TYPE_CORRESPONDENCE)) {
            return AddressType.CODE_PERMANENT_ADDRESS.getName();
        }
        if (addressType.equalsIgnoreCase(ADDR_TYPE_TEMPORARY)) {
            return AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getName();
        }
        if (addressType.equalsIgnoreCase(ADDR_TYPE_CONFIDENTIAL)) {
            return AddressType.CODE_CONFIDENTIAL_ADDRESS.getName();
        }
        if (addressType.equalsIgnoreCase(ADDR_TYPE_BUSINESS)) {
            return AddressType.CODE_BUSINESS_ADDRESS.getName();
        }
        return null;
    }

    public String getNullText() {
        return this.nullText;
    }

    public void setNullText(String nullText) {
        this.nullText = nullText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddressCollection() {
        return this.addressCollection;
    }

    public void setAddressCollection(String addressCollection) {
        this.addressCollection = addressCollection;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean getFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }
}

