/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.taglib;

import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.DelegatingActionUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.html.OptionsTag;
import org.apache.struts.taglib.html.SelectTag;
import org.springframework.web.context.WebApplicationContext;

public class CustomOptionsTag
extends OptionsTag {
    protected Map valueToLabelMap = new HashMap();
    private static final long serialVersionUID = 7621136698690373048L;

    protected Iterator getIterator(String col, String prop) throws JspException {
        Iterator iter = null;
        try {
            iter = super.getIterator(col, prop);
        }
        catch (JspException jspEx) {
            try {
                WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
                LookupCacheService lookupCacheService = (LookupCacheService)ac.getBean("lookupCacheService");
                Collection list = lookupCacheService.getFromCache(this.collection);
                if (list != null) {
                    iter = list.iterator();
                }
            }
            catch (Exception ex) {
                throw new JspException("Error while getting lookup data.", (Throwable)ex);
            }
        }
        return iter;
    }

    public int doEndTag() throws JspException {
        int returnValue = super.doEndTag();
        SelectTag selectTag = (SelectTag)this.pageContext.getAttribute("org.apache.struts.taglib.html.SELECT");
        if (selectTag == null) {
            throw new JspException(messages.getMessage("optionsTag.select"));
        }
        StringBuffer optionBuffer = new StringBuffer();
        String[] selectValues = this.getSelectValues(selectTag);
        if (selectValues != null) {
            for (int i = 0; i < selectValues.length; ++i) {
                String selectValue = selectValues[i];
                if (this.valueToLabelMap.get(selectValue) != null) continue;
                try {
                    WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
                    LookupCacheService lookupCacheService = (LookupCacheService)ac.getBean("lookupCacheService");
                    Lookup lookup = lookupCacheService.getByCodeFromCache(this.collection, selectValue);
                    if (lookup == null) continue;
                    AbstractNamedActiveLookup activeLookup = lookup instanceof AbstractNamedActiveLookup ? (AbstractNamedActiveLookup)lookup : null;
                    String flag = activeLookup != null && !activeLookup.isActive() ? "[Inactive] " : "";
                    String description = lookup.getDescription() == null ? "" : lookup.getDescription();
                    this.addOption(optionBuffer, selectValue, flag + description, selectTag.isMatched(selectValue));
                    continue;
                }
                catch (ClassNotFoundException classCastEx) {
                    continue;
                }
                catch (Exception ex) {
                    throw new JspException("Error while getting lookup data.", (Throwable)ex);
                }
            }
        }
        TagUtils.getInstance().write(this.pageContext, optionBuffer.toString());
        return returnValue;
    }

    protected String[] getSelectValues(SelectTag selectTag) throws JspException {
        String[] returnValues;
        String selectValue = selectTag.getValue();
        String selectName = selectTag.getName();
        String selectProperty = selectTag.getProperty();
        if (selectValue != null) {
            returnValues = new String[]{selectValue};
        } else {
            Object bean = TagUtils.getInstance().lookup(this.pageContext, selectName, null);
            if (bean == null) {
                JspException e = new JspException(messages.getMessage("getter.bean", (Object)this.name));
                TagUtils.getInstance().saveException(this.pageContext, (Throwable)e);
                throw e;
            }
            try {
                returnValues = BeanUtils.getArrayProperty((Object)bean, (String)selectProperty);
                if (returnValues == null) {
                    returnValues = new String[]{};
                }
            }
            catch (IllegalAccessException e) {
                TagUtils.getInstance().saveException(this.pageContext, (Throwable)e);
                throw new JspException(messages.getMessage("getter.access", (Object)this.property, (Object)this.name));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                TagUtils.getInstance().saveException(this.pageContext, t);
                throw new JspException(messages.getMessage("getter.result", (Object)this.property, (Object)t.toString()));
            }
            catch (NoSuchMethodException e) {
                TagUtils.getInstance().saveException(this.pageContext, (Throwable)e);
                throw new JspException(messages.getMessage("getter.method", (Object)this.property, (Object)this.name));
            }
        }
        return returnValues;
    }

    protected void addOption(StringBuffer sb, String value, String label, boolean matched) {
        super.addOption(sb, value, label, matched);
        this.valueToLabelMap.put(value, label);
    }

    public void release() {
        super.release();
        this.valueToLabelMap = new HashMap();
    }
}

