/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.signature.action;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.signature.action.SignatureViewForm;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SignatureViewAction
extends PersonAbstractAction {
    public void afterPropertiesSet() throws Exception {
    }

    private List getSignatures(Person person) {
        if (person == null || person.getSignatureImages() == null || person.getSignatureImages().size() == 0) {
            return null;
        }
        Set signatureImages = person.getSignatureImages();
        ArrayList<SignatureImage> signatures = new ArrayList<SignatureImage>();
        LookupCacheService cacheService = this.getLookupCacheService();
        for (SignatureImage image : signatureImages) {
            SignatureImage newImage = (SignatureImage)image.clone();
            try {
                Lookup lookup = cacheService.getByCodeFromCache(ESRUserPrincipalImpl.class, newImage.getUser());
                if (lookup != null) {
                    newImage.setUser(lookup.getDescription());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            signatures.add(newImage);
        }
        Collections.sort(signatures);
        return signatures;
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SignatureViewForm signatureForm = form instanceof SignatureViewForm ? (SignatureViewForm)form : null;
        Person person = this.getSelectedPerson(request);
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)signatureForm, (HttpServletRequest)request, (String)"signatureTableId", (String)"signatureAdapter", (List)this.getSignatures(person));
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        return mapping.findForward("success");
    }
}

