/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.signature.action;

import gov.va.med.esr.common.model.lookup.SignatureIndicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.esr.ui.signature.action.SignatureEditForm;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SignatureEditAction
extends PersonAbstractAction {
    private FinancialsService financialsService;

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SignatureEditForm signatureForm = form instanceof SignatureEditForm ? (SignatureEditForm)form : null;
        Validate.notNull((Object)((Object)signatureForm), (String)"SignatureEditForm bean is null.");
        String selectedSignatureKey = signatureForm.getSelectedSignatureKey();
        Person person = this.getSelectedPerson(request);
        SignatureImage signature = this.getSignatureImage(person, selectedSignatureKey);
        UIConversionService uiConversionService = (UIConversionService)this.conversionService;
        uiConversionService.convert(signature, (Object)signatureForm);
        return mapping.findForward("edit");
    }

    private SignatureImage getSignatureImage(Person person, String selectedSignatureKey) {
        if (person.getSignatureImages() != null) {
            return person.getSignatureImageByEntityKey(EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(selectedSignatureKey), SignatureImage.class));
        }
        return null;
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SignatureEditForm signatureForm = form instanceof SignatureEditForm ? (SignatureEditForm)form : null;
        Validate.notNull((Object)((Object)signatureForm), (String)"SignatureEditForm bean is null.");
        String selectedSignatureKey = signatureForm.getSelectedSignatureKey();
        Person person = this.getSelectedPerson(request);
        SignatureImage signature = this.getSignatureImage(person, selectedSignatureKey);
        if (signature != null) {
            SignatureIndicator indicator = signature.getSignatureIndicator();
            UIConversionService uiConversionService = (UIConversionService)this.conversionService;
            uiConversionService.convert((Object)signatureForm, signature);
            if (signature.getSignatureIndicator() != null && !signature.getSignatureIndicator().equals((Object)indicator)) {
                SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
                UserPrincipal user = securityContext.getUserPrincipal();
                signature.setUser(user.getName());
            }
            Person updatedPerson = this.getFinancialsService().updatePersonSignature(person);
            this.updateSelectedPerson(request, updatedPerson);
        } else {
            log.error((Object)"update signature: Can not find SignatureImage with selected ImageID ");
        }
        return mapping.findForward("update");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    @Override
    public FinancialsService getFinancialsService() {
        return this.financialsService;
    }

    @Override
    public void setFinancialsService(FinancialsService financialsService) {
        this.financialsService = financialsService;
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.cancel", "cancel");
        map.put("button.update", "update");
        map.put("link.edit", "edit");
        return map;
    }
}

