/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.lookup.ReportRunFrequency;
import gov.va.med.esr.common.model.lookup.ReportScheduleType;
import gov.va.med.esr.common.report.data.ParameterConfig;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.report.action.ReportConstants;
import gov.va.med.esr.ui.report.action.ReportInfoForm;
import gov.va.med.esr.ui.report.action.ReportScheduleInfoForm;
import gov.va.med.fw.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class ReportValidator
implements ReportConstants {
    public static final String CURRENT_MONTH_NOT_VALID = "errors.currentMonthNotValid";

    protected static ActionErrors validate(ReportInfoForm actionForm, HttpServletRequest request, ActionErrors errors) {
        ReportScheduleInfoForm form = (ReportScheduleInfoForm)actionForm;
        ServletContext context = request.getSession().getServletContext();
        Map parameterMap = (Map)context.getAttribute("reportParamConfigMap");
        if (errors == null) {
            errors = new ActionErrors();
        }
        MessageResources messageResources = form.getResources(request);
        String reportId = form.getReportIdNoSpace();
        Map reportParamMap = (Map)parameterMap.get(reportId);
        if (reportParamMap != null) {
            if (StringUtils.equals((String)form.getTabName(), (String)"scheduledReports")) {
                ReportValidator.validateReportSceduleParams(form, messageResources, errors);
            }
            if (StringUtils.equals((String)reportId, (String)"EED10") && (!StringUtils.equals((String)"scheduledReports", (String)form.getTabName()) || StringUtils.equals((String)ReportRunFrequency.OTHER.getCode(), (String)form.getGenerateReport()))) {
                ReportValidator.validateForEED10(form, messageResources, errors, reportParamMap);
            }
            for (String fieldName : reportParamMap.keySet()) {
                ParameterConfig paramConfig = (ParameterConfig)reportParamMap.get(fieldName);
                if (paramConfig != null) {
                    String fieldValue;
                    boolean isRequiredField = paramConfig.isRequired();
                    boolean isFieldOptionalForScheduling = false;
                    boolean isFutureDateAllowed = paramConfig.isFutureDateAllowed();
                    if ((StringUtils.equals((String)fieldName, (String)"fromDate") || StringUtils.equals((String)fieldName, (String)"toDate") || StringUtils.equals((String)fieldName, (String)"fromYear") || StringUtils.equals((String)fieldName, (String)"toYear") || StringUtils.equals((String)fieldName, (String)"asOfDate")) && StringUtils.equals((String)"scheduledReports", (String)form.getTabName())) {
                        isFieldOptionalForScheduling = true;
                        if (StringUtils.equals((String)ReportRunFrequency.OTHER.getCode(), (String)form.getGenerateReport())) {
                            isFutureDateAllowed = true;
                        }
                    }
                    if (isRequiredField && !ReportValidator.isProvided(form, fieldName)) {
                        if (isFieldOptionalForScheduling) {
                            if (StringUtils.equals((String)ReportRunFrequency.OTHER.getCode(), (String)form.getGenerateReport())) {
                                errors.add(fieldName, new ActionMessage("errors.required", (Object)messageResources.getMessage(paramConfig.getLabel())));
                            }
                        } else {
                            errors.add(fieldName, new ActionMessage("errors.required", (Object)messageResources.getMessage(paramConfig.getLabel())));
                        }
                    }
                    if (StringUtils.isNotEmpty((String)(fieldValue = ReportValidator.getFieldValueAsString(form, fieldName))) && paramConfig.isDate()) {
                        if (paramConfig.isPreciseDate()) {
                            ReportValidator.validateDate(fieldValue, fieldName, isFutureDateAllowed, messageResources.getMessage(paramConfig.getLabel()), (ActionMessages)errors);
                        } else {
                            boolean isMonthRequired = StringUtils.equals((String)reportId, (String)"EED10");
                            ReportValidator.validateImpreciseDate(fieldValue, fieldName, isFutureDateAllowed, isMonthRequired, messageResources.getMessage(paramConfig.getLabel()), (ActionMessages)errors);
                        }
                    }
                }
                if (StringUtils.equals((String)fieldName, (String)"toYear")) {
                    ReportValidator.validateFromAndToYears(form, reportParamMap, messageResources, errors);
                }
                if (StringUtils.equals((String)fieldName, (String)"toDate")) {
                    ReportValidator.validateFromAndToDates(form, reportParamMap, messageResources, errors);
                }
                if (!StringUtils.equals((String)fieldName, (String)"facilities") || !StringUtils.isNotEmpty((String)form.getFacilityDisplayByNoDefault()) || ReportValidator.isProvided(form, fieldName)) continue;
                errors.add(fieldName, new ActionMessage("errors.required", (Object)messageResources.getMessage(paramConfig.getLabel())));
            }
        }
        ReportValidator.validateStartAndEndIncomeYears(form, reportParamMap, messageResources, errors);
        if (StringUtils.equals((String)reportId, (String)"QM10")) {
            ReportValidator.validateForQM10(form, messageResources, errors);
        }
        if (StringUtils.equals((String)reportId, (String)"QM17") && StringUtils.equals((String)form.getReportFormat(), (String)ReportFormat.DETAIL.getCode()) && !ReportValidator.isProvided(form, "reportDetailBy")) {
            errors.add("reportDetailBy", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.reportDetailsBy")));
        }
        return errors;
    }

    private static boolean isProvided(ReportScheduleInfoForm form, String fieldName) {
        try {
            Object object = ReportValidator.getFieldValue(form, fieldName);
            if (object == null || object instanceof String && StringUtils.isEmpty((String)((String)object).trim()) || object instanceof String[] && ((String[])object).length == 0) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    private static Object getFieldValue(ReportScheduleInfoForm form, String fieldName) {
        try {
            PropertyUtilsBean propertyUtils = new PropertyUtilsBean();
            return propertyUtils.getNestedProperty((Object)form, fieldName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getFieldValueAsString(ReportScheduleInfoForm form, String fieldName) {
        try {
            PropertyUtilsBean propertyUtils = new PropertyUtilsBean();
            Object object = propertyUtils.getNestedProperty((Object)form, fieldName);
            return object != null && object instanceof String ? StringUtils.trim((String)((String)object)) : null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void validateFromAndToYears(ReportScheduleInfoForm form, Map reportParamMap, MessageResources messageResources, ActionErrors errors) {
        if (StringUtils.isNotEmpty((String)form.getFromYear()) && StringUtils.isNotEmpty((String)form.getToYear())) {
            try {
                int fromYear = Integer.parseInt(form.getFromYear());
                int toYear = Integer.parseInt(form.getToYear());
                if (fromYear > 0 && toYear > 0 && fromYear > toYear) {
                    ParameterConfig fromDateParamConfig = (ParameterConfig)reportParamMap.get("fromYear");
                    ParameterConfig toDateParamConfig = (ParameterConfig)reportParamMap.get("toYear");
                    errors.add("toYear", new ActionMessage("errors.invalidStartEndDates", (Object)messageResources.getMessage(toDateParamConfig.getLabel()), (Object)messageResources.getMessage(fromDateParamConfig.getLabel())));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private static void validateStartAndEndIncomeYears(ReportScheduleInfoForm form, Map reportParamMap, MessageResources messageResources, ActionErrors errors) {
        if (StringUtils.isNotEmpty((String)form.getBeginIncomeYear()) && StringUtils.isNotEmpty((String)form.getEndIncomeYear())) {
            try {
                int startIncomeYear = Integer.parseInt(form.getBeginIncomeYear());
                int endIncomeYear = Integer.parseInt(form.getEndIncomeYear());
                if (startIncomeYear > 0 && endIncomeYear > 0 && startIncomeYear > endIncomeYear) {
                    ParameterConfig startIncomeYearParamConfig = (ParameterConfig)reportParamMap.get("beginIncomeYear");
                    ParameterConfig endIncomeYearParamConfig = (ParameterConfig)reportParamMap.get("endIncomeYear");
                    errors.add("endIncomeYear", new ActionMessage("errors.invalidStartEndDates", (Object)messageResources.getMessage(endIncomeYearParamConfig.getLabel()), (Object)messageResources.getMessage(startIncomeYearParamConfig.getLabel())));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private static void validateFromAndToDates(ReportScheduleInfoForm form, Map reportParamMap, MessageResources messageResources, ActionErrors errors) {
        Date fromDate = ReportValidator.getDate(form.getFromDate());
        Date toDate = ReportValidator.getDate(form.getToDate());
        if (fromDate != null && toDate != null) {
            ParameterConfig fromDateParamConfig = (ParameterConfig)reportParamMap.get("fromDate");
            ParameterConfig toDateParamConfig = (ParameterConfig)reportParamMap.get("toDate");
            if (fromDateParamConfig != null && toDateParamConfig != null && fromDate.after(toDate)) {
                errors.add("toDate", new ActionMessage("errors.invalidStartEndDates", (Object)messageResources.getMessage(toDateParamConfig.getLabel()), (Object)messageResources.getMessage(fromDateParamConfig.getLabel())));
            }
            if (toDateParamConfig.getDateRangeInDays() > 0 && !ReportValidator.isDatesInRange(fromDate, toDate, toDateParamConfig.getDateRangeInDays())) {
                errors.add("toDate", new ActionMessage("errors.invalidDateRange", (Object)new Integer(toDateParamConfig.getDateRangeInDays())));
            }
        }
    }

    private static boolean isDatesInRange(Date startDate, Date endDate, int dateRangeInDays) {
        Long days = startDate != null && endDate != null ? DateUtils.getDays((Date)startDate, (Date)endDate) : null;
        return days != null && days <= (long)dateRangeInDays;
    }

    private static void validateForEED10(ReportScheduleInfoForm form, MessageResources messageResources, ActionErrors errors, Map reportParamMap) {
        String fromDate = form.getFromDate();
        String toDate = form.getToDate();
        String asOfDate = form.getAsOfDate();
        if (StringUtils.isNotEmpty((String)fromDate) && StringUtils.isEmpty((String)toDate)) {
            ParameterConfig paramConfig = (ParameterConfig)reportParamMap.get("toDate");
            errors.add("toDate", new ActionMessage("errors.required", (Object)messageResources.getMessage(paramConfig.getLabel())));
            return;
        }
        if (StringUtils.isEmpty((String)fromDate) && StringUtils.isNotEmpty((String)toDate)) {
            ParameterConfig paramConfig = (ParameterConfig)reportParamMap.get("fromDate");
            errors.add("fromDate", new ActionMessage("errors.required", (Object)messageResources.getMessage(paramConfig.getLabel())));
            return;
        }
        if (StringUtils.isEmpty((String)fromDate) && StringUtils.isEmpty((String)toDate) && StringUtils.isEmpty((String)asOfDate)) {
            errors.add("fromDate", new ActionMessage("errors.fromDateToDatesOrAsOfDateRequired"));
            errors.add("toDate", new ActionMessage("errors.fromDateToDatesOrAsOfDateRequired"));
            errors.add("asOfDate", new ActionMessage("errors.fromDateToDatesOrAsOfDateRequired"));
            return;
        }
        if ((StringUtils.isNotEmpty((String)fromDate) || StringUtils.isNotEmpty((String)toDate)) && StringUtils.isNotEmpty((String)asOfDate)) {
            errors.add("fromDate", new ActionMessage("errors.bothFromDateToDatesAndAsOfDateNotAllowed"));
            errors.add("toDate", new ActionMessage("errors.bothFromDateToDatesAndAsOfDateNotAllowed"));
            errors.add("asOfDate", new ActionMessage("errors.bothFromDateToDatesAndAsOfDateNotAllowed"));
            return;
        }
    }

    private static void validateForQM10(ReportScheduleInfoForm form, MessageResources messageResources, ActionErrors errors) {
        String reportPeriodType = form.getReportPeriodType();
        boolean isFutureDateAllowed = false;
        if (StringUtils.equals((String)reportPeriodType, (String)ReportPeriodType.CODE_DATE_RANGE.getCode())) {
            boolean isFromAndToDateRequired = true;
            if (StringUtils.equals((String)"scheduledReports", (String)form.getTabName())) {
                isFromAndToDateRequired = StringUtils.equals((String)ReportRunFrequency.OTHER.getCode(), (String)form.getGenerateReport());
                isFutureDateAllowed = true;
            }
            if (isFromAndToDateRequired) {
                if (!ReportValidator.isProvided(form, "reportPeriodStartDate")) {
                    errors.add("reportPeriodStartDate", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.from")));
                }
                if (!ReportValidator.isProvided(form, "reportPeriodEndDate")) {
                    errors.add("reportPeriodEndDate", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.to")));
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(2002, 9, 1);
            Date fromDate = ReportValidator.getDate(form.getReportPeriodStartDate());
            Date toDate = ReportValidator.getDate(form.getReportPeriodEndDate());
            ReportValidator.validateDate(form.getReportPeriodStartDate(), "reportPeriodStartDate", isFutureDateAllowed, messageResources.getMessage("label.report.from"), (ActionMessages)errors);
            ReportValidator.validateDate(form.getReportPeriodEndDate(), "reportPeriodEndDate", isFutureDateAllowed, messageResources.getMessage("label.report.to"), (ActionMessages)errors);
            if (fromDate != null && fromDate.compareTo(calendar.getTime()) < 0) {
                errors.add("reportPeriodStartDate", new ActionMessage("errors.invalidFromDate", (Object)DateUtils.format((Date)calendar.getTime(), (String)"MM/dd/yyyy")));
            }
            if (fromDate != null && toDate != null && fromDate.after(toDate)) {
                errors.add("reportPeriodEndDate", new ActionMessage("errors.invalidStartEndDates", (Object)messageResources.getMessage("label.report.to"), (Object)messageResources.getMessage("label.report.from")));
            }
        } else if (StringUtils.equals((String)reportPeriodType, (String)ReportPeriodType.CODE_ALL_FISCAL_YEARS.getCode())) {
            if (!ReportValidator.isProvided(form, "asOfDate")) {
                errors.add("asOfDate", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.asOfDate")));
            } else {
                ReportValidator.validateDate(form.getAsOfDate(), "asOfDate", false, messageResources.getMessage("label.report.asOfDate"), (ActionMessages)errors);
            }
        }
    }

    private static void validateReportSceduleParams(ReportScheduleInfoForm form, MessageResources messageResources, ActionErrors errors) {
        if (!ReportValidator.isProvided(form, "generateReport")) {
            errors.add("generateReport", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.generateReport")));
        } else {
            String generateReport = form.getGenerateReport();
            String scheduleType = form.getScheduleType();
            if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.DAILY_WEEKLY.getCode())) {
                if (!ReportValidator.isProvided(form, "dailyWeeklyDay")) {
                    errors.add("dailyWeeklyDay", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.dayToGenerateReport")));
                }
            } else if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.MONTHLY.getCode())) {
                if (!StringUtils.equals((String)scheduleType, (String)ReportScheduleType.DAY_OF_MONTH.getCode()) && !StringUtils.equals((String)scheduleType, (String)ReportScheduleType.WEEK_DAY.getCode())) {
                    errors.add("scheduleType", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.dayToGenerateReport")));
                }
            } else if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.YEARLY.getCode())) {
                if (StringUtils.equals((String)scheduleType, (String)ReportScheduleType.WEEK_DAY_MONTH.getCode()) || StringUtils.equals((String)scheduleType, (String)ReportScheduleType.MONTH_DAY.getCode())) {
                    if (StringUtils.equals((String)scheduleType, (String)ReportScheduleType.MONTH_DAY.getCode()) && !ReportValidator.isProvided(form, "yearlyDayOfMonth")) {
                        errors.add("scheduleType", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.dayOfMonth")));
                    }
                } else {
                    errors.add("scheduleType", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.dayToGenerateReport")));
                }
            } else if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.OTHER.getCode())) {
                if (!ReportValidator.isProvided(form, "otherDateToGenerateReport")) {
                    errors.add("otherDateToGenerateReport", new ActionMessage("errors.required", (Object)messageResources.getMessage("label.report.dateToGenerateReport")));
                } else {
                    Date dateToGenerate = ReportValidator.getDate(form.getOtherDateToGenerateReport(), form.getTimeToGenerateReportHourNoDefault(), form.getTimeToGenerateReportMinuteNoDefault());
                    if (dateToGenerate != null && dateToGenerate.before(DateUtils.getCurrentDateTime())) {
                        errors.add("otherDateToGenerateReport", new ActionMessage("errors.validateDatePast", (Object)messageResources.getMessage("label.report.dateToGenerateReport")));
                    }
                }
            }
            ReportValidator.validateEmail(form, messageResources, errors);
        }
    }

    private static boolean validateDate(String fieldValue, String fieldName, boolean isFutureDateAllowed, String fieldLabel, ActionMessages errors) {
        boolean isValid = true;
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            try {
                Date date = DateUtils.getDate((String)fieldValue);
                if (date != null && !isFutureDateAllowed && date.after(new Date())) {
                    isValid = false;
                    errors.add(fieldName, new ActionMessage("errors.validateDateFuture", (Object)fieldLabel));
                }
            }
            catch (Exception ex) {
                isValid = false;
                errors.add(fieldName, new ActionMessage("errors.invalid", (Object)fieldLabel));
            }
        }
        return isValid;
    }

    private static boolean validateImpreciseDate(String fieldValue, String fieldName, boolean isFutureDateAllowed, boolean isMonthRequired, String fieldLabel, ActionMessages errors) {
        boolean isValid = true;
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            try {
                ImpreciseDate date = DateUtils.getImpreciseDate((String)fieldValue);
                if (date != null && !isFutureDateAllowed) {
                    Calendar currDate = Calendar.getInstance();
                    Calendar dateValue = date.getCalendar();
                    if (currDate.getTime().before(dateValue.getTime())) {
                        isValid = false;
                        errors.add(fieldName, new ActionMessage("errors.validateDateFuture", (Object)fieldLabel));
                    }
                }
                if (date != null && isValid && isMonthRequired && !date.isMonthPrecise()) {
                    isValid = false;
                    errors.add(fieldName, new ActionMessage("errors.imprecisedateWithMonth", (Object)fieldLabel));
                }
            }
            catch (Exception ex) {
                isValid = false;
                errors.add(fieldName, new ActionMessage("errors.invalid", (Object)fieldLabel));
            }
        }
        return isValid;
    }

    private static Date getDate(String fieldValue) {
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            try {
                return DateUtils.getDate((String)fieldValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Date getDate(String date, String hours, String minutes) {
        Date dt = ReportValidator.getDate(date);
        Calendar cal = null;
        if (dt != null) {
            cal = Calendar.getInstance();
            cal.clear();
            cal.setTime(dt);
            int hrs = StringUtils.isNotEmpty((String)hours) ? Integer.parseInt(hours) : 0;
            int mns = StringUtils.isNotEmpty((String)minutes) ? Integer.parseInt(minutes) : 0;
            cal.set(10, hrs);
            cal.set(12, mns);
        }
        return cal != null ? cal.getTime() : null;
    }

    private static void validateEmail(ReportScheduleInfoForm form, MessageResources messageResources, ActionErrors errors) {
        String emailReportTo = form.getEmailReportTo();
        Pattern pat = Pattern.compile("[a-zA-Z][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]", 2);
        if (StringUtils.isNotEmpty((String)emailReportTo)) {
            String[] emails = StringUtils.split((String)emailReportTo, (String)" ,;");
            for (int i = 0; i < emails.length; ++i) {
                String email = StringUtils.trim((String)emails[i]);
                if (!StringUtils.isNotEmpty((String)email) || pat.matcher(email).find()) continue;
                errors.add("emailReportTo", new ActionMessage("errors.email", (Object)messageResources.getMessage("label.report.emailReportTo")));
                return;
            }
        }
    }
}

