/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.ReportFilterSearchQueryInfo;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.report.action.ReportFilterForm;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;
import org.apache.struts.action.ActionForm;

public class ReportFilterValueListAdapter
extends SearchValueListAdapter {
    private static final long serialVersionUID = 2221251983336361625L;
    private LookupCacheService lookupCacheService = null;

    protected void populateFormAttributes(ActionForm form, SearchQueryInfo queryInfo) throws ValueListException {
        ReportFilterForm filterForm = (ReportFilterForm)form;
        ReportFilterSearchQueryInfo searchQueryInfo = (ReportFilterSearchQueryInfo)queryInfo;
        searchQueryInfo.setDateFrom(DateUtils.getDate((String)filterForm.getDateFrom()));
        searchQueryInfo.setDateTo(DateUtils.getDate((String)filterForm.getDateTo()));
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        searchQueryInfo.setUser(securityContext != null ? securityContext.getUserPrincipal() : null);
        if (StringUtils.isNotEmpty((String)filterForm.getFileType())) {
            try {
                searchQueryInfo.setReportExportedType(this.getLookupService().getReportExportedTypeByCode(filterForm.getFileType()));
            }
            catch (Exception ex) {
                throw new ValueListException("Invalid Report Exported Type Code: " + filterForm.getFileType(), (Throwable)ex);
            }
        }
        if (StringUtils.isNotEmpty((String)filterForm.getReportId()) || StringUtils.isNotEmpty((String)filterForm.getReportTitle())) {
            String standardReportCode = filterForm.getReportTitle();
            if (StringUtils.isNotEmpty((String)filterForm.getReportId())) {
                standardReportCode = filterForm.getReportId();
            }
            try {
                searchQueryInfo.setStandardReport(this.getLookupService().getStandardReportByCode(standardReportCode));
            }
            catch (Exception ex) {
                throw new ValueListException("Invalid Standard Report Code: " + standardReportCode, (Throwable)ex);
            }
        }
        if (StringUtils.isNotEmpty((String)filterForm.getReportType())) {
            try {
                searchQueryInfo.setReportType(this.getLookupService().getReportTypeByCode(filterForm.getReportType()));
            }
            catch (Exception ex) {
                throw new ValueListException("Invalid Report Type Code: " + filterForm.getReportType(), (Throwable)ex);
            }
        }
    }

    public LookupService getLookupService() {
        return this.lookupCacheService != null ? this.lookupCacheService.getLookupService() : null;
    }

    public LookupCacheService getLookupCacheService() {
        return this.lookupCacheService;
    }

    public void setLookupCacheService(LookupCacheService lookupCacheService) {
        this.lookupCacheService = lookupCacheService;
    }
}

